# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Ads
    module AdManager
      module V1
        module AdReviewCenterAdService
          # Path helper methods for the AdReviewCenterAdService API.
          module Paths
            ##
            # Create a fully-qualified AdReviewCenterAd resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/webProperties/{web_property_code}/adReviewCenterAds/{ad_review_center_ad}`
            #
            # @param network_code [String]
            # @param web_property_code [String]
            # @param ad_review_center_ad [String]
            #
            # @return [::String]
            def ad_review_center_ad_path network_code:, web_property_code:, ad_review_center_ad:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"
              raise ::ArgumentError, "web_property_code cannot contain /" if web_property_code.to_s.include? "/"

              "networks/#{network_code}/webProperties/#{web_property_code}/adReviewCenterAds/#{ad_review_center_ad}"
            end

            ##
            # Create a fully-qualified WebProperty resource string.
            #
            # The resource will be in the following format:
            #
            # `networks/{network_code}/webProperties/{web_property}`
            #
            # @param network_code [String]
            # @param web_property [String]
            #
            # @return [::String]
            def web_property_path network_code:, web_property:
              raise ::ArgumentError, "network_code cannot contain /" if network_code.to_s.include? "/"

              "networks/#{network_code}/webProperties/#{web_property}"
            end

            extend self
          end
        end
      end
    end
  end
end
