# Google Cloud Ruby Clients

Idiomatic Ruby client libraries for
[Google Cloud Platform](https://cloud.google.com/) APIs.

* [Homepage](https://github.com/googleapis/google-cloud-ruby/)
* [Reference documentation](https://cloud.google.com/ruby/docs/reference)

This repository includes client libraries for Google Cloud Platform services,
along with a selected set of Google services unrelated to the cloud platform.

## What's here

### Client library gems

Most directories each correspond to a client library RubyGem, including its
code, tests, gemspec, and documentation. Some client libraries also include
handwritten samples in the `samples` directory, and/or autogenerated samples
in the `snippets` directory.

Most client libraries in this repository are automatically generated by the
[GAPIC Generator](https://github.com/googleapis/gapic-generator-ruby). A small
number are written and maintained by hand. You can identify a generated client
library by the presence of `.OwlBot.yaml` in the library directory. For the
most part, do not try to edit generated libraries by hand, because changes will
be overwritten by the code generator.

### Other directories

A few directories include support files, including:

*   `.github` includes configuration for GitHub Actions and bots that help to
    maintain this repository.
*   `.kokoro` includes configuration for internal Google processes that help to
    maintain this repository.
*   `.toys` includes scripts for running CI, releases, and maintenance tasks.
*   `acceptance` and `integration` include shared fixtures for acceptance tests.
*   `obsolete` contains older libraries that are obsolete and no longer
    maintained.

### GitHub facilities

Issues for client libraries hosted here can be filed in the
[issues tab](https://github.com/googleapis/google-cloud-ruby/issues). However,
this is not an official support channel. If you have support questions, file a
support request through the normal Google support channels, or post questions
on a forum such as StackOverflow.

[Pull requests](https://github.com/googleapis/google-cloud-ruby/pulls) are
welcome. Please see the section below on [contributing](#contributing).

Some maintenance tasks can be run in the
[actions tab](https://github.com/googleapis/google-cloud-ruby/actions) by
authorized personnel.

## Using the client libraries

These client library RubyGems each include classes and methods that can be used
to make authenticated calls to specific Google APIs. Some libraries also
include additional convenience code implementing common client-side workflows
or best practices.

In general, you can expect to:

1.  [Activate access](#activating-the-api) to the API by creating a project on
    the [Google Cloud Console](https://console.cloud.google.com), enabling
    billing if necessary, and enabling the API.

2.  [Choose a library](#choosing-a-client-library) and install it, typically by
    adding it to your [bundle](https://bundler.io). For example, here is how
    you might add a the Translation service client to your Gemfile:

    ```ruby
    # Gemfile

    # ... previous libraries ...
    gem "google-cloud-translate", "~> 3.2"
    ```

3.  Instantiate a client object. This object represents an authenticated
    connection to the service. For example, here is how you might create a
    client for the translation service:

    ```ruby
    require "google/cloud/translate"

    translation_client = Google::Cloud::Translate.translation_service
    ```

    Depending on your environment and authentication needs, you might need to
    [provide credentials](#authentication) to the client object.

4.  Make API calls by invoking methods on the client. For example, here is how
    you might translate a phrase:

    ```ruby
    result = translation_client.translate_text contents: ["Hello, world!"],
                                               mime_type: "text/plain",
                                               source_language_code: "en-US",
                                               target_language_code: "ja-JP",
                                               parent: "projects/my-project-name"
    puts result.translations.first.translated_text
    # => "こんにちは世界！"
    ```

### Activating the API

To access a Google Cloud API, you will generally need to activate it in the
cloud console. This typically involves three steps:

1.  If you have not created a
    [Google Cloud Project](https://cloud.google.com/docs/overview#projects), do
    so. Point your browser to the
    [Google Cloud Console](https://console.cloud.google.com), sign up if
    needed, and create or choose a project. Make note of the project number
    (which is numeric) or project ID (which is usually three or more words
    separated by hyphens). Many services will require you to pass that
    information in when calling an API.

2.  For most services, you will need to provide billing information. If this is
    your first time using Google Cloud Platform, you may be eligible for a free
    trial.

3.  Enable the API you want to use. Click the "APIs & Services" tab in the left
    navigation, then click the "Enable APIs and Services" button near the top.
    Search for the API you want by name, and click "Enable". A few APIs may be
    enabled automatically for you, but most APIs need to be enabled explicitly.

Once you have a project set up and have enabled an API, you are ready to begin
using a client library to call the API.

### Choosing a client library

This repository contains two types of API client RubyGems: the _main library_
for the API (e.g. the [`google-cloud-translate`](google-cloud-translate) gem
for the Translation service), and one ore more _versioned libraries_ for
different versions of the service (e.g.
[`google-cloud-translate-v2`](google-cloud-translate-v2) and
[`google-cloud-translate-v3`](google-cloud-translate-v3) for versions 2 and 3
of the service, respectively). Note that we're referring to different versions
of the _backend service_, not of the client library gem.

In most cases, you should install the _main library_ (the one without a service
version in the name). This library will provide all the required code for making
calls to the API. It may also provide additional convenience code implementing
common client-side workflows or best practices. Often the main library will
bring in one or more versioned libraries as dependencies, and the client and
data type classes you will use may actually be defined in a versioned library,
but installing the main library will ensure you have access to the best tools
and interfaces for interacting with the service.

The _versioned libraries_ are lower-level libraries that target a specific
version of the service. You may choose to intall a versioned library directly,
instead of or in addition to the main library, to handle advanced use cases that
require lower level access.

Note: Many services may also provide client libraries with names beginning with
`google-apis-`. Those clients are developed in a
[different repository](https://github.com/googleapis/google-api-ruby-client),
and utilize an older client technology that lacks some of the performance and
ease of use benefits of the clients in the google-cloud-ruby repository. The
older clients may cover some services for which a google-cloud-ruby client is
not yet available, but for services that are covered, we generally recommend
the clients in the google-cloud-ruby repository over the older ones.

Most client libraries have directories in this repository, or you can look up
the name of the client library to use in the documentation for the service you
are using. Install this library as a RubyGem, or add it to your Gemfile.

### Authentication

Most API calls must be accompanied by authentication information proving that
the caller has sufficient permissions to make the call.

These API client libraries provide several mechanisms for attaching credentials
to API calls.

*   If your application runs on an Google Cloud Platform hosting environment
    such as Google Compute Engine, Google Container Engine, Google App Engine,
    Google Cloud Run, or Google Cloud Functions, the environment will provide
    "ambient" credentials which client libraries will recognize and use
    automatically. You can generally configure these credentials in the hosting
    environment, for example per-VM in Google Compute Engine.

*   You can also provide your own service account credentials by including a
    service account key file in your application's file system and setting the
    environment variable `GOOGLE_APPLICATION_CREDENTIALS` to the path to that
    file. Client libraries will read this environment variable if it is set.

*   Finally, you can override credentials in code by setting the `credentials`
    field in the client configuration. This can be set globally on the client
    class or provided when you construct a client object.

For more information, see the authentication documentation for the
client library you are using, or the
[Cloud authentication documentation](https://cloud.google.com/docs/authentication).

## Supported Ruby Versions

These libraries are currently supported on Ruby 2.6 through Ruby 3.1. Older
versions of Ruby _may_ still work, but are unsupported and not recommended.

In general, Google provides official support for Ruby versions that are actively
supported by Ruby Core--that is, Ruby versions that are either in normal
maintenance or in security maintenance, and not end of life. See
https://www.ruby-lang.org/en/downloads/branches/ for details about the Ruby
support schedule.

## Library Versioning

The libraries in this repository follow [Semantic Versioning](https://semver.org/).

Libraries are released at one of two different support quality levels:

**GA**: Libraries defined at the GA (general availability) quality level,
indicated by a gem version number greater than or equal to 1.0, are stable. The
code surface will not change in backwards-incompatible ways unless absolutely
necessary (e.g. because of critical security issues), or unless accompanying a
semver-major version update (such as version 1.x to 2.x.) Issues and requests
against GA libraries are addressed with the highest priority.

**Preview**: Libraries defined at a Preview quality level, indicated by a gem
version number less than 1.0, are expected to be mostly stable and we're
working towards their release candidate. However, these libraries may get
backwards-incompatible updates from time to time. We will still address issues
and requests with a high priority.

Note that the _gem version_ is distinct from the _service version_. Some backend
services have mulitple versions, for example versions
[v2](https://cloud.google.com/translate/docs/reference/rpc/google.cloud.translate.v2)
and [v3](https://cloud.google.com/translate/docs/reference/rpc/google.cloud.translation.v3)
of the translation service. These are treated as _separate services_ and will
have _separate versioned clients_, e.g. the `google-cloud-translate-v2` and
`google-cloud-translate-v3` gems. These gems will in turn have their own gem
versions, tracking the development of the two services.

## Contributing

Contributions to this repository are welcome. However, please note that many of
the clients in this repository are automatically generated. The Ruby files in
those clients will have a comment to that effect near the top; changes to those
files will not be accepted as they will simply be overwritten by the code
generator. If in doubt, please open an issue and ask the maintainers. See the
[CONTRIBUTING](.github/CONTRIBUTING.md) document for more information on how to
get started.

Please note that this project is released with a Contributor Code of Conduct.
By participating in this project you agree to abide by its terms. See
[Code of Conduct](CODE_OF_CONDUCT.md) for more information.

## License

This library is licensed under Apache 2.0. Full license text is
available in [LICENSE](LICENSE).

## Support

Please [report bugs at the project on Github](https://github.com/googleapis/google-cloud-ruby/issues).

If you have questions about how to use the clients or APIs, ask on
[Stack Overflow](http://stackoverflow.com/questions/tagged/google-cloud-platform+ruby).
