/**
 * Copyright (c) 2015-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule TabBarIOS
 * @flow
 */

'use strict';

const React = require('../../react-native/React');
const StyleSheet = require('../../StyleSheet/StyleSheet');
const TabBarItemIOS = require('./TabBarItemIOS');
const View = require('../View/View');

class DummyTabBarIOS extends React.Component<$FlowFixMeProps> {
  static Item = TabBarItemIOS;

  render() {
    return (
      <View style={[this.props.style, styles.tabGroup]}>
        {this.props.children}
      </View>
    );
  }
}

const styles = StyleSheet.create({
  tabGroup: {
    flex: 1,
  }
});

module.exports = DummyTabBarIOS;
