/**
 * Copyright (c) 2013-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule RCTAlertManager
*/
'use strict';

var NativeModules = require('../BatchedBridge/NativeModules');

function emptyCallback() {}

module.exports = {
  alertWithArgs: function(args, callback) {
    // TODO(5998984): Polyfill it correctly with DialogManagerAndroid
    NativeModules.DialogManagerAndroid.showAlert(
        args,
        emptyCallback,
        callback || emptyCallback);
  },
};
