/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.buck.android.support.exopackage;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class ExopackageSoLoader {
    private static final String TAG = "ExopackageSoLoader";
    private static boolean initialized = false;
    private static String nativeLibsDir = null;
    private static File privateNativeLibsDir = null;
    private static Map<String, String> abi1Libraries = new HashMap<String, String>();
    private static Map<String, String> abi2Libraries = new HashMap<String, String>();

    private ExopackageSoLoader() {
    }

    public static void init(Context context) {
        if (initialized) {
            Log.d((String)TAG, (String)"init() already called, so nothing to do.");
            return;
        }
        nativeLibsDir = "/data/local/tmp/exopackage/" + context.getPackageName() + "/native-libs/";
        ExopackageSoLoader.verifyMetadataFile();
        if (ExopackageSoLoader.isCopyToPrivateStorage()) {
            ExopackageSoLoader.preparePrivateDirectory(context);
            ExopackageSoLoader.parseMetadata();
        }
    }

    private static void verifyMetadataFile() {
        File abiMetadata = ExopackageSoLoader.getAbi1Metadata();
        if (abiMetadata.exists()) {
            return;
        }
        abiMetadata = ExopackageSoLoader.getAbi2Metadata();
        if (abiMetadata == null || abiMetadata.exists()) {
            return;
        }
        throw new RuntimeException("Either 'native' exopackage is not turned on for this build, or the installation did not complete successfully.");
    }

    private static void preparePrivateDirectory(Context context) {
        privateNativeLibsDir = context.getDir("exo-libs", 0);
        for (File file : privateNativeLibsDir.listFiles()) {
            file.delete();
        }
    }

    private static void parseMetadata() {
        ExopackageSoLoader.doParseMetadata(ExopackageSoLoader.getAbi1Metadata(), abi1Libraries);
        ExopackageSoLoader.doParseMetadata(ExopackageSoLoader.getAbi2Metadata(), abi2Libraries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doParseMetadata(File metadata, Map<String, String> libraries) {
        if (metadata == null || !metadata.exists()) {
            return;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(metadata));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    int spaceIndex = line.indexOf(32);
                    if (spaceIndex == -1) {
                        throw new RuntimeException("Error parsing metadata.txt; invalid line: " + line);
                    }
                    String libname = line.substring(0, spaceIndex);
                    String filename = line.substring(spaceIndex + 1);
                    libraries.put(libname, filename);
                }
            }
            finally {
                br.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadLibrary(String shortName) throws UnsatisfiedLinkError {
        File libraryFile;
        String libname;
        String string = libname = shortName.startsWith("lib") ? shortName : "lib" + shortName;
        if (ExopackageSoLoader.isCopyToPrivateStorage()) {
            libraryFile = ExopackageSoLoader.copySoFileIfRequired(libname);
        } else {
            libraryFile = new File(nativeLibsDir + Build.CPU_ABI + "/" + libname + ".so");
            if (!libraryFile.exists() && !(libraryFile = new File(nativeLibsDir + Build.CPU_ABI2 + "/" + libname + ".so")).exists()) {
                libraryFile = null;
            }
        }
        if (libraryFile == null) {
            throw new UnsatisfiedLinkError("Could not find library file for either ABIs.");
        }
        String path = libraryFile.getAbsolutePath();
        Log.d((String)TAG, (String)("Attempting to load library: " + path));
        System.load(path);
        Log.d((String)TAG, (String)("Successfully loaded library: " + path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File copySoFileIfRequired(String libname) {
        String abiDir;
        String sourceFilename;
        File libraryFile = new File(privateNativeLibsDir, libname + ".so");
        if (libraryFile.exists()) {
            return libraryFile;
        }
        if (!abi1Libraries.containsKey(libname) && !abi2Libraries.containsKey(libname)) {
            return null;
        }
        if (abi1Libraries.containsKey(libname)) {
            sourceFilename = abi1Libraries.get(libname);
            abiDir = Build.CPU_ABI;
        } else {
            sourceFilename = abi2Libraries.get(libname);
            abiDir = Build.CPU_ABI2;
        }
        String sourcePath = nativeLibsDir + abiDir + "/" + sourceFilename;
        try {
            InputStream in = null;
            OutputStream out = null;
            try {
                int len;
                in = new BufferedInputStream(new FileInputStream(sourcePath));
                out = new BufferedOutputStream(new FileOutputStream(libraryFile));
                byte[] buffer = new byte[4096];
                while ((len = in.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return libraryFile;
    }

    private static boolean isCopyToPrivateStorage() {
        return Build.VERSION.SDK_INT >= 21;
    }

    private static File getAbi1Metadata() {
        return new File(nativeLibsDir + Build.CPU_ABI + "/metadata.txt");
    }

    private static File getAbi2Metadata() {
        if (Build.CPU_ABI2.equals("unknown")) {
            return null;
        }
        return new File(nativeLibsDir + Build.CPU_ABI2 + "/metadata.txt");
    }
}

