/*
 * Decompiled with CFR 0.152.
 */
package org.arpit.java2blog.controller;

import java.util.List;
import org.arpit.java2blog.model.Movie;
import org.arpit.java2blog.service.MovieService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MovieController {
    @Autowired
    MovieService movieService;

    @GetMapping(value={"/movies"})
    private List<Movie> getAllMovies() {
        return this.movieService.getAllMovies();
    }

    @GetMapping(value={"/movies/{id}"})
    private Movie getMovie(@PathVariable(value="id") int id) {
        return this.movieService.getMovieById(id);
    }

    @DeleteMapping(value={"/movies/{id}"})
    private void deleteMovie(@PathVariable(value="id") int id) {
        this.movieService.delete(id);
    }

    @PostMapping(value={"/movies"})
    private int saveMovie(@RequestBody Movie movie) {
        this.movieService.saveOrUpdate(movie);
        return movie.getId();
    }
}

