# Jetpack Compose Codelabs

This repository contains a set of Android Studio projects to help you learn about
Compose in Android. Each sample contains the code for a specific Compose codelab.

For more information about Jetpack Compose, please [read the documentation](https://developer.android.com/jetpack/compose)

## 💻 Requirements

[Android Studio Chipmunk](https://developer.android.com/studio).

## 🧬 Codelabs

### [Basics codelabs](https://developer.android.com/codelabs/jetpack-compose-basics)

Go hands-on and learn the fundamentals of declarative UI, working with state, layouts and theming.

### [Basic layouts codelab](https://developer.android.com/codelabs/jetpack-compose-layouts)

Learn how to implement real-world designs with the composables and modifiers that Compose provides out of the box.

### [State codelab](https://developer.android.com/codelabs/jetpack-compose-state)

Understand patterns for working with state in a declarative world by building a Todo application.

### [Theming codelab](https://developer.android.com/codelabs/jetpack-compose-theming)

Go hands on with Compose’s implementation of Material Design to understand how to theme an
application’s colors, typography and shapes and support light and dark themes.

### [Migration codelab](https://developer.android.com/codelabs/jetpack-compose-migration)

Understand how Jetpack Compose and View-based UIs can co-exist and interact, making it easy to
adopt Compose at your own pace.

### [Animation codelab](https://developer.android.com/codelabs/jetpack-compose-animation)

Learn how to use Jetpack Compose Animation APIs.

### [Navigation codelab](https://developer.android.com/codelabs/jetpack-compose-navigation)

Learn how to use the Jetpack Navigation library in Compose, navigate within your application,
navigate with arguments, support deep-links, and test your navigation.

### [Testing codelab](https://developer.android.com/codelabs/jetpack-compose-testing)

Learn about testing Jetpack Compose UIs. Write your first tests, and learn about testing in
isolation, debugging tests, the semantics tree, and test synchronization.

### [Accessibility codelab](https://developer.android.com/codelabs/jetpack-compose-accessibility)

Learn about the various ways to improve an app’s accessibility. Increase touch target sizes, add
content descriptions, create custom actions, and more.

## License

```
Copyright 2021 The Android Open Source Project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    https://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
