# Benefits of Markdown

Benefits of Markdown includes that it focuses exclusively on **marking up structured content** that as a 
result is not tied to its containing website. This makes it easy to re-use and host Markdown content in 
multiple outputs (i.e. alt websites, emails, pdfs, etc). It's also very easy to read and write and thus 
we believe it is the premier document format where most content should be stored in. 

#First class support of Markdown in ServiceStack v2.10
Because of its many inherent benefits, ServiceStack now includes first-class support for the Markdown 
format. Which now features:

### Static website templating
Static Markdown pages can be fused together with a static **default.shtml** page to create websites
based solely on static Markdown and html pages (as done in this site).

### Performance
On startup, all Markdown pages (.md) are parsed and converted to html and pre-cached in memory for 
fast response times. Although pages are cached, modified pages are detected and re-evaluated and
**Last-Modified** Cache HTTP Headers are returned to be able to avoid unnecessary page loads.

### Clean Urls
You can omit the extension (.md) to the Markdown urls to request a specific page. 
Allowing a clean url structure using just directory and file names.

### Partial Content
The raw HTML and Markdown text of each page (without the website template) is available by appending 
the following to the query string:

  - [?format=html.bare](?format=html.bare) - View content only in html
  - [?format=text.bare](?format=text.bare) - View content only in Markdown

Apart from making your content more accessible and re-usable it also allows you to provide partial content
updates which is a popular technique amongst high performance websites.

# Markdown View templating engine
We love Markdown so much we've added a templating view engine so you can dynamically generate Markdown 
and HTML content with a view engine inspired by ASP.NET's Razor syntax and features.

The Mardown Razor template engine works much like ASP.NET MVC's Razor although instead of Controllers, 
the templates make use of the model (aka DTOs) returned from your web services. 
This allows you to non-invasively provide customized HTML representations for your existing 
web services by simply adding a razor page anywhere in the **/Views** directory.

This is a key feature in ServiceStack's implementation where apart from being easily able to generate 
a dynamic HTML page, you can, **without any effort** also access the XML, JSON, JSV and CSV formats of that service.

The resolution order ServiceStack's uses to resolve the appropriate Markdown template to use for rendering HTML output is:
  
  1. If the Web Service specifies a template (via a customized IHttpResult.**TemplateName** response) - then a View with that name.
  2. A view with the same name as the Response DTO, looking first in **/Views** then in **/Views/Shared**
  3. A view with the same name as the Request DTO, looking first in **/Views** then in **/Views/Shared**

Markdown Razor templates are simply normal plain-text Markdown pages that support dynamic behavior by 
using the familiar syntax of MVC's Razor i.e. all statements prefixed with the familiar &#64; symbol.

#### Static website template
Once the appropriate view is executed it's output is stored in the **'Body'** variable and is merged with its
static website template. The rules for finding the appropriate master website template is simple: 
It's the first **default.shtml** page it can find, looking first in its current working directory then 
recursively up the directory hierarchy until it finds one. 

The view is merged with the static website template by replacing all **&lt;--&#64;VarName--&gt;** with variables
generated by the page (i.e. in ScopeArgs). i.e. the executed output of the View is stored in the **Body**
variable and is embedded in the static website template by replacing all **&lt;--&#64;Body--&gt;** found.

### Same old Raxor Syntax and features
We've made a considerable effort in trying to keep syntax parity with MVC's Razor that we've even pulled 
across MVC's HtmlHelper (and its connected classes) so that the **HtmlHelper** extension methods can be 
easily ported across. This is what enables MVC to access strong-typed features like:

**&#64;Html.TextBoxFor(m => m.FirstName)**

Which renders the same output as it does in MVC Razor (since we're using their code to do this :)

Out of the box we've pulled across the extension methods for Html.**Display**XXX, Html.**Input**XXX, 
Html.**Label**XXX and Html.**TextArea**XXX although you can bring and use your own extensions in your pages.

For more information on the features and syntax supported checkout **[Introduction to Markdown Razor](markdown-razor)**
