# What's New In Python 3.3

https://docs.python.org/3/whatsnew/3.3.html

PEPs
====
- [ ] [PEP 405][]: Virtual Environments
- [ ] [PEP 420][]: Implicit Namespace Packages
- [ ] [PEP 3118][]: New `memoryview` implementation and buffer protocol documentation
- [ ] [PEP 393][]: Flexible String Representation
- [ ] [PEP 397][]: Python Launcher for Windows
- [ ] [PEP 3151][]: Reworking the OS and IO exception hierarchy
- [ ] [PEP 380][]: Syntax for Delegating to a Subgenerator
- [ ] [PEP 409][]: Suppressing exception context
- [x] [PEP 414][]: Explicit Unicode literals
- [ ] [PEP 3155][]: Qualified name for classes and functions
- [ ] [PEP 412][]: Key-Sharing Dictionary
- [ ] [PEP 362][]: Function Signature Object
- [x] [PEP 421][]: Adding `sys.implementation`

Using `importlib` as the Implementation of Import
===============================================
- [ ] See https://docs.python.org/3/whatsnew/3.3.html#using-importlib-as-the-implementation-of-import

Other Language Changes
======================
- [ ] Added support for Unicode name aliases and named sequences. Both `unicodedata.lookup()` and `'\N{...}'` now resolve name aliases, and `unicodedata.lookup()` resolves named sequences too.
- [ ] Unicode database updated to UCD version 6.1.0
- [ ] Equality comparisons on `range()` objects now return a result reflecting the equality of the underlying sequences generated by those range objects.
- [x] The `count()`, `find()`, `rfind()`, `index()` and `rindex()` methods of `bytes` and `bytearray` objects now accept an integer between 0 and 255 as their first argument.
- [x] The `rjust()`, `ljust()`, and `center()` methods of `bytes` and `bytearray` now accept a `bytearray` for the `fill` argument.
- [x] New methods have been added to `list` and `bytearray`: `copy()` and `clear()`. Consequently, `MutableSequence` now also defines a `clear()` method
- [x] Raw `bytes` literals can now be written `rb"..."` as well as `br"..."`.
- [ ] `dict.setdefault()` now does only one lookup for the given key, making it atomic when used with built-in types.
- [ ] The error messages produced when a function call does not match the function signature have been significantly improved.

Builtin functions and types
===========================
- [ ] `open()` gets a new `opener` parameter: the underlying file descriptor for the file object is then obtained by calling `opener` with `(file, flags)`. It can be used to use custom flags like `os.O_CLOEXEC` for example. The `'x'` mode was added: open for exclusive creation, failing if the file already exists.
- [ ] `print()`: added the `flush` keyword argument. If the `flush` keyword argument is true, the stream is forcibly flushed.
- [ ] `hash()`: hash randomization is enabled by default, see `object.__hash__()` and `PYTHONHASHSEED`.
- [ ] The `str` type gets a new `casefold()` method: return a casefolded copy of the string, casefolded strings may be used for caseless matching. For example, `''.casefold()` returns `'ss'`.

New Modules
===========
- [ ] `faulthandler`
- [x] `ipaddress`
- [ ] `lzma`

Improved Modules
================
- [ ] `abc`
- [ ] `array`
- [ ] `base64`
- [ ] `binascii`
- [ ] `bz2`
- [ ] `codecs`
- [ ] `collections`
- [ ] `contextlib`
- [ ] `crypt`
- [ ] `curses`
- [ ] `datetime`
- [ ] `decimal`
- [ ] `email`
- [ ] `ftplib`
- [ ] `functools`
- [ ] `gc`
- [ ] `hmac`
- [ ] `http`
- [ ] `html`
- [ ] `imaplib`
- [ ] `inspect`
- [ ] `io`
- [ ] `itertools`
- [ ] `logging`
- [ ] `math`
- [ ] `mmap`
- [ ] `multiprocessing`
- [ ] `nntplib`
- [ ] `os`
- [ ] `pdb`
- [ ] `pickle`
- [ ] `pydoc`
- [ ] `re`
- [ ] `sched`
- [ ] `select`
- [ ] `shlex`
- [ ] `shutil`
- [ ] `signal`
- [ ] `smtpd`
- [ ] `smtplib`
- [ ] `socket`
- [ ] `socketserver`
- [ ] `sqlite3`
- [ ] `ssl`
- [ ] `stat`
- [ ] `struct`
- [ ] `subprocess`
- [ ] `sys`
- [ ] `tarfile`
- [ ] `tempfile`
- [ ] `textwrap`
- [ ] `threading`
- [ ] `time`
- [ ] `types`
- [ ] `unittest`
- [ ] `urllib`
- [ ] `webbrowser`
- [ ] `xml.etree.ElementTree`
- [ ] `zlib`

Deprecated Python modules, functions and methods
==============
- [ ] Passing a non-empty string to `object.__format__()` is deprecated, and will produce a `TypeError` in Python 3.4
- [ ] The unicode_internal codec has been deprecated because of the [PEP 393][], use UTF-8, UTF-16 (`utf-16-le` or `utf-16-be`), or UTF-32 (`utf-32-le` or `utf-32-be`)
- [ ] `ftplib.FTP.nlst()` and `ftplib.FTP.dir()`: use `ftplib.FTP.mlsd()`
- [ ] `platform.popen()`: use the `subprocess` module. Check especially the "Replacing Older Functions with the `subprocess` Module" section (issue 11377).
- [ ] The Windows `bytes` API has been deprecated in the `os` module. Use Unicode filenames, instead of `bytes` filenames, to not depend on the ANSI code page anymore and to support any filename.
- [x] The `xml.etree.cElementTree` module is deprecated. The accelerator is used automatically whenever available.
- [x] The behaviour of `time.clock()` depends on the platform: use the new `time.perf_counter()` or `time.process_time()` function instead, depending on your requirements, to have a well defined behaviour.
- [x] ~~The `os.stat_float_times()` function is deprecated.~~ (Never implemented, but removed in Python 3.7)
- `abc` module:
    + [ ] `abc.abstractproperty` has been deprecated, use `property` with `abc.abstractmethod()` instead.
    + [ ] `abc.abstractclassmethod` has been deprecated, use `classmethod` with `abc.abstractmethod()` instead.
    + [ ] `abc.abstractstaticmethod` has been deprecated, use `staticmethod` with `abc.abstractmethod()` instead.
- [ ] `importlib.abc.SourceLoader.path_mtime()` is now deprecated in favour of `importlib.abc.SourceLoader.path_stats()` as bytecode files now store both the modification time and size of the source file the bytecode file was compiled from.

[PEP 405]: http://www.python.org/dev/peps/pep-0405
[PEP 420]: http://www.python.org/dev/peps/pep-0420
[PEP 3118]: http://www.python.org/dev/peps/pep-3118
[PEP 393]: http://www.python.org/dev/peps/pep-0393
[PEP 397]: http://www.python.org/dev/peps/pep-0397
[PEP 3151]: http://www.python.org/dev/peps/pep-3151
[PEP 380]: http://www.python.org/dev/peps/pep-0380
[PEP 409]: http://www.python.org/dev/peps/pep-0409
[PEP 414]: http://www.python.org/dev/peps/pep-0414
[PEP 3155]: http://www.python.org/dev/peps/pep-3155
[PEP 412]: http://www.python.org/dev/peps/pep-0412
[PEP 362]: http://www.python.org/dev/peps/pep-0362
[PEP 421]: http://www.python.org/dev/peps/pep-0421
[PEP 393]: http://www.python.org/dev/peps/pep-0393
