// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.IO;
using System.Runtime.InteropServices;
using System.Text;

using Microsoft.Scripting;

using IronPython.Runtime.Operations;
using IronPython.Runtime.Types;
using Microsoft.Scripting.Utils;
using System.Threading;

// This generated code is updated by the generate_exceptions.py script.
namespace IronPython.Runtime.Exceptions {
    public static partial class PythonExceptions {
        #region Generated Python New-Style Exceptions

        // *** BEGIN GENERATED CODE ***
        // generated by function: newstyle_gen from: generate_exceptions.py

        [MultiRuntimeAware]
        private static PythonType SystemExitStorage;
        public static PythonType SystemExit {
            get {
                if (SystemExitStorage == null) {
                    Interlocked.CompareExchange(ref SystemExitStorage, CreateSubType(DynamicHelpers.GetPythonTypeFromType(typeof(BaseException)), typeof(_SystemExit), (msg, innerException) => new SystemExitException(msg, innerException)), null);
                }
                return SystemExitStorage;
            }
        }

        [PythonType("SystemExit"), PythonHidden, DynamicBaseType, Serializable]
        public partial class _SystemExit : BaseException {
            public _SystemExit() : base(SystemExit) { }
            public _SystemExit(PythonType type) : base(type) { }

            public object code { get; set; }
        }

        [MultiRuntimeAware]
        private static PythonType KeyboardInterruptStorage;
        public static PythonType KeyboardInterrupt {
            get {
                if (KeyboardInterruptStorage == null) {
                    Interlocked.CompareExchange(ref KeyboardInterruptStorage, CreateSubType(DynamicHelpers.GetPythonTypeFromType(typeof(BaseException)), "KeyboardInterrupt", (msg, innerException) => new KeyboardInterruptException(msg, innerException)), null);
                }
                return KeyboardInterruptStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType GeneratorExitStorage;
        public static PythonType GeneratorExit {
            get {
                if (GeneratorExitStorage == null) {
                    Interlocked.CompareExchange(ref GeneratorExitStorage, CreateSubType(DynamicHelpers.GetPythonTypeFromType(typeof(BaseException)), "GeneratorExit", (msg, innerException) => new GeneratorExitException(msg, innerException)), null);
                }
                return GeneratorExitStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ExceptionStorage;
        public static PythonType Exception {
            get {
                if (ExceptionStorage == null) {
                    Interlocked.CompareExchange(ref ExceptionStorage, CreateSubType(DynamicHelpers.GetPythonTypeFromType(typeof(BaseException)), "Exception", (msg, innerException) => new PythonException(msg, innerException)), null);
                }
                return ExceptionStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType StopIterationStorage;
        public static PythonType StopIteration {
            get {
                if (StopIterationStorage == null) {
                    Interlocked.CompareExchange(ref StopIterationStorage, CreateSubType(Exception, typeof(_StopIteration), (msg, innerException) => new StopIterationException(msg, innerException)), null);
                }
                return StopIterationStorage;
            }
        }

        [PythonType("StopIteration"), PythonHidden, DynamicBaseType, Serializable]
        public partial class _StopIteration : BaseException {
            public _StopIteration() : base(StopIteration) { }
            public _StopIteration(PythonType type) : base(type) { }

            public object value { get; set; }
        }

        [MultiRuntimeAware]
        private static PythonType StopAsyncIterationStorage;
        public static PythonType StopAsyncIteration {
            get {
                if (StopAsyncIterationStorage == null) {
                    Interlocked.CompareExchange(ref StopAsyncIterationStorage, CreateSubType(Exception, typeof(_StopAsyncIteration), (msg, innerException) => new StopAsyncIterationException(msg, innerException)), null);
                }
                return StopAsyncIterationStorage;
            }
        }

        [PythonType("StopAsyncIteration"), PythonHidden, DynamicBaseType, Serializable]
        public partial class _StopAsyncIteration : BaseException {
            public _StopAsyncIteration() : base(StopAsyncIteration) { }
            public _StopAsyncIteration(PythonType type) : base(type) { }

            public object value { get; set; }
        }

        [MultiRuntimeAware]
        private static PythonType ArithmeticErrorStorage;
        public static PythonType ArithmeticError {
            get {
                if (ArithmeticErrorStorage == null) {
                    Interlocked.CompareExchange(ref ArithmeticErrorStorage, CreateSubType(Exception, "ArithmeticError", (msg, innerException) => new ArithmeticException(msg, innerException)), null);
                }
                return ArithmeticErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType FloatingPointErrorStorage;
        public static PythonType FloatingPointError {
            get {
                if (FloatingPointErrorStorage == null) {
                    Interlocked.CompareExchange(ref FloatingPointErrorStorage, CreateSubType(ArithmeticError, "FloatingPointError", (msg, innerException) => new FloatingPointException(msg, innerException)), null);
                }
                return FloatingPointErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType OverflowErrorStorage;
        public static PythonType OverflowError {
            get {
                if (OverflowErrorStorage == null) {
                    Interlocked.CompareExchange(ref OverflowErrorStorage, CreateSubType(ArithmeticError, "OverflowError", (msg, innerException) => new OverflowException(msg, innerException)), null);
                }
                return OverflowErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ZeroDivisionErrorStorage;
        public static PythonType ZeroDivisionError {
            get {
                if (ZeroDivisionErrorStorage == null) {
                    Interlocked.CompareExchange(ref ZeroDivisionErrorStorage, CreateSubType(ArithmeticError, "ZeroDivisionError", (msg, innerException) => new DivideByZeroException(msg, innerException)), null);
                }
                return ZeroDivisionErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType AssertionErrorStorage;
        public static PythonType AssertionError {
            get {
                if (AssertionErrorStorage == null) {
                    Interlocked.CompareExchange(ref AssertionErrorStorage, CreateSubType(Exception, "AssertionError", (msg, innerException) => new AssertionException(msg, innerException)), null);
                }
                return AssertionErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType AttributeErrorStorage;
        public static PythonType AttributeError {
            get {
                if (AttributeErrorStorage == null) {
                    Interlocked.CompareExchange(ref AttributeErrorStorage, CreateSubType(Exception, "AttributeError", (msg, innerException) => new AttributeErrorException(msg, innerException)), null);
                }
                return AttributeErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType BufferErrorStorage;
        public static PythonType BufferError {
            get {
                if (BufferErrorStorage == null) {
                    Interlocked.CompareExchange(ref BufferErrorStorage, CreateSubType(Exception, "BufferError", (msg, innerException) => new BufferException(msg, innerException)), null);
                }
                return BufferErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType EOFErrorStorage;
        public static PythonType EOFError {
            get {
                if (EOFErrorStorage == null) {
                    Interlocked.CompareExchange(ref EOFErrorStorage, CreateSubType(Exception, "EOFError", (msg, innerException) => new EndOfStreamException(msg, innerException)), null);
                }
                return EOFErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ImportErrorStorage;
        public static PythonType ImportError {
            get {
                if (ImportErrorStorage == null) {
                    Interlocked.CompareExchange(ref ImportErrorStorage, CreateSubType(Exception, typeof(_ImportError), (msg, innerException) => new ImportException(msg, innerException)), null);
                }
                return ImportErrorStorage;
            }
        }

        [PythonType("ImportError"), PythonHidden, DynamicBaseType, Serializable]
        public partial class _ImportError : BaseException {
            public _ImportError() : base(ImportError) { }
            public _ImportError(PythonType type) : base(type) { }

            public object name { get; set; }

            public object path { get; set; }
        }

        [MultiRuntimeAware]
        private static PythonType ModuleNotFoundErrorStorage;
        public static PythonType ModuleNotFoundError {
            get {
                if (ModuleNotFoundErrorStorage == null) {
                    Interlocked.CompareExchange(ref ModuleNotFoundErrorStorage, CreateSubType(ImportError, "ModuleNotFoundError", (msg, innerException) => new ModuleNotFoundException(msg, innerException)), null);
                }
                return ModuleNotFoundErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType LookupErrorStorage;
        public static PythonType LookupError {
            get {
                if (LookupErrorStorage == null) {
                    Interlocked.CompareExchange(ref LookupErrorStorage, CreateSubType(Exception, "LookupError", (msg, innerException) => new LookupException(msg, innerException)), null);
                }
                return LookupErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType IndexErrorStorage;
        public static PythonType IndexError {
            get {
                if (IndexErrorStorage == null) {
                    Interlocked.CompareExchange(ref IndexErrorStorage, CreateSubType(LookupError, "IndexError", (msg, innerException) => new IndexOutOfRangeException(msg, innerException)), null);
                }
                return IndexErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType KeyErrorStorage;
        public static PythonType KeyError {
            get {
                if (KeyErrorStorage == null) {
                    Interlocked.CompareExchange(ref KeyErrorStorage, CreateSubType(LookupError, "KeyError", (msg, innerException) => new KeyNotFoundException(msg, innerException)), null);
                }
                return KeyErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType MemoryErrorStorage;
        public static PythonType MemoryError {
            get {
                if (MemoryErrorStorage == null) {
                    Interlocked.CompareExchange(ref MemoryErrorStorage, CreateSubType(Exception, "MemoryError", (msg, innerException) => new OutOfMemoryException(msg, innerException)), null);
                }
                return MemoryErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType NameErrorStorage;
        public static PythonType NameError {
            get {
                if (NameErrorStorage == null) {
                    Interlocked.CompareExchange(ref NameErrorStorage, CreateSubType(Exception, "NameError", (msg, innerException) => new UnboundNameException(msg, innerException)), null);
                }
                return NameErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType UnboundLocalErrorStorage;
        public static PythonType UnboundLocalError {
            get {
                if (UnboundLocalErrorStorage == null) {
                    Interlocked.CompareExchange(ref UnboundLocalErrorStorage, CreateSubType(NameError, "UnboundLocalError", (msg, innerException) => new UnboundLocalException(msg, innerException)), null);
                }
                return UnboundLocalErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType OSErrorStorage;
        public static PythonType OSError {
            get {
                if (OSErrorStorage == null) {
                    Interlocked.CompareExchange(ref OSErrorStorage, CreateSubType(Exception, typeof(_OSError), (msg, innerException) => new OSException(msg, innerException)), null);
                }
                return OSErrorStorage;
            }
        }

        [PythonType("OSError"), PythonHidden, DynamicBaseType, Serializable]
        public partial class _OSError : BaseException {
            public _OSError() : base(OSError) { }
            public _OSError(PythonType type) : base(type) { }

            public object errno { get; set; }

            public object strerror { get; set; }
        }

        [MultiRuntimeAware]
        private static PythonType BlockingIOErrorStorage;
        public static PythonType BlockingIOError {
            get {
                if (BlockingIOErrorStorage == null) {
                    Interlocked.CompareExchange(ref BlockingIOErrorStorage, CreateSubType(OSError, typeof(_BlockingIOError), (msg, innerException) => new BlockingIOException(msg, innerException)), null);
                }
                return BlockingIOErrorStorage;
            }
        }

        [PythonType("BlockingIOError"), PythonHidden, DynamicBaseType, Serializable]
        public partial class _BlockingIOError : _OSError {
            public _BlockingIOError() : base(BlockingIOError) { }
            public _BlockingIOError(PythonType type) : base(type) { }
        }

        [MultiRuntimeAware]
        private static PythonType ChildProcessErrorStorage;
        public static PythonType ChildProcessError {
            get {
                if (ChildProcessErrorStorage == null) {
                    Interlocked.CompareExchange(ref ChildProcessErrorStorage, CreateSubType(OSError, "ChildProcessError", (msg, innerException) => new ChildProcessException(msg, innerException)), null);
                }
                return ChildProcessErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ConnectionErrorStorage;
        public static PythonType ConnectionError {
            get {
                if (ConnectionErrorStorage == null) {
                    Interlocked.CompareExchange(ref ConnectionErrorStorage, CreateSubType(OSError, "ConnectionError", (msg, innerException) => new ConnectionException(msg, innerException)), null);
                }
                return ConnectionErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType BrokenPipeErrorStorage;
        public static PythonType BrokenPipeError {
            get {
                if (BrokenPipeErrorStorage == null) {
                    Interlocked.CompareExchange(ref BrokenPipeErrorStorage, CreateSubType(ConnectionError, "BrokenPipeError", (msg, innerException) => new BrokenPipeException(msg, innerException)), null);
                }
                return BrokenPipeErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ConnectionAbortedErrorStorage;
        public static PythonType ConnectionAbortedError {
            get {
                if (ConnectionAbortedErrorStorage == null) {
                    Interlocked.CompareExchange(ref ConnectionAbortedErrorStorage, CreateSubType(ConnectionError, "ConnectionAbortedError", (msg, innerException) => new ConnectionAbortedException(msg, innerException)), null);
                }
                return ConnectionAbortedErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ConnectionRefusedErrorStorage;
        public static PythonType ConnectionRefusedError {
            get {
                if (ConnectionRefusedErrorStorage == null) {
                    Interlocked.CompareExchange(ref ConnectionRefusedErrorStorage, CreateSubType(ConnectionError, "ConnectionRefusedError", (msg, innerException) => new ConnectionRefusedException(msg, innerException)), null);
                }
                return ConnectionRefusedErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ConnectionResetErrorStorage;
        public static PythonType ConnectionResetError {
            get {
                if (ConnectionResetErrorStorage == null) {
                    Interlocked.CompareExchange(ref ConnectionResetErrorStorage, CreateSubType(ConnectionError, "ConnectionResetError", (msg, innerException) => new ConnectionResetException(msg, innerException)), null);
                }
                return ConnectionResetErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType FileExistsErrorStorage;
        public static PythonType FileExistsError {
            get {
                if (FileExistsErrorStorage == null) {
                    Interlocked.CompareExchange(ref FileExistsErrorStorage, CreateSubType(OSError, "FileExistsError", (msg, innerException) => new FileExistsException(msg, innerException)), null);
                }
                return FileExistsErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType FileNotFoundErrorStorage;
        public static PythonType FileNotFoundError {
            get {
                if (FileNotFoundErrorStorage == null) {
                    Interlocked.CompareExchange(ref FileNotFoundErrorStorage, CreateSubType(OSError, "FileNotFoundError", (msg, innerException) => new FileNotFoundException(msg, innerException)), null);
                }
                return FileNotFoundErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType InterruptedErrorStorage;
        public static PythonType InterruptedError {
            get {
                if (InterruptedErrorStorage == null) {
                    Interlocked.CompareExchange(ref InterruptedErrorStorage, CreateSubType(OSError, "InterruptedError", (msg, innerException) => new InterruptedException(msg, innerException)), null);
                }
                return InterruptedErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType IsADirectoryErrorStorage;
        public static PythonType IsADirectoryError {
            get {
                if (IsADirectoryErrorStorage == null) {
                    Interlocked.CompareExchange(ref IsADirectoryErrorStorage, CreateSubType(OSError, "IsADirectoryError", (msg, innerException) => new IsADirectoryException(msg, innerException)), null);
                }
                return IsADirectoryErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType NotADirectoryErrorStorage;
        public static PythonType NotADirectoryError {
            get {
                if (NotADirectoryErrorStorage == null) {
                    Interlocked.CompareExchange(ref NotADirectoryErrorStorage, CreateSubType(OSError, "NotADirectoryError", (msg, innerException) => new NotADirectoryException(msg, innerException)), null);
                }
                return NotADirectoryErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType PermissionErrorStorage;
        public static PythonType PermissionError {
            get {
                if (PermissionErrorStorage == null) {
                    Interlocked.CompareExchange(ref PermissionErrorStorage, CreateSubType(OSError, "PermissionError", (msg, innerException) => new UnauthorizedAccessException(msg, innerException)), null);
                }
                return PermissionErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ProcessLookupErrorStorage;
        public static PythonType ProcessLookupError {
            get {
                if (ProcessLookupErrorStorage == null) {
                    Interlocked.CompareExchange(ref ProcessLookupErrorStorage, CreateSubType(OSError, "ProcessLookupError", (msg, innerException) => new ProcessLookupException(msg, innerException)), null);
                }
                return ProcessLookupErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType TimeoutErrorStorage;
        public static PythonType TimeoutError {
            get {
                if (TimeoutErrorStorage == null) {
                    Interlocked.CompareExchange(ref TimeoutErrorStorage, CreateSubType(OSError, "TimeoutError", (msg, innerException) => new TimeoutException(msg, innerException)), null);
                }
                return TimeoutErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ReferenceErrorStorage;
        public static PythonType ReferenceError {
            get {
                if (ReferenceErrorStorage == null) {
                    Interlocked.CompareExchange(ref ReferenceErrorStorage, CreateSubType(Exception, "ReferenceError", (msg, innerException) => new ReferenceException(msg, innerException)), null);
                }
                return ReferenceErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType RuntimeErrorStorage;
        public static PythonType RuntimeError {
            get {
                if (RuntimeErrorStorage == null) {
                    Interlocked.CompareExchange(ref RuntimeErrorStorage, CreateSubType(Exception, "RuntimeError", (msg, innerException) => new RuntimeException(msg, innerException)), null);
                }
                return RuntimeErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType NotImplementedErrorStorage;
        public static PythonType NotImplementedError {
            get {
                if (NotImplementedErrorStorage == null) {
                    Interlocked.CompareExchange(ref NotImplementedErrorStorage, CreateSubType(RuntimeError, "NotImplementedError", (msg, innerException) => new NotImplementedException(msg, innerException)), null);
                }
                return NotImplementedErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType RecursionErrorStorage;
        public static PythonType RecursionError {
            get {
                if (RecursionErrorStorage == null) {
                    Interlocked.CompareExchange(ref RecursionErrorStorage, CreateSubType(RuntimeError, "RecursionError", (msg, innerException) => new RecursionException(msg, innerException)), null);
                }
                return RecursionErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType SyntaxErrorStorage;
        public static PythonType SyntaxError {
            get {
                if (SyntaxErrorStorage == null) {
                    Interlocked.CompareExchange(ref SyntaxErrorStorage, CreateSubType(Exception, typeof(_SyntaxError), (msg, innerException) => new SyntaxErrorException(msg, innerException)), null);
                }
                return SyntaxErrorStorage;
            }
        }

        [PythonType("SyntaxError"), PythonHidden, DynamicBaseType, Serializable]
        public partial class _SyntaxError : BaseException {
            public _SyntaxError() : base(SyntaxError) { }
            public _SyntaxError(PythonType type) : base(type) { }

            public object text { get; set; }

            public object print_file_and_line { get; set; }

            public object filename { get; set; }

            public object lineno { get; set; }

            public object offset { get; set; }

            public object msg { get; set; }
        }

        [MultiRuntimeAware]
        private static PythonType IndentationErrorStorage;
        public static PythonType IndentationError {
            get {
                if (IndentationErrorStorage == null) {
                    Interlocked.CompareExchange(ref IndentationErrorStorage, CreateSubType(SyntaxError, "IndentationError", (msg, innerException) => new IndentationException(msg, innerException)), null);
                }
                return IndentationErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType TabErrorStorage;
        public static PythonType TabError {
            get {
                if (TabErrorStorage == null) {
                    Interlocked.CompareExchange(ref TabErrorStorage, CreateSubType(IndentationError, "TabError", (msg, innerException) => new TabException(msg, innerException)), null);
                }
                return TabErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType SystemErrorStorage;
        public static PythonType SystemError {
            get {
                if (SystemErrorStorage == null) {
                    Interlocked.CompareExchange(ref SystemErrorStorage, CreateSubType(Exception, "SystemError", (msg, innerException) => new SystemException(msg, innerException)), null);
                }
                return SystemErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType TypeErrorStorage;
        public static PythonType TypeError {
            get {
                if (TypeErrorStorage == null) {
                    Interlocked.CompareExchange(ref TypeErrorStorage, CreateSubType(Exception, "TypeError", (msg, innerException) => new TypeErrorException(msg, innerException)), null);
                }
                return TypeErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ValueErrorStorage;
        public static PythonType ValueError {
            get {
                if (ValueErrorStorage == null) {
                    Interlocked.CompareExchange(ref ValueErrorStorage, CreateSubType(Exception, "ValueError", (msg, innerException) => new ValueErrorException(msg, innerException)), null);
                }
                return ValueErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType UnicodeErrorStorage;
        public static PythonType UnicodeError {
            get {
                if (UnicodeErrorStorage == null) {
                    Interlocked.CompareExchange(ref UnicodeErrorStorage, CreateSubType(ValueError, "UnicodeError", (msg, innerException) => new UnicodeException(msg, innerException)), null);
                }
                return UnicodeErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType UnicodeDecodeErrorStorage;
        public static PythonType UnicodeDecodeError {
            get {
                if (UnicodeDecodeErrorStorage == null) {
                    Interlocked.CompareExchange(ref UnicodeDecodeErrorStorage, CreateSubType(UnicodeError, typeof(_UnicodeDecodeError), (msg, innerException) => new DecoderFallbackException(msg, innerException)), null);
                }
                return UnicodeDecodeErrorStorage;
            }
        }

        [PythonType("UnicodeDecodeError"), PythonHidden, DynamicBaseType, Serializable]
        public partial class _UnicodeDecodeError : BaseException {
            public _UnicodeDecodeError() : base(UnicodeDecodeError) { }
            public _UnicodeDecodeError(PythonType type) : base(type) { }

            public void __init__(object encoding, object @object, object start, object end, object reason) {
                this.encoding = encoding;
                this.@object = @object;
                this.start = start;
                this.end = end;
                this.reason = reason;
                args = PythonTuple.MakeTuple(encoding, @object, start, end, reason);
            }

            public override void __init__(params object[] args) {
                if (args == null || args.Length != 5) {
                    throw PythonOps.TypeError("__init__ takes exactly 5 arguments ({0} given)", args.Length);
                }
                __init__(args[0], args[1], args[2], args[3], args[4]);
            }

            public object start { get; set; }

            public object reason { get; set; }

            public object @object { get; set; }

            public object end { get; set; }

            public object encoding { get; set; }
        }

        [MultiRuntimeAware]
        private static PythonType UnicodeEncodeErrorStorage;
        public static PythonType UnicodeEncodeError {
            get {
                if (UnicodeEncodeErrorStorage == null) {
                    Interlocked.CompareExchange(ref UnicodeEncodeErrorStorage, CreateSubType(UnicodeError, typeof(_UnicodeEncodeError), (msg, innerException) => new EncoderFallbackException(msg, innerException)), null);
                }
                return UnicodeEncodeErrorStorage;
            }
        }

        [PythonType("UnicodeEncodeError"), PythonHidden, DynamicBaseType, Serializable]
        public partial class _UnicodeEncodeError : BaseException {
            public _UnicodeEncodeError() : base(UnicodeEncodeError) { }
            public _UnicodeEncodeError(PythonType type) : base(type) { }

            public void __init__(object encoding, object @object, object start, object end, object reason) {
                this.encoding = encoding;
                this.@object = @object;
                this.start = start;
                this.end = end;
                this.reason = reason;
                args = PythonTuple.MakeTuple(encoding, @object, start, end, reason);
            }

            public override void __init__(params object[] args) {
                if (args == null || args.Length != 5) {
                    throw PythonOps.TypeError("__init__ takes exactly 5 arguments ({0} given)", args.Length);
                }
                __init__(args[0], args[1], args[2], args[3], args[4]);
            }

            public object start { get; set; }

            public object reason { get; set; }

            public object @object { get; set; }

            public object end { get; set; }

            public object encoding { get; set; }
        }

        [MultiRuntimeAware]
        private static PythonType UnicodeTranslateErrorStorage;
        public static PythonType UnicodeTranslateError {
            get {
                if (UnicodeTranslateErrorStorage == null) {
                    Interlocked.CompareExchange(ref UnicodeTranslateErrorStorage, CreateSubType(UnicodeError, typeof(_UnicodeTranslateError), (msg, innerException) => new UnicodeTranslateException(msg, innerException)), null);
                }
                return UnicodeTranslateErrorStorage;
            }
        }

        [PythonType("UnicodeTranslateError"), PythonHidden, DynamicBaseType, Serializable]
        public partial class _UnicodeTranslateError : BaseException {
            public _UnicodeTranslateError() : base(UnicodeTranslateError) { }
            public _UnicodeTranslateError(PythonType type) : base(type) { }

            public object start { get; set; }

            public object reason { get; set; }

            public object @object { get; set; }

            public object end { get; set; }

            public object encoding { get; set; }
        }

        [MultiRuntimeAware]
        private static PythonType WarningStorage;
        public static PythonType Warning {
            get {
                if (WarningStorage == null) {
                    Interlocked.CompareExchange(ref WarningStorage, CreateSubType(Exception, "Warning", (msg, innerException) => new WarningException(msg, innerException)), null);
                }
                return WarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType DeprecationWarningStorage;
        public static PythonType DeprecationWarning {
            get {
                if (DeprecationWarningStorage == null) {
                    Interlocked.CompareExchange(ref DeprecationWarningStorage, CreateSubType(Warning, "DeprecationWarning", (msg, innerException) => new DeprecationWarningException(msg, innerException)), null);
                }
                return DeprecationWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType PendingDeprecationWarningStorage;
        public static PythonType PendingDeprecationWarning {
            get {
                if (PendingDeprecationWarningStorage == null) {
                    Interlocked.CompareExchange(ref PendingDeprecationWarningStorage, CreateSubType(Warning, "PendingDeprecationWarning", (msg, innerException) => new PendingDeprecationWarningException(msg, innerException)), null);
                }
                return PendingDeprecationWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType RuntimeWarningStorage;
        public static PythonType RuntimeWarning {
            get {
                if (RuntimeWarningStorage == null) {
                    Interlocked.CompareExchange(ref RuntimeWarningStorage, CreateSubType(Warning, "RuntimeWarning", (msg, innerException) => new RuntimeWarningException(msg, innerException)), null);
                }
                return RuntimeWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType SyntaxWarningStorage;
        public static PythonType SyntaxWarning {
            get {
                if (SyntaxWarningStorage == null) {
                    Interlocked.CompareExchange(ref SyntaxWarningStorage, CreateSubType(Warning, "SyntaxWarning", (msg, innerException) => new SyntaxWarningException(msg, innerException)), null);
                }
                return SyntaxWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType UserWarningStorage;
        public static PythonType UserWarning {
            get {
                if (UserWarningStorage == null) {
                    Interlocked.CompareExchange(ref UserWarningStorage, CreateSubType(Warning, "UserWarning", (msg, innerException) => new UserWarningException(msg, innerException)), null);
                }
                return UserWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType FutureWarningStorage;
        public static PythonType FutureWarning {
            get {
                if (FutureWarningStorage == null) {
                    Interlocked.CompareExchange(ref FutureWarningStorage, CreateSubType(Warning, "FutureWarning", (msg, innerException) => new FutureWarningException(msg, innerException)), null);
                }
                return FutureWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ImportWarningStorage;
        public static PythonType ImportWarning {
            get {
                if (ImportWarningStorage == null) {
                    Interlocked.CompareExchange(ref ImportWarningStorage, CreateSubType(Warning, "ImportWarning", (msg, innerException) => new ImportWarningException(msg, innerException)), null);
                }
                return ImportWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType UnicodeWarningStorage;
        public static PythonType UnicodeWarning {
            get {
                if (UnicodeWarningStorage == null) {
                    Interlocked.CompareExchange(ref UnicodeWarningStorage, CreateSubType(Warning, "UnicodeWarning", (msg, innerException) => new UnicodeWarningException(msg, innerException)), null);
                }
                return UnicodeWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType BytesWarningStorage;
        public static PythonType BytesWarning {
            get {
                if (BytesWarningStorage == null) {
                    Interlocked.CompareExchange(ref BytesWarningStorage, CreateSubType(Warning, "BytesWarning", (msg, innerException) => new BytesWarningException(msg, innerException)), null);
                }
                return BytesWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ResourceWarningStorage;
        public static PythonType ResourceWarning {
            get {
                if (ResourceWarningStorage == null) {
                    Interlocked.CompareExchange(ref ResourceWarningStorage, CreateSubType(Warning, "ResourceWarning", (msg, innerException) => new ResourceWarningException(msg, innerException)), null);
                }
                return ResourceWarningStorage;
            }
        }


        // *** END GENERATED CODE ***

        #endregion

        #region Generated ToPython Exception Helper

        // *** BEGIN GENERATED CODE ***
        // generated by function: gen_topython_helper from: generate_exceptions.py

        private static BaseException/*!*/ ToPythonHelper(System.Exception clrException) {
            if (clrException is BrokenPipeException) return new PythonExceptions._OSError(PythonExceptions.BrokenPipeError);
            if (clrException is BytesWarningException) return new PythonExceptions.BaseException(PythonExceptions.BytesWarning);
            if (clrException is ConnectionAbortedException) return new PythonExceptions._OSError(PythonExceptions.ConnectionAbortedError);
            if (clrException is ConnectionRefusedException) return new PythonExceptions._OSError(PythonExceptions.ConnectionRefusedError);
            if (clrException is ConnectionResetException) return new PythonExceptions._OSError(PythonExceptions.ConnectionResetError);
            if (clrException is DecoderFallbackException) return new PythonExceptions._UnicodeDecodeError();
            if (clrException is DeprecationWarningException) return new PythonExceptions.BaseException(PythonExceptions.DeprecationWarning);
            if (clrException is DivideByZeroException) return new PythonExceptions.BaseException(PythonExceptions.ZeroDivisionError);
            if (clrException is EncoderFallbackException) return new PythonExceptions._UnicodeEncodeError();
            if (clrException is EndOfStreamException) return new PythonExceptions.BaseException(PythonExceptions.EOFError);
            if (clrException is FileNotFoundException) return new PythonExceptions._OSError(PythonExceptions.FileNotFoundError);
            if (clrException is FutureWarningException) return new PythonExceptions.BaseException(PythonExceptions.FutureWarning);
            if (clrException is ImportWarningException) return new PythonExceptions.BaseException(PythonExceptions.ImportWarning);
            if (clrException is MissingMemberException) return new PythonExceptions.BaseException(PythonExceptions.AttributeError);
            if (clrException is OverflowException) return new PythonExceptions.BaseException(PythonExceptions.OverflowError);
            if (clrException is PendingDeprecationWarningException) return new PythonExceptions.BaseException(PythonExceptions.PendingDeprecationWarning);
            if (clrException is ResourceWarningException) return new PythonExceptions.BaseException(PythonExceptions.ResourceWarning);
            if (clrException is RuntimeWarningException) return new PythonExceptions.BaseException(PythonExceptions.RuntimeWarning);
            if (clrException is SyntaxWarningException) return new PythonExceptions.BaseException(PythonExceptions.SyntaxWarning);
            if (clrException is TabException) return new PythonExceptions._SyntaxError(PythonExceptions.TabError);
            if (clrException is UnicodeWarningException) return new PythonExceptions.BaseException(PythonExceptions.UnicodeWarning);
            if (clrException is UserWarningException) return new PythonExceptions.BaseException(PythonExceptions.UserWarning);
            if (clrException is ArgumentException) return new PythonExceptions.BaseException(PythonExceptions.ValueError);
            if (clrException is ArithmeticException) return new PythonExceptions.BaseException(PythonExceptions.ArithmeticError);
            if (clrException is BlockingIOException) return new PythonExceptions._BlockingIOError();
            if (clrException is ChildProcessException) return new PythonExceptions._OSError(PythonExceptions.ChildProcessError);
            if (clrException is ConnectionException) return new PythonExceptions._OSError(PythonExceptions.ConnectionError);
            if (clrException is FileExistsException) return new PythonExceptions._OSError(PythonExceptions.FileExistsError);
            if (clrException is IndentationException) return new PythonExceptions._SyntaxError(PythonExceptions.IndentationError);
            if (clrException is IndexOutOfRangeException) return new PythonExceptions.BaseException(PythonExceptions.IndexError);
            if (clrException is InterruptedException) return new PythonExceptions._OSError(PythonExceptions.InterruptedError);
            if (clrException is IsADirectoryException) return new PythonExceptions._OSError(PythonExceptions.IsADirectoryError);
            if (clrException is KeyNotFoundException) return new PythonExceptions.BaseException(PythonExceptions.KeyError);
            if (clrException is ModuleNotFoundException) return new PythonExceptions._ImportError(PythonExceptions.ModuleNotFoundError);
            if (clrException is NotADirectoryException) return new PythonExceptions._OSError(PythonExceptions.NotADirectoryError);
            if (clrException is NotImplementedException) return new PythonExceptions.BaseException(PythonExceptions.NotImplementedError);
            if (clrException is OutOfMemoryException) return new PythonExceptions.BaseException(PythonExceptions.MemoryError);
            if (clrException is ProcessLookupException) return new PythonExceptions._OSError(PythonExceptions.ProcessLookupError);
            if (clrException is RecursionException) return new PythonExceptions.BaseException(PythonExceptions.RecursionError);
            if (clrException is TimeoutException) return new PythonExceptions._OSError(PythonExceptions.TimeoutError);
            if (clrException is UnauthorizedAccessException) return new PythonExceptions._OSError(PythonExceptions.PermissionError);
            if (clrException is UnboundLocalException) return new PythonExceptions.BaseException(PythonExceptions.UnboundLocalError);
            if (clrException is UnicodeTranslateException) return new PythonExceptions._UnicodeTranslateError();
            if (clrException is WarningException) return new PythonExceptions.BaseException(PythonExceptions.Warning);
            if (clrException is ArgumentTypeException) return new PythonExceptions.BaseException(PythonExceptions.TypeError);
            if (clrException is AssertionException) return new PythonExceptions.BaseException(PythonExceptions.AssertionError);
            if (clrException is BufferException) return new PythonExceptions.BaseException(PythonExceptions.BufferError);
            if (clrException is FloatingPointException) return new PythonExceptions.BaseException(PythonExceptions.FloatingPointError);
            if (clrException is GeneratorExitException) return new PythonExceptions.BaseException(PythonExceptions.GeneratorExit);
            if (clrException is ImportException) return new PythonExceptions._ImportError();
            if (clrException is KeyboardInterruptException) return new PythonExceptions.BaseException(PythonExceptions.KeyboardInterrupt);
            if (clrException is LookupException) return new PythonExceptions.BaseException(PythonExceptions.LookupError);
            if (clrException is OSException) return new PythonExceptions._OSError();
            if (clrException is PythonException) return new PythonExceptions.BaseException(PythonExceptions.Exception);
            if (clrException is ReferenceException) return new PythonExceptions.BaseException(PythonExceptions.ReferenceError);
            if (clrException is RuntimeException) return new PythonExceptions.BaseException(PythonExceptions.RuntimeError);
            if (clrException is StopAsyncIterationException) return new PythonExceptions._StopAsyncIteration();
            if (clrException is StopIterationException) return new PythonExceptions._StopIteration();
            if (clrException is SyntaxErrorException) return new PythonExceptions._SyntaxError();
            if (clrException is SystemException) return new PythonExceptions.BaseException(PythonExceptions.SystemError);
            if (clrException is SystemExitException) return new PythonExceptions._SystemExit();
            if (clrException is UnboundNameException) return new PythonExceptions.BaseException(PythonExceptions.NameError);
            if (clrException is UnicodeException) return new PythonExceptions.BaseException(PythonExceptions.UnicodeError);
            return new BaseException(Exception);
        }

        // *** END GENERATED CODE ***

        #endregion
    }
}
