// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.

#nullable enable

using IronPython.Runtime.Exceptions;
using IronPython.Runtime.Types;

namespace IronPython.Modules {
    public static partial class Builtin {
        #region Generated builtin exceptions

        // *** BEGIN GENERATED CODE ***
        // generated by function: builtin_gen from: generate_exceptions.py

        public static PythonType SystemExit => PythonExceptions.SystemExit;
        public static PythonType KeyboardInterrupt => PythonExceptions.KeyboardInterrupt;
        public static PythonType GeneratorExit => PythonExceptions.GeneratorExit;
        public static PythonType Exception => PythonExceptions.Exception;
        public static PythonType StopIteration => PythonExceptions.StopIteration;
        public static PythonType StopAsyncIteration => PythonExceptions.StopAsyncIteration;
        public static PythonType ArithmeticError => PythonExceptions.ArithmeticError;
        public static PythonType FloatingPointError => PythonExceptions.FloatingPointError;
        public static PythonType OverflowError => PythonExceptions.OverflowError;
        public static PythonType ZeroDivisionError => PythonExceptions.ZeroDivisionError;
        public static PythonType AssertionError => PythonExceptions.AssertionError;
        public static PythonType AttributeError => PythonExceptions.AttributeError;
        public static PythonType BufferError => PythonExceptions.BufferError;
        public static PythonType EOFError => PythonExceptions.EOFError;
        public static PythonType ImportError => PythonExceptions.ImportError;
        public static PythonType ModuleNotFoundError => PythonExceptions.ModuleNotFoundError;
        public static PythonType LookupError => PythonExceptions.LookupError;
        public static PythonType IndexError => PythonExceptions.IndexError;
        public static PythonType KeyError => PythonExceptions.KeyError;
        public static PythonType MemoryError => PythonExceptions.MemoryError;
        public static PythonType NameError => PythonExceptions.NameError;
        public static PythonType UnboundLocalError => PythonExceptions.UnboundLocalError;
        public static PythonType OSError => PythonExceptions.OSError;
        public static PythonType BlockingIOError => PythonExceptions.BlockingIOError;
        public static PythonType ChildProcessError => PythonExceptions.ChildProcessError;
        public static PythonType ConnectionError => PythonExceptions.ConnectionError;
        public static PythonType BrokenPipeError => PythonExceptions.BrokenPipeError;
        public static PythonType ConnectionAbortedError => PythonExceptions.ConnectionAbortedError;
        public static PythonType ConnectionRefusedError => PythonExceptions.ConnectionRefusedError;
        public static PythonType ConnectionResetError => PythonExceptions.ConnectionResetError;
        public static PythonType FileExistsError => PythonExceptions.FileExistsError;
        public static PythonType FileNotFoundError => PythonExceptions.FileNotFoundError;
        public static PythonType InterruptedError => PythonExceptions.InterruptedError;
        public static PythonType IsADirectoryError => PythonExceptions.IsADirectoryError;
        public static PythonType NotADirectoryError => PythonExceptions.NotADirectoryError;
        public static PythonType PermissionError => PythonExceptions.PermissionError;
        public static PythonType ProcessLookupError => PythonExceptions.ProcessLookupError;
        public static PythonType TimeoutError => PythonExceptions.TimeoutError;
        public static PythonType ReferenceError => PythonExceptions.ReferenceError;
        public static PythonType RuntimeError => PythonExceptions.RuntimeError;
        public static PythonType NotImplementedError => PythonExceptions.NotImplementedError;
        public static PythonType RecursionError => PythonExceptions.RecursionError;
        public static PythonType SyntaxError => PythonExceptions.SyntaxError;
        public static PythonType IndentationError => PythonExceptions.IndentationError;
        public static PythonType TabError => PythonExceptions.TabError;
        public static PythonType SystemError => PythonExceptions.SystemError;
        public static PythonType TypeError => PythonExceptions.TypeError;
        public static PythonType ValueError => PythonExceptions.ValueError;
        public static PythonType UnicodeError => PythonExceptions.UnicodeError;
        public static PythonType UnicodeDecodeError => PythonExceptions.UnicodeDecodeError;
        public static PythonType UnicodeEncodeError => PythonExceptions.UnicodeEncodeError;
        public static PythonType UnicodeTranslateError => PythonExceptions.UnicodeTranslateError;
        public static PythonType Warning => PythonExceptions.Warning;
        public static PythonType DeprecationWarning => PythonExceptions.DeprecationWarning;
        public static PythonType PendingDeprecationWarning => PythonExceptions.PendingDeprecationWarning;
        public static PythonType RuntimeWarning => PythonExceptions.RuntimeWarning;
        public static PythonType SyntaxWarning => PythonExceptions.SyntaxWarning;
        public static PythonType UserWarning => PythonExceptions.UserWarning;
        public static PythonType FutureWarning => PythonExceptions.FutureWarning;
        public static PythonType ImportWarning => PythonExceptions.ImportWarning;
        public static PythonType UnicodeWarning => PythonExceptions.UnicodeWarning;
        public static PythonType BytesWarning => PythonExceptions.BytesWarning;
        public static PythonType ResourceWarning => PythonExceptions.ResourceWarning;

        // *** END GENERATED CODE ***

        #endregion

    }
}
