// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.

namespace IronPython.Compiler {
    public partial class Tokenizer {

        Token NextOperator(int ch) {
            switch (ch) {
                #region Generated Tokenize Ops

                // *** BEGIN GENERATED CODE ***
                // generated by function: tokenize_generator from: generate_ops.py

                case '+':
                    if (NextChar('=')) {
                        return Tokens.AddEqualToken;
                    }
                    return Tokens.AddToken;
                case '-':
                    if (NextChar('=')) {
                        return Tokens.SubtractEqualToken;
                    }
                    if (NextChar('>')) {
                        return Tokens.ReturnAnnotationToken;
                    }
                    return Tokens.SubtractToken;
                case '*':
                    if (NextChar('*')) {
                        if (NextChar('=')) {
                            return Tokens.PowerEqualToken;
                        }
                        return Tokens.PowerToken;
                    }
                    if (NextChar('=')) {
                        return Tokens.MultiplyEqualToken;
                    }
                    return Tokens.MultiplyToken;
                case '@':
                    if (NextChar('=')) {
                        return Tokens.MatMultEqualToken;
                    }
                    return Tokens.MatMultToken;
                case '/':
                    if (NextChar('/')) {
                        if (NextChar('=')) {
                            return Tokens.FloorDivideEqualToken;
                        }
                        return Tokens.FloorDivideToken;
                    }
                    if (NextChar('=')) {
                        return Tokens.TrueDivideEqualToken;
                    }
                    return Tokens.TrueDivideToken;
                case '%':
                    if (NextChar('=')) {
                        return Tokens.ModEqualToken;
                    }
                    return Tokens.ModToken;
                case '<':
                    if (NextChar('<')) {
                        if (NextChar('=')) {
                            return Tokens.LeftShiftEqualToken;
                        }
                        return Tokens.LeftShiftToken;
                    }
                    if (NextChar('=')) {
                        return Tokens.LessThanOrEqualToken;
                    }
                    return Tokens.LessThanToken;
                case '>':
                    if (NextChar('>')) {
                        if (NextChar('=')) {
                            return Tokens.RightShiftEqualToken;
                        }
                        return Tokens.RightShiftToken;
                    }
                    if (NextChar('=')) {
                        return Tokens.GreaterThanOrEqualToken;
                    }
                    return Tokens.GreaterThanToken;
                case '&':
                    if (NextChar('=')) {
                        return Tokens.BitwiseAndEqualToken;
                    }
                    return Tokens.BitwiseAndToken;
                case '|':
                    if (NextChar('=')) {
                        return Tokens.BitwiseOrEqualToken;
                    }
                    return Tokens.BitwiseOrToken;
                case '^':
                    if (NextChar('=')) {
                        return Tokens.ExclusiveOrEqualToken;
                    }
                    return Tokens.ExclusiveOrToken;
                case '=':
                    if (NextChar('=')) {
                        return Tokens.EqualsToken;
                    }
                    if (NextChar('>')) {
                        return Tokens.RightArrowToken;
                    }
                    return Tokens.AssignToken;
                case '!':
                    if (NextChar('=')) {
                        return Tokens.NotEqualsToken;
                    }
                    return BadChar(ch);
                case '(':
                    _state.ParenLevel++;
                    return Tokens.LeftParenthesisToken;
                case ')':
                    _state.ParenLevel--;
                    return Tokens.RightParenthesisToken;
                case '[':
                    _state.BracketLevel++;
                    return Tokens.LeftBracketToken;
                case ']':
                    _state.BracketLevel--;
                    return Tokens.RightBracketToken;
                case '{':
                    _state.BraceLevel++;
                    return Tokens.LeftBraceToken;
                case '}':
                    _state.BraceLevel--;
                    return Tokens.RightBraceToken;
                case ',':
                    return Tokens.CommaToken;
                case ':':
                    return Tokens.ColonToken;
                case ';':
                    return Tokens.SemicolonToken;
                case '~':
                    return Tokens.TwiddleToken;

                // *** END GENERATED CODE ***

                #endregion
            }

            return null;
        }
    }
}
