// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.


using System.Collections.Generic;
using Microsoft.Scripting;
using Microsoft.Scripting.Runtime;
using IronPython.Runtime.Binding;

namespace IronPython.Runtime.Types {
    internal static partial class PythonTypeInfo {
        public static Dictionary<string, PythonOperationKind> InitializeOperatorTable() {
            Dictionary<string, PythonOperationKind> pyOp = new Dictionary<string, PythonOperationKind>();

            #region Generated PythonOperator Mapping

            // *** BEGIN GENERATED CODE ***
            // generated by function: gen_operatorMapping from: generate_ops.py

            pyOp["__add__"] = PythonOperationKind.Add;
            pyOp["__radd__"] = PythonOperationKind.ReverseAdd;
            pyOp["__iadd__"] = PythonOperationKind.InPlaceAdd;
            pyOp["__sub__"] = PythonOperationKind.Subtract;
            pyOp["__rsub__"] = PythonOperationKind.ReverseSubtract;
            pyOp["__isub__"] = PythonOperationKind.InPlaceSubtract;
            pyOp["__pow__"] = PythonOperationKind.Power;
            pyOp["__rpow__"] = PythonOperationKind.ReversePower;
            pyOp["__ipow__"] = PythonOperationKind.InPlacePower;
            pyOp["__mul__"] = PythonOperationKind.Multiply;
            pyOp["__rmul__"] = PythonOperationKind.ReverseMultiply;
            pyOp["__imul__"] = PythonOperationKind.InPlaceMultiply;
            pyOp["__floordiv__"] = PythonOperationKind.FloorDivide;
            pyOp["__rfloordiv__"] = PythonOperationKind.ReverseFloorDivide;
            pyOp["__ifloordiv__"] = PythonOperationKind.InPlaceFloorDivide;
            pyOp["__div__"] = PythonOperationKind.Divide;
            pyOp["__rdiv__"] = PythonOperationKind.ReverseDivide;
            pyOp["__idiv__"] = PythonOperationKind.InPlaceDivide;
            pyOp["__truediv__"] = PythonOperationKind.TrueDivide;
            pyOp["__rtruediv__"] = PythonOperationKind.ReverseTrueDivide;
            pyOp["__itruediv__"] = PythonOperationKind.InPlaceTrueDivide;
            pyOp["__mod__"] = PythonOperationKind.Mod;
            pyOp["__rmod__"] = PythonOperationKind.ReverseMod;
            pyOp["__imod__"] = PythonOperationKind.InPlaceMod;
            pyOp["__lshift__"] = PythonOperationKind.LeftShift;
            pyOp["__rlshift__"] = PythonOperationKind.ReverseLeftShift;
            pyOp["__ilshift__"] = PythonOperationKind.InPlaceLeftShift;
            pyOp["__rshift__"] = PythonOperationKind.RightShift;
            pyOp["__rrshift__"] = PythonOperationKind.ReverseRightShift;
            pyOp["__irshift__"] = PythonOperationKind.InPlaceRightShift;
            pyOp["__and__"] = PythonOperationKind.BitwiseAnd;
            pyOp["__rand__"] = PythonOperationKind.ReverseBitwiseAnd;
            pyOp["__iand__"] = PythonOperationKind.InPlaceBitwiseAnd;
            pyOp["__or__"] = PythonOperationKind.BitwiseOr;
            pyOp["__ror__"] = PythonOperationKind.ReverseBitwiseOr;
            pyOp["__ior__"] = PythonOperationKind.InPlaceBitwiseOr;
            pyOp["__xor__"] = PythonOperationKind.ExclusiveOr;
            pyOp["__rxor__"] = PythonOperationKind.ReverseExclusiveOr;
            pyOp["__ixor__"] = PythonOperationKind.InPlaceExclusiveOr;
            pyOp["__lt__"] = PythonOperationKind.LessThan;
            pyOp["__gt__"] = PythonOperationKind.GreaterThan;
            pyOp["__le__"] = PythonOperationKind.LessThanOrEqual;
            pyOp["__ge__"] = PythonOperationKind.GreaterThanOrEqual;
            pyOp["__eq__"] = PythonOperationKind.Equal;
            pyOp["__ne__"] = PythonOperationKind.NotEqual;
            pyOp["__lg__"] = PythonOperationKind.LessThanGreaterThan;

            // *** END GENERATED CODE ***

            #endregion

            pyOp["__getitem__"] = PythonOperationKind.GetItem;
            pyOp["__setitem__"] = PythonOperationKind.SetItem;
            pyOp["__delitem__"] = PythonOperationKind.DeleteItem;
            pyOp["__cmp__"] = PythonOperationKind.Compare;
            pyOp["__pos__"] = PythonOperationKind.Positive;
            pyOp["__neg__"] = PythonOperationKind.Negate;
            pyOp["__invert__"] = PythonOperationKind.OnesComplement;
            pyOp["__len__"] = PythonOperationKind.Length;
            pyOp["__divmod__"] = PythonOperationKind.DivMod;
            pyOp["__rdivmod__"] = PythonOperationKind.ReverseDivMod;
            pyOp["__pow__"] = PythonOperationKind.Power;
            pyOp["__contains__"] = PythonOperationKind.Contains;

            pyOp["__abs__"] = PythonOperationKind.AbsoluteValue;

            return pyOp;
        }
    }
}
