// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.


using System.Linq.Expressions;

using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.Dynamic;
using System.Globalization;
using System.IO;
using System.Reflection;
using System.Runtime.CompilerServices;
using System.Security;
using System.Text;
using System.Threading;

using Microsoft.Scripting;
using Microsoft.Scripting.Actions;
using Microsoft.Scripting.Generation;
using Microsoft.Scripting.Runtime;
using Microsoft.Scripting.Utils;

using IronPython.Compiler;
using IronPython.Modules;
using IronPython.Runtime.Binding;
using IronPython.Runtime.Exceptions;
using IronPython.Runtime.Operations;
using IronPython.Runtime.Types;

using Debugging = Microsoft.Scripting.Debugging;
using PyAst = IronPython.Compiler.Ast;


namespace IronPython.Runtime  {
    public sealed partial class PythonContext : LanguageContext {
        #region Generated Python Shared Call Sites Properties

        // *** BEGIN GENERATED CODE ***
        // generated by function: gen_shared_call_sites_properties from: generate_calls.py

        internal CallSite<Func<CallSite, CodeContext, object, object>> CallSite0 {
            get {
                EnsureCall0Site();
                return _callSite0;
            }
        }

        private void EnsureCall0Site() {
            if (_callSite0 == null) {
                Interlocked.CompareExchange(
                    ref _callSite0,
                    CallSite<Func<CallSite, CodeContext, object, object>>.Create(Invoke(new CallSignature(0))),
                    null
                );
            }
        }

        internal CallSite<Func<CallSite, CodeContext, object, object, object>> CallSite1 {
            get {
                EnsureCall1Site();
                return _callSite1;
            }
        }

        private void EnsureCall1Site() {
            if (_callSite1 == null) {
                Interlocked.CompareExchange(
                    ref _callSite1,
                    CallSite<Func<CallSite, CodeContext, object, object, object>>.Create(Invoke(new CallSignature(1))),
                    null
                );
            }
        }

        internal CallSite<Func<CallSite, CodeContext, object, object, object, object>> CallSite2 {
            get {
                EnsureCall2Site();
                return _callSite2;
            }
        }

        private void EnsureCall2Site() {
            if (_callSite2 == null) {
                Interlocked.CompareExchange(
                    ref _callSite2,
                    CallSite<Func<CallSite, CodeContext, object, object, object, object>>.Create(Invoke(new CallSignature(2))),
                    null
                );
            }
        }

        internal CallSite<Func<CallSite, CodeContext, object, object, object, object, object>> CallSite3 {
            get {
                EnsureCall3Site();
                return _callSite3;
            }
        }

        private void EnsureCall3Site() {
            if (_callSite3 == null) {
                Interlocked.CompareExchange(
                    ref _callSite3,
                    CallSite<Func<CallSite, CodeContext, object, object, object, object, object>>.Create(Invoke(new CallSignature(3))),
                    null
                );
            }
        }

        internal CallSite<Func<CallSite, CodeContext, object, object, object, object, object, object>> CallSite4 {
            get {
                EnsureCall4Site();
                return _callSite4;
            }
        }

        private void EnsureCall4Site() {
            if (_callSite4 == null) {
                Interlocked.CompareExchange(
                    ref _callSite4,
                    CallSite<Func<CallSite, CodeContext, object, object, object, object, object, object>>.Create(Invoke(new CallSignature(4))),
                    null
                );
            }
        }

        internal CallSite<Func<CallSite, CodeContext, object, object, object, object, object, object, object>> CallSite5 {
            get {
                EnsureCall5Site();
                return _callSite5;
            }
        }

        private void EnsureCall5Site() {
            if (_callSite5 == null) {
                Interlocked.CompareExchange(
                    ref _callSite5,
                    CallSite<Func<CallSite, CodeContext, object, object, object, object, object, object, object>>.Create(Invoke(new CallSignature(5))),
                    null
                );
            }
        }

        internal CallSite<Func<CallSite, CodeContext, object, object, object, object, object, object, object, object>> CallSite6 {
            get {
                EnsureCall6Site();
                return _callSite6;
            }
        }

        private void EnsureCall6Site() {
            if (_callSite6 == null) {
                Interlocked.CompareExchange(
                    ref _callSite6,
                    CallSite<Func<CallSite, CodeContext, object, object, object, object, object, object, object, object>>.Create(Invoke(new CallSignature(6))),
                    null
                );
            }
        }

        // *** END GENERATED CODE ***

        #endregion


    }
}
