// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.


using System;
using System.Globalization;
using System.Runtime.CompilerServices;
using IronPython.Runtime.Types;
using Microsoft.Scripting.Runtime;
using Microsoft.Scripting.Utils;

using System.Numerics;

#pragma warning disable 675

namespace IronPython.Runtime.Operations {

    #region Generated IntOps

    // *** BEGIN GENERATED CODE ***
    // generated by function: gen_all from: generate_alltypes.py

    public static partial class SByteOps {
        [StaticExtensionMethod]
        public static object __new__(PythonType cls) {
            return __new__(cls, default(SByte));
        }

        [StaticExtensionMethod]
        public static object __new__(PythonType cls, object value) {
            if (cls != DynamicHelpers.GetPythonTypeFromType(typeof(SByte))) {
                throw PythonOps.TypeError("SByte.__new__: first argument must be SByte type.");
            }
            IConvertible valueConvertible;
            if ((valueConvertible = value as IConvertible) != null) {
                switch (valueConvertible.GetTypeCode()) {
                    case TypeCode.Byte: return (SByte)(Byte)value;
                    case TypeCode.SByte: return (SByte)(SByte)value;
                    case TypeCode.Int16: return (SByte)(Int16)value;
                    case TypeCode.UInt16: return (SByte)(UInt16)value;
                    case TypeCode.Int32: return (SByte)(Int32)value;
                    case TypeCode.UInt32: return (SByte)(UInt32)value;
                    case TypeCode.Int64: return (SByte)(Int64)value;
                    case TypeCode.UInt64: return (SByte)(UInt64)value;
                    case TypeCode.Single: return (SByte)(Single)value;
                    case TypeCode.Double: return (SByte)(Double)value;
                }
            }
            if (value is String) {
                return SByte.Parse((String)value);
            } else if (value is BigInteger) {
                return (SByte)(BigInteger)value;
            } else if (value is Extensible<BigInteger>) {
                return (SByte)((Extensible<BigInteger>)value).Value;
            } else if (value is Extensible<double>) {
                return (SByte)((Extensible<double>)value).Value;
            }
            throw PythonOps.ValueError("invalid value for SByte.__new__");
        }
        // Unary Operations
        [SpecialName]
        public static SByte Plus(SByte x) {
            return x;
        }
        [SpecialName]
        public static object Negate(SByte x) {
            if (x == SByte.MinValue) return -(Int16)SByte.MinValue;
            else return (SByte)(-x);
        }
        [SpecialName]
        public static object Abs(SByte x) {
            if (x < 0) {
                if (x == SByte.MinValue) return -(Int16)SByte.MinValue;
                else return (SByte)(-x);
            } else {
                return x;
            }
        }
        [SpecialName]
        public static SByte OnesComplement(SByte x) {
            return (SByte)(~(x));
        }
        public static bool __nonzero__(SByte x) {
            return (x != 0);
        }

        public static string __repr__(SByte x) {
            return x.ToString(CultureInfo.InvariantCulture);
        }
        public static SByte __trunc__(SByte x) {
            return x;
        }
        public static int __hash__(SByte x) {
            return unchecked((int)x);
        }
        public static int __index__(SByte x) {
            return unchecked((int)x);
        }

        // Binary Operations - Arithmetic
        [SpecialName]
        public static object Add(SByte x, SByte y) {
            Int16 result = (Int16)(((Int16)x) + ((Int16)y));
            if (SByte.MinValue <= result && result <= SByte.MaxValue) {
                return (SByte)(result);
            } else {
                return result;
            }
        }
        [SpecialName]
        public static object Subtract(SByte x, SByte y) {
            Int16 result = (Int16)(((Int16)x) - ((Int16)y));
            if (SByte.MinValue <= result && result <= SByte.MaxValue) {
                return (SByte)(result);
            } else {
                return result;
            }
        }
        [SpecialName]
        public static object Multiply(SByte x, SByte y) {
            Int16 result = (Int16)(((Int16)x) * ((Int16)y));
            if (SByte.MinValue <= result && result <= SByte.MaxValue) {
                return (SByte)(result);
            } else {
                return result;
            }
        }
        [SpecialName]
        public static object Divide(SByte x, SByte y) {
            return FloorDivide(x, y);
        }
        [SpecialName]
        public static double TrueDivide(SByte x, SByte y) {
            return DoubleOps.TrueDivide((double)x, (double)y);

        }
        [SpecialName]
        public static object FloorDivide(SByte x, SByte y) {
            if (y == -1 && x == SByte.MinValue) {
                return -(Int16)SByte.MinValue;
            } else {
                return (SByte)MathUtils.FloorDivideUnchecked(x, y);
            }
        }
        [SpecialName]
        public static SByte Mod(SByte x, SByte y) {
            return (SByte)Int32Ops.Mod((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static object Power(SByte x, SByte y) {
            return Int32Ops.Power((Int32)x, (Int32)y);
        }

        // Binary Operations - Bitwise
        [SpecialName]
        public static object LeftShift(SByte x, [NotNull]BigInteger y) {
            return BigIntegerOps.LeftShift((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static SByte RightShift(SByte x, [NotNull]BigInteger y) {
            return (SByte)BigIntegerOps.RightShift((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static object LeftShift(SByte x, Int32 y) {
            return Int32Ops.LeftShift((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static SByte RightShift(SByte x, Int32 y) {
            return (SByte)Int32Ops.RightShift((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static SByte BitwiseAnd(SByte x, SByte y) {
            return (SByte)(x & y);
        }
        [SpecialName]
        public static SByte BitwiseOr(SByte x, SByte y) {
            return (SByte)(x | y);
        }
        [SpecialName]
        public static SByte ExclusiveOr(SByte x, SByte y) {
            return (SByte)(x ^ y);
        }

        // Binary Operations - Comparisons
        [SpecialName]
        public static int Compare(SByte x, SByte y) {
            return x == y ? 0 : x > y ? 1 : -1;
        }

        // Conversion operators
        [SpecialName, ExplicitConversionMethod]
        public static Byte ConvertToByte(SByte x) {
            if (x >= 0) {
                return (Byte)x;
            }
            throw Converter.CannotConvertOverflow("Byte", x);
        }
        [SpecialName, ImplicitConversionMethod]
        public static Int16 ConvertToInt16(SByte x) {
            return (Int16)x;
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt16 ConvertToUInt16(SByte x) {
            if (x >= 0) {
                return (UInt16)x;
            }
            throw Converter.CannotConvertOverflow("UInt16", x);
        }
        [SpecialName, ImplicitConversionMethod]
        public static Int32 ConvertToInt32(SByte x) {
            return (Int32)x;
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt32 ConvertToUInt32(SByte x) {
            if (x >= 0) {
                return (UInt32)x;
            }
            throw Converter.CannotConvertOverflow("UInt32", x);
        }
        [SpecialName, ImplicitConversionMethod]
        public static Int64 ConvertToInt64(SByte x) {
            return (Int64)x;
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt64 ConvertToUInt64(SByte x) {
            if (x >= 0) {
                return (UInt64)x;
            }
            throw Converter.CannotConvertOverflow("UInt64", x);
        }
        [SpecialName, ImplicitConversionMethod]
        public static Single ConvertToSingle(SByte x) {
            return (Single)x;
        }
        [SpecialName, ImplicitConversionMethod]
        public static Double ConvertToDouble(SByte x) {
            return (Double)x;
        }

        // Public API - Numerics
        [PropertyMethod, SpecialName]
        public static SByte Getreal(SByte x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static SByte Getimag(SByte x) {
            return (SByte)0;
        }
        public static SByte conjugate(SByte x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static SByte Getnumerator(SByte x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static SByte Getdenominator(SByte x) {
            return (SByte)1;
        }
        public static string __hex__(SByte value) {
            return BigIntegerOps.__hex__(value);
        }
        public static int bit_length(SByte value) {
            return MathUtils.BitLength((int)value);
        }
    }

    public static partial class ByteOps {
        [StaticExtensionMethod]
        public static object __new__(PythonType cls) {
            return __new__(cls, default(Byte));
        }

        [StaticExtensionMethod]
        public static object __new__(PythonType cls, object value) {
            if (cls != DynamicHelpers.GetPythonTypeFromType(typeof(Byte))) {
                throw PythonOps.TypeError("Byte.__new__: first argument must be Byte type.");
            }
            IConvertible valueConvertible;
            if ((valueConvertible = value as IConvertible) != null) {
                switch (valueConvertible.GetTypeCode()) {
                    case TypeCode.Byte: return (Byte)(Byte)value;
                    case TypeCode.SByte: return (Byte)(SByte)value;
                    case TypeCode.Int16: return (Byte)(Int16)value;
                    case TypeCode.UInt16: return (Byte)(UInt16)value;
                    case TypeCode.Int32: return (Byte)(Int32)value;
                    case TypeCode.UInt32: return (Byte)(UInt32)value;
                    case TypeCode.Int64: return (Byte)(Int64)value;
                    case TypeCode.UInt64: return (Byte)(UInt64)value;
                    case TypeCode.Single: return (Byte)(Single)value;
                    case TypeCode.Double: return (Byte)(Double)value;
                }
            }
            if (value is String) {
                return Byte.Parse((String)value);
            } else if (value is BigInteger) {
                return (Byte)(BigInteger)value;
            } else if (value is Extensible<BigInteger>) {
                return (Byte)((Extensible<BigInteger>)value).Value;
            } else if (value is Extensible<double>) {
                return (Byte)((Extensible<double>)value).Value;
            }
            throw PythonOps.ValueError("invalid value for Byte.__new__");
        }
        // Unary Operations
        [SpecialName]
        public static Byte Plus(Byte x) {
            return x;
        }
        [SpecialName]
        public static object Negate(Byte x) {
            return Int16Ops.Negate((Int16)x);
        }
        [SpecialName]
        public static Byte Abs(Byte x) {
            return x;
        }
        [SpecialName]
        public static object OnesComplement(Byte x) {
            return Int16Ops.OnesComplement((Int16)x);
        }
        public static bool __nonzero__(Byte x) {
            return (x != 0);
        }

        public static string __repr__(Byte x) {
            return x.ToString(CultureInfo.InvariantCulture);
        }
        public static Byte __trunc__(Byte x) {
            return x;
        }
        public static int __hash__(Byte x) {
            return unchecked((int)x);
        }
        public static int __index__(Byte x) {
            return unchecked((int)x);
        }

        // Binary Operations - Arithmetic
        [SpecialName]
        public static object Add(Byte x, Byte y) {
            Int16 result = (Int16)(((Int16)x) + ((Int16)y));
            if (Byte.MinValue <= result && result <= Byte.MaxValue) {
                return (Byte)(result);
            } else {
                return result;
            }
        }
        [SpecialName]
        public static object Add(Byte x, SByte y) {
            return Int16Ops.Add((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static object Add(SByte x, Byte y) {
            return Int16Ops.Add((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static object Subtract(Byte x, Byte y) {
            Int16 result = (Int16)(((Int16)x) - ((Int16)y));
            if (Byte.MinValue <= result && result <= Byte.MaxValue) {
                return (Byte)(result);
            } else {
                return result;
            }
        }
        [SpecialName]
        public static object Subtract(Byte x, SByte y) {
            return Int16Ops.Subtract((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static object Subtract(SByte x, Byte y) {
            return Int16Ops.Subtract((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static object Multiply(Byte x, Byte y) {
            Int16 result = (Int16)(((Int16)x) * ((Int16)y));
            if (Byte.MinValue <= result && result <= Byte.MaxValue) {
                return (Byte)(result);
            } else {
                return result;
            }
        }
        [SpecialName]
        public static object Multiply(Byte x, SByte y) {
            return Int16Ops.Multiply((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static object Multiply(SByte x, Byte y) {
            return Int16Ops.Multiply((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static object Divide(Byte x, Byte y) {
            return FloorDivide(x, y);
        }
        [SpecialName]
        public static object Divide(Byte x, SByte y) {
            return Int16Ops.Divide((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static object Divide(SByte x, Byte y) {
            return Int16Ops.Divide((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static double TrueDivide(Byte x, Byte y) {
            return DoubleOps.TrueDivide((double)x, (double)y);

        }
        [SpecialName]
        public static double TrueDivide(Byte x, SByte y) {
            return Int16Ops.TrueDivide((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static double TrueDivide(SByte x, Byte y) {
            return Int16Ops.TrueDivide((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static Byte FloorDivide(Byte x, Byte y) {
            return (Byte)(x / y);
        }
        [SpecialName]
        public static object FloorDivide(Byte x, SByte y) {
            return Int16Ops.FloorDivide((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static object FloorDivide(SByte x, Byte y) {
            return Int16Ops.FloorDivide((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static Byte Mod(Byte x, Byte y) {
            return (Byte)(x % y);
        }
        [SpecialName]
        public static Int16 Mod(Byte x, SByte y) {
            return Int16Ops.Mod((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static Int16 Mod(SByte x, Byte y) {
            return Int16Ops.Mod((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static object Power(Byte x, Byte y) {
            return Int32Ops.Power((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static object Power(Byte x, SByte y) {
            return Int16Ops.Power((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static object Power(SByte x, Byte y) {
            return Int16Ops.Power((Int16)x, (Int16)y);
        }

        // Binary Operations - Bitwise
        [SpecialName]
        public static object LeftShift(Byte x, [NotNull]BigInteger y) {
            return BigIntegerOps.LeftShift((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static Byte RightShift(Byte x, [NotNull]BigInteger y) {
            return (Byte)BigIntegerOps.RightShift((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static object LeftShift(Byte x, Int32 y) {
            return Int32Ops.LeftShift((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static Byte RightShift(Byte x, Int32 y) {
            return (Byte)Int32Ops.RightShift((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static Byte BitwiseAnd(Byte x, Byte y) {
            return (Byte)(x & y);
        }
        [SpecialName]
        public static Int16 BitwiseAnd(Byte x, SByte y) {
            return Int16Ops.BitwiseAnd((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static Int16 BitwiseAnd(SByte x, Byte y) {
            return Int16Ops.BitwiseAnd((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static Byte BitwiseOr(Byte x, Byte y) {
            return (Byte)(x | y);
        }
        [SpecialName]
        public static Int16 BitwiseOr(Byte x, SByte y) {
            return Int16Ops.BitwiseOr((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static Int16 BitwiseOr(SByte x, Byte y) {
            return Int16Ops.BitwiseOr((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static Byte ExclusiveOr(Byte x, Byte y) {
            return (Byte)(x ^ y);
        }
        [SpecialName]
        public static Int16 ExclusiveOr(Byte x, SByte y) {
            return Int16Ops.ExclusiveOr((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static Int16 ExclusiveOr(SByte x, Byte y) {
            return Int16Ops.ExclusiveOr((Int16)x, (Int16)y);
        }

        // Binary Operations - Comparisons
        [SpecialName]
        public static int Compare(Byte x, Byte y) {
            return x == y ? 0 : x > y ? 1 : -1;
        }
        [SpecialName]
        public static int Compare(Byte x, SByte y) {
            return Int16Ops.Compare((Int16)x, (Int16)y);
        }
        [SpecialName]
        public static int Compare(SByte x, Byte y) {
            return Int16Ops.Compare((Int16)x, (Int16)y);
        }

        // Conversion operators
        [SpecialName, ExplicitConversionMethod]
        public static SByte ConvertToSByte(Byte x) {
            if (x <= (Byte)SByte.MaxValue) {
                return (SByte)x;
            }
            throw Converter.CannotConvertOverflow("SByte", x);
        }
        [SpecialName, ImplicitConversionMethod]
        public static Int16 ConvertToInt16(Byte x) {
            return (Int16)x;
        }
        [SpecialName, ImplicitConversionMethod]
        public static UInt16 ConvertToUInt16(Byte x) {
            return (UInt16)x;
        }
        [SpecialName, ImplicitConversionMethod]
        public static Int32 ConvertToInt32(Byte x) {
            return (Int32)x;
        }
        [SpecialName, ImplicitConversionMethod]
        public static UInt32 ConvertToUInt32(Byte x) {
            return (UInt32)x;
        }
        [SpecialName, ImplicitConversionMethod]
        public static Int64 ConvertToInt64(Byte x) {
            return (Int64)x;
        }
        [SpecialName, ImplicitConversionMethod]
        public static UInt64 ConvertToUInt64(Byte x) {
            return (UInt64)x;
        }
        [SpecialName, ImplicitConversionMethod]
        public static Single ConvertToSingle(Byte x) {
            return (Single)x;
        }
        [SpecialName, ImplicitConversionMethod]
        public static Double ConvertToDouble(Byte x) {
            return (Double)x;
        }

        // Public API - Numerics
        [PropertyMethod, SpecialName]
        public static Byte Getreal(Byte x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static Byte Getimag(Byte x) {
            return (Byte)0;
        }
        public static Byte conjugate(Byte x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static Byte Getnumerator(Byte x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static Byte Getdenominator(Byte x) {
            return (Byte)1;
        }
        public static string __hex__(Byte value) {
            return BigIntegerOps.__hex__(value);
        }
        public static int bit_length(Byte value) {
            return MathUtils.BitLength((int)value);
        }
    }

    public static partial class Int16Ops {
        [StaticExtensionMethod]
        public static object __new__(PythonType cls) {
            return __new__(cls, default(Int16));
        }

        [StaticExtensionMethod]
        public static object __new__(PythonType cls, object value) {
            if (cls != DynamicHelpers.GetPythonTypeFromType(typeof(Int16))) {
                throw PythonOps.TypeError("Int16.__new__: first argument must be Int16 type.");
            }
            IConvertible valueConvertible;
            if ((valueConvertible = value as IConvertible) != null) {
                switch (valueConvertible.GetTypeCode()) {
                    case TypeCode.Byte: return (Int16)(Byte)value;
                    case TypeCode.SByte: return (Int16)(SByte)value;
                    case TypeCode.Int16: return (Int16)(Int16)value;
                    case TypeCode.UInt16: return (Int16)(UInt16)value;
                    case TypeCode.Int32: return (Int16)(Int32)value;
                    case TypeCode.UInt32: return (Int16)(UInt32)value;
                    case TypeCode.Int64: return (Int16)(Int64)value;
                    case TypeCode.UInt64: return (Int16)(UInt64)value;
                    case TypeCode.Single: return (Int16)(Single)value;
                    case TypeCode.Double: return (Int16)(Double)value;
                }
            }
            if (value is String) {
                return Int16.Parse((String)value);
            } else if (value is BigInteger) {
                return (Int16)(BigInteger)value;
            } else if (value is Extensible<BigInteger>) {
                return (Int16)((Extensible<BigInteger>)value).Value;
            } else if (value is Extensible<double>) {
                return (Int16)((Extensible<double>)value).Value;
            }
            throw PythonOps.ValueError("invalid value for Int16.__new__");
        }
        // Unary Operations
        [SpecialName]
        public static Int16 Plus(Int16 x) {
            return x;
        }
        [SpecialName]
        public static object Negate(Int16 x) {
            if (x == Int16.MinValue) return -(Int32)Int16.MinValue;
            else return (Int16)(-x);
        }
        [SpecialName]
        public static object Abs(Int16 x) {
            if (x < 0) {
                if (x == Int16.MinValue) return -(Int32)Int16.MinValue;
                else return (Int16)(-x);
            } else {
                return x;
            }
        }
        [SpecialName]
        public static Int16 OnesComplement(Int16 x) {
            return (Int16)(~(x));
        }
        public static bool __nonzero__(Int16 x) {
            return (x != 0);
        }

        public static string __repr__(Int16 x) {
            return x.ToString(CultureInfo.InvariantCulture);
        }
        public static Int16 __trunc__(Int16 x) {
            return x;
        }
        public static int __hash__(Int16 x) {
            return unchecked((int)x);
        }
        public static int __index__(Int16 x) {
            return unchecked((int)x);
        }

        // Binary Operations - Arithmetic
        [SpecialName]
        public static object Add(Int16 x, Int16 y) {
            Int32 result = (Int32)(((Int32)x) + ((Int32)y));
            if (Int16.MinValue <= result && result <= Int16.MaxValue) {
                return (Int16)(result);
            } else {
                return result;
            }
        }
        [SpecialName]
        public static object Subtract(Int16 x, Int16 y) {
            Int32 result = (Int32)(((Int32)x) - ((Int32)y));
            if (Int16.MinValue <= result && result <= Int16.MaxValue) {
                return (Int16)(result);
            } else {
                return result;
            }
        }
        [SpecialName]
        public static object Multiply(Int16 x, Int16 y) {
            Int32 result = (Int32)(((Int32)x) * ((Int32)y));
            if (Int16.MinValue <= result && result <= Int16.MaxValue) {
                return (Int16)(result);
            } else {
                return result;
            }
        }
        [SpecialName]
        public static object Divide(Int16 x, Int16 y) {
            return FloorDivide(x, y);
        }
        [SpecialName]
        public static double TrueDivide(Int16 x, Int16 y) {
            return DoubleOps.TrueDivide((double)x, (double)y);

        }
        [SpecialName]
        public static object FloorDivide(Int16 x, Int16 y) {
            if (y == -1 && x == Int16.MinValue) {
                return -(Int32)Int16.MinValue;
            } else {
                return (Int16)MathUtils.FloorDivideUnchecked(x, y);
            }
        }
        [SpecialName]
        public static Int16 Mod(Int16 x, Int16 y) {
            return (Int16)Int32Ops.Mod((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static object Power(Int16 x, Int16 y) {
            return Int32Ops.Power((Int32)x, (Int32)y);
        }

        // Binary Operations - Bitwise
        [SpecialName]
        public static object LeftShift(Int16 x, [NotNull]BigInteger y) {
            return BigIntegerOps.LeftShift((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static Int16 RightShift(Int16 x, [NotNull]BigInteger y) {
            return (Int16)BigIntegerOps.RightShift((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static object LeftShift(Int16 x, Int32 y) {
            return Int32Ops.LeftShift((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static Int16 RightShift(Int16 x, Int32 y) {
            return (Int16)Int32Ops.RightShift((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static Int16 BitwiseAnd(Int16 x, Int16 y) {
            return (Int16)(x & y);
        }
        [SpecialName]
        public static Int16 BitwiseOr(Int16 x, Int16 y) {
            return (Int16)(x | y);
        }
        [SpecialName]
        public static Int16 ExclusiveOr(Int16 x, Int16 y) {
            return (Int16)(x ^ y);
        }

        // Binary Operations - Comparisons
        [SpecialName]
        public static int Compare(Int16 x, Int16 y) {
            return x == y ? 0 : x > y ? 1 : -1;
        }

        // Conversion operators
        [SpecialName, ExplicitConversionMethod]
        public static SByte ConvertToSByte(Int16 x) {
            if (SByte.MinValue <= x && x <= SByte.MaxValue) {
                return (SByte)x;
            }
            throw Converter.CannotConvertOverflow("SByte", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Byte ConvertToByte(Int16 x) {
            if (Byte.MinValue <= x && x <= Byte.MaxValue) {
                return (Byte)x;
            }
            throw Converter.CannotConvertOverflow("Byte", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt16 ConvertToUInt16(Int16 x) {
            if (x >= 0) {
                return (UInt16)x;
            }
            throw Converter.CannotConvertOverflow("UInt16", x);
        }
        [SpecialName, ImplicitConversionMethod]
        public static Int32 ConvertToInt32(Int16 x) {
            return (Int32)x;
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt32 ConvertToUInt32(Int16 x) {
            if (x >= 0) {
                return (UInt32)x;
            }
            throw Converter.CannotConvertOverflow("UInt32", x);
        }
        [SpecialName, ImplicitConversionMethod]
        public static Int64 ConvertToInt64(Int16 x) {
            return (Int64)x;
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt64 ConvertToUInt64(Int16 x) {
            if (x >= 0) {
                return (UInt64)x;
            }
            throw Converter.CannotConvertOverflow("UInt64", x);
        }
        [SpecialName, ImplicitConversionMethod]
        public static Single ConvertToSingle(Int16 x) {
            return (Single)x;
        }
        [SpecialName, ImplicitConversionMethod]
        public static Double ConvertToDouble(Int16 x) {
            return (Double)x;
        }

        // Public API - Numerics
        [PropertyMethod, SpecialName]
        public static Int16 Getreal(Int16 x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static Int16 Getimag(Int16 x) {
            return (Int16)0;
        }
        public static Int16 conjugate(Int16 x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static Int16 Getnumerator(Int16 x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static Int16 Getdenominator(Int16 x) {
            return (Int16)1;
        }
        public static string __hex__(Int16 value) {
            return BigIntegerOps.__hex__(value);
        }
        public static int bit_length(Int16 value) {
            return MathUtils.BitLength((int)value);
        }
    }

    public static partial class UInt16Ops {
        [StaticExtensionMethod]
        public static object __new__(PythonType cls) {
            return __new__(cls, default(UInt16));
        }

        [StaticExtensionMethod]
        public static object __new__(PythonType cls, object value) {
            if (cls != DynamicHelpers.GetPythonTypeFromType(typeof(UInt16))) {
                throw PythonOps.TypeError("UInt16.__new__: first argument must be UInt16 type.");
            }
            IConvertible valueConvertible;
            if ((valueConvertible = value as IConvertible) != null) {
                switch (valueConvertible.GetTypeCode()) {
                    case TypeCode.Byte: return (UInt16)(Byte)value;
                    case TypeCode.SByte: return (UInt16)(SByte)value;
                    case TypeCode.Int16: return (UInt16)(Int16)value;
                    case TypeCode.UInt16: return (UInt16)(UInt16)value;
                    case TypeCode.Int32: return (UInt16)(Int32)value;
                    case TypeCode.UInt32: return (UInt16)(UInt32)value;
                    case TypeCode.Int64: return (UInt16)(Int64)value;
                    case TypeCode.UInt64: return (UInt16)(UInt64)value;
                    case TypeCode.Single: return (UInt16)(Single)value;
                    case TypeCode.Double: return (UInt16)(Double)value;
                }
            }
            if (value is String) {
                return UInt16.Parse((String)value);
            } else if (value is BigInteger) {
                return (UInt16)(BigInteger)value;
            } else if (value is Extensible<BigInteger>) {
                return (UInt16)((Extensible<BigInteger>)value).Value;
            } else if (value is Extensible<double>) {
                return (UInt16)((Extensible<double>)value).Value;
            }
            throw PythonOps.ValueError("invalid value for UInt16.__new__");
        }
        // Unary Operations
        [SpecialName]
        public static UInt16 Plus(UInt16 x) {
            return x;
        }
        [SpecialName]
        public static object Negate(UInt16 x) {
            return Int32Ops.Negate((Int32)x);
        }
        [SpecialName]
        public static UInt16 Abs(UInt16 x) {
            return x;
        }
        [SpecialName]
        public static object OnesComplement(UInt16 x) {
            return Int32Ops.OnesComplement((Int32)x);
        }
        public static bool __nonzero__(UInt16 x) {
            return (x != 0);
        }

        public static string __repr__(UInt16 x) {
            return x.ToString(CultureInfo.InvariantCulture);
        }
        public static UInt16 __trunc__(UInt16 x) {
            return x;
        }
        public static int __hash__(UInt16 x) {
            return unchecked((int)x);
        }
        public static int __index__(UInt16 x) {
            return unchecked((int)x);
        }

        // Binary Operations - Arithmetic
        [SpecialName]
        public static object Add(UInt16 x, UInt16 y) {
            Int32 result = (Int32)(((Int32)x) + ((Int32)y));
            if (UInt16.MinValue <= result && result <= UInt16.MaxValue) {
                return (UInt16)(result);
            } else {
                return result;
            }
        }
        [SpecialName]
        public static object Add(UInt16 x, Int16 y) {
            return Int32Ops.Add((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static object Add(Int16 x, UInt16 y) {
            return Int32Ops.Add((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static object Subtract(UInt16 x, UInt16 y) {
            Int32 result = (Int32)(((Int32)x) - ((Int32)y));
            if (UInt16.MinValue <= result && result <= UInt16.MaxValue) {
                return (UInt16)(result);
            } else {
                return result;
            }
        }
        [SpecialName]
        public static object Subtract(UInt16 x, Int16 y) {
            return Int32Ops.Subtract((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static object Subtract(Int16 x, UInt16 y) {
            return Int32Ops.Subtract((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static object Multiply(UInt16 x, UInt16 y) {
            Int32 result = (Int32)(((Int32)x) * ((Int32)y));
            if (UInt16.MinValue <= result && result <= UInt16.MaxValue) {
                return (UInt16)(result);
            } else {
                return result;
            }
        }
        [SpecialName]
        public static object Multiply(UInt16 x, Int16 y) {
            return Int32Ops.Multiply((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static object Multiply(Int16 x, UInt16 y) {
            return Int32Ops.Multiply((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static object Divide(UInt16 x, UInt16 y) {
            return FloorDivide(x, y);
        }
        [SpecialName]
        public static object Divide(UInt16 x, Int16 y) {
            return Int32Ops.Divide((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static object Divide(Int16 x, UInt16 y) {
            return Int32Ops.Divide((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static double TrueDivide(UInt16 x, UInt16 y) {
            return DoubleOps.TrueDivide((double)x, (double)y);

        }
        [SpecialName]
        public static double TrueDivide(UInt16 x, Int16 y) {
            return Int32Ops.TrueDivide((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static double TrueDivide(Int16 x, UInt16 y) {
            return Int32Ops.TrueDivide((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static UInt16 FloorDivide(UInt16 x, UInt16 y) {
            return (UInt16)(x / y);
        }
        [SpecialName]
        public static object FloorDivide(UInt16 x, Int16 y) {
            return Int32Ops.FloorDivide((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static object FloorDivide(Int16 x, UInt16 y) {
            return Int32Ops.FloorDivide((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static UInt16 Mod(UInt16 x, UInt16 y) {
            return (UInt16)(x % y);
        }
        [SpecialName]
        public static Int32 Mod(UInt16 x, Int16 y) {
            return Int32Ops.Mod((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static Int32 Mod(Int16 x, UInt16 y) {
            return Int32Ops.Mod((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static object Power(UInt16 x, UInt16 y) {
            return Int32Ops.Power((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static object Power(UInt16 x, Int16 y) {
            return Int32Ops.Power((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static object Power(Int16 x, UInt16 y) {
            return Int32Ops.Power((Int32)x, (Int32)y);
        }

        // Binary Operations - Bitwise
        [SpecialName]
        public static object LeftShift(UInt16 x, [NotNull]BigInteger y) {
            return BigIntegerOps.LeftShift((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static UInt16 RightShift(UInt16 x, [NotNull]BigInteger y) {
            return (UInt16)BigIntegerOps.RightShift((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static object LeftShift(UInt16 x, Int32 y) {
            return Int32Ops.LeftShift((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static UInt16 RightShift(UInt16 x, Int32 y) {
            return (UInt16)Int32Ops.RightShift((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static UInt16 BitwiseAnd(UInt16 x, UInt16 y) {
            return (UInt16)(x & y);
        }
        [SpecialName]
        public static Int32 BitwiseAnd(UInt16 x, Int16 y) {
            return Int32Ops.BitwiseAnd((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static Int32 BitwiseAnd(Int16 x, UInt16 y) {
            return Int32Ops.BitwiseAnd((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static UInt16 BitwiseOr(UInt16 x, UInt16 y) {
            return (UInt16)(x | y);
        }
        [SpecialName]
        public static Int32 BitwiseOr(UInt16 x, Int16 y) {
            return Int32Ops.BitwiseOr((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static Int32 BitwiseOr(Int16 x, UInt16 y) {
            return Int32Ops.BitwiseOr((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static UInt16 ExclusiveOr(UInt16 x, UInt16 y) {
            return (UInt16)(x ^ y);
        }
        [SpecialName]
        public static Int32 ExclusiveOr(UInt16 x, Int16 y) {
            return Int32Ops.ExclusiveOr((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static Int32 ExclusiveOr(Int16 x, UInt16 y) {
            return Int32Ops.ExclusiveOr((Int32)x, (Int32)y);
        }

        // Binary Operations - Comparisons
        [SpecialName]
        public static int Compare(UInt16 x, UInt16 y) {
            return x == y ? 0 : x > y ? 1 : -1;
        }
        [SpecialName]
        public static int Compare(UInt16 x, Int16 y) {
            return Int32Ops.Compare((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static int Compare(Int16 x, UInt16 y) {
            return Int32Ops.Compare((Int32)x, (Int32)y);
        }

        // Conversion operators
        [SpecialName, ExplicitConversionMethod]
        public static SByte ConvertToSByte(UInt16 x) {
            if (x <= (UInt16)SByte.MaxValue) {
                return (SByte)x;
            }
            throw Converter.CannotConvertOverflow("SByte", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Byte ConvertToByte(UInt16 x) {
            if (Byte.MinValue <= x && x <= Byte.MaxValue) {
                return (Byte)x;
            }
            throw Converter.CannotConvertOverflow("Byte", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Int16 ConvertToInt16(UInt16 x) {
            if (x <= (UInt16)Int16.MaxValue) {
                return (Int16)x;
            }
            throw Converter.CannotConvertOverflow("Int16", x);
        }
        [SpecialName, ImplicitConversionMethod]
        public static Int32 ConvertToInt32(UInt16 x) {
            return (Int32)x;
        }
        [SpecialName, ImplicitConversionMethod]
        public static UInt32 ConvertToUInt32(UInt16 x) {
            return (UInt32)x;
        }
        [SpecialName, ImplicitConversionMethod]
        public static Int64 ConvertToInt64(UInt16 x) {
            return (Int64)x;
        }
        [SpecialName, ImplicitConversionMethod]
        public static UInt64 ConvertToUInt64(UInt16 x) {
            return (UInt64)x;
        }
        [SpecialName, ImplicitConversionMethod]
        public static Single ConvertToSingle(UInt16 x) {
            return (Single)x;
        }
        [SpecialName, ImplicitConversionMethod]
        public static Double ConvertToDouble(UInt16 x) {
            return (Double)x;
        }

        // Public API - Numerics
        [PropertyMethod, SpecialName]
        public static UInt16 Getreal(UInt16 x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static UInt16 Getimag(UInt16 x) {
            return (UInt16)0;
        }
        public static UInt16 conjugate(UInt16 x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static UInt16 Getnumerator(UInt16 x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static UInt16 Getdenominator(UInt16 x) {
            return (UInt16)1;
        }
        public static string __hex__(UInt16 value) {
            return BigIntegerOps.__hex__(value);
        }
        public static int bit_length(UInt16 value) {
            return MathUtils.BitLength((int)value);
        }
    }

    public static partial class Int32Ops {
        // Unary Operations
        [SpecialName]
        public static Int32 Plus(Int32 x) {
            return x;
        }
        [SpecialName]
        public static object Negate(Int32 x) {
            if (x == Int32.MinValue) return -(BigInteger)Int32.MinValue;
            else return (Int32)(-x);
        }
        [SpecialName]
        public static object Abs(Int32 x) {
            if (x < 0) {
                if (x == Int32.MinValue) return -(BigInteger)Int32.MinValue;
                else return (Int32)(-x);
            } else {
                return x;
            }
        }
        [SpecialName]
        public static Int32 OnesComplement(Int32 x) {
            return (Int32)(~(x));
        }
        public static bool __nonzero__(Int32 x) {
            return (x != 0);
        }

        public static string __repr__(Int32 x) {
            return x.ToString(CultureInfo.InvariantCulture);
        }
        public static Int32 __trunc__(Int32 x) {
            return x;
        }
        public static int __hash__(Int32 x) {
            return unchecked((int)x);
        }
        public static int __index__(Int32 x) {
            return unchecked((int)x);
        }

        // Binary Operations - Arithmetic
        [SpecialName]
        public static object Add(Int32 x, Int32 y) {
            long result = (long) x + y;
            if (Int32.MinValue <= result && result <= Int32.MaxValue) {
                return Microsoft.Scripting.Runtime.ScriptingRuntimeHelpers.Int32ToObject((Int32)(result));
            } 
            return BigIntegerOps.Add((BigInteger)x, (BigInteger)y);

        }
        [SpecialName]
        public static object Subtract(Int32 x, Int32 y) {
            long result = (long) x - y;
            if (Int32.MinValue <= result && result <= Int32.MaxValue) {
                return Microsoft.Scripting.Runtime.ScriptingRuntimeHelpers.Int32ToObject((Int32)(result));
            } 
            return BigIntegerOps.Subtract((BigInteger)x, (BigInteger)y);

        }
        [SpecialName]
        public static object Multiply(Int32 x, Int32 y) {
            long result = (long) x * y;
            if (Int32.MinValue <= result && result <= Int32.MaxValue) {
                return Microsoft.Scripting.Runtime.ScriptingRuntimeHelpers.Int32ToObject((Int32)(result));
            } 
            return BigIntegerOps.Multiply((BigInteger)x, (BigInteger)y);

        }
        [SpecialName]
        public static object Divide(Int32 x, Int32 y) {
            return FloorDivide(x, y);
        }
        [SpecialName]
        public static double TrueDivide(Int32 x, Int32 y) {
            return DoubleOps.TrueDivide((double)x, (double)y);

        }

        // Binary Operations - Bitwise
        [SpecialName]
        public static object LeftShift(Int32 x, [NotNull]BigInteger y) {
            return BigIntegerOps.LeftShift((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static Int32 RightShift(Int32 x, [NotNull]BigInteger y) {
            return (Int32)BigIntegerOps.RightShift((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static Int32 BitwiseAnd(Int32 x, Int32 y) {
            return (Int32)(x & y);
        }
        [SpecialName]
        public static Int32 BitwiseOr(Int32 x, Int32 y) {
            return (Int32)(x | y);
        }
        [SpecialName]
        public static Int32 ExclusiveOr(Int32 x, Int32 y) {
            return (Int32)(x ^ y);
        }

        // Binary Operations - Comparisons
        [SpecialName]
        public static int Compare(Int32 x, Int32 y) {
            return x == y ? 0 : x > y ? 1 : -1;
        }

        // Conversion operators
        [SpecialName, ExplicitConversionMethod]
        public static SByte ConvertToSByte(Int32 x) {
            if (SByte.MinValue <= x && x <= SByte.MaxValue) {
                return (SByte)x;
            }
            throw Converter.CannotConvertOverflow("SByte", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Byte ConvertToByte(Int32 x) {
            if (Byte.MinValue <= x && x <= Byte.MaxValue) {
                return (Byte)x;
            }
            throw Converter.CannotConvertOverflow("Byte", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Int16 ConvertToInt16(Int32 x) {
            if (Int16.MinValue <= x && x <= Int16.MaxValue) {
                return (Int16)x;
            }
            throw Converter.CannotConvertOverflow("Int16", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt16 ConvertToUInt16(Int32 x) {
            if (UInt16.MinValue <= x && x <= UInt16.MaxValue) {
                return (UInt16)x;
            }
            throw Converter.CannotConvertOverflow("UInt16", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt32 ConvertToUInt32(Int32 x) {
            if (x >= 0) {
                return (UInt32)x;
            }
            throw Converter.CannotConvertOverflow("UInt32", x);
        }
        [SpecialName, ImplicitConversionMethod]
        public static Int64 ConvertToInt64(Int32 x) {
            return (Int64)x;
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt64 ConvertToUInt64(Int32 x) {
            if (x >= 0) {
                return (UInt64)x;
            }
            throw Converter.CannotConvertOverflow("UInt64", x);
        }
        [SpecialName, ImplicitConversionMethod]
        public static Single ConvertToSingle(Int32 x) {
            return (Single)x;
        }
        [SpecialName, ImplicitConversionMethod]
        public static Double ConvertToDouble(Int32 x) {
            return (Double)x;
        }

        // Public API - Numerics
        [PropertyMethod, SpecialName]
        public static Int32 Getreal(Int32 x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static Int32 Getimag(Int32 x) {
            return (Int32)0;
        }
        public static Int32 conjugate(Int32 x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static Int32 Getnumerator(Int32 x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static Int32 Getdenominator(Int32 x) {
            return (Int32)1;
        }
        public static int bit_length(Int32 value) {
            return MathUtils.BitLength(value);
        }
    }

    public static partial class UInt32Ops {
        [StaticExtensionMethod]
        public static object __new__(PythonType cls) {
            return __new__(cls, default(UInt32));
        }

        [StaticExtensionMethod]
        public static object __new__(PythonType cls, object value) {
            if (cls != DynamicHelpers.GetPythonTypeFromType(typeof(UInt32))) {
                throw PythonOps.TypeError("UInt32.__new__: first argument must be UInt32 type.");
            }
            IConvertible valueConvertible;
            if ((valueConvertible = value as IConvertible) != null) {
                switch (valueConvertible.GetTypeCode()) {
                    case TypeCode.Byte: return (UInt32)(Byte)value;
                    case TypeCode.SByte: return (UInt32)(SByte)value;
                    case TypeCode.Int16: return (UInt32)(Int16)value;
                    case TypeCode.UInt16: return (UInt32)(UInt16)value;
                    case TypeCode.Int32: return (UInt32)(Int32)value;
                    case TypeCode.UInt32: return (UInt32)(UInt32)value;
                    case TypeCode.Int64: return (UInt32)(Int64)value;
                    case TypeCode.UInt64: return (UInt32)(UInt64)value;
                    case TypeCode.Single: return (UInt32)(Single)value;
                    case TypeCode.Double: return (UInt32)(Double)value;
                }
            }
            if (value is String) {
                return UInt32.Parse((String)value);
            } else if (value is BigInteger) {
                return (UInt32)(BigInteger)value;
            } else if (value is Extensible<BigInteger>) {
                return (UInt32)((Extensible<BigInteger>)value).Value;
            } else if (value is Extensible<double>) {
                return (UInt32)((Extensible<double>)value).Value;
            }
            throw PythonOps.ValueError("invalid value for UInt32.__new__");
        }
        // Unary Operations
        [SpecialName]
        public static UInt32 Plus(UInt32 x) {
            return x;
        }
        [SpecialName]
        public static object Negate(UInt32 x) {
            return Int64Ops.Negate((Int64)x);
        }
        [SpecialName]
        public static UInt32 Abs(UInt32 x) {
            return x;
        }
        [SpecialName]
        public static object OnesComplement(UInt32 x) {
            return Int64Ops.OnesComplement((Int64)x);
        }
        public static bool __nonzero__(UInt32 x) {
            return (x != 0);
        }

        public static string __repr__(UInt32 x) {
            return x.ToString(CultureInfo.InvariantCulture);
        }
        public static UInt32 __trunc__(UInt32 x) {
            return x;
        }
        public static int __hash__(UInt32 x) {
            return unchecked((int)x);
        }
        public static int __index__(UInt32 x) {
            return unchecked((int)x);
        }

        // Binary Operations - Arithmetic
        [SpecialName]
        public static object Add(UInt32 x, UInt32 y) {
            Int64 result = (Int64)(((Int64)x) + ((Int64)y));
            if (UInt32.MinValue <= result && result <= UInt32.MaxValue) {
                return (UInt32)(result);
            } else {
                return result;
            }
        }
        [SpecialName]
        public static object Add(UInt32 x, Int32 y) {
            return Int64Ops.Add((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static object Add(Int32 x, UInt32 y) {
            return Int64Ops.Add((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static object Subtract(UInt32 x, UInt32 y) {
            Int64 result = (Int64)(((Int64)x) - ((Int64)y));
            if (UInt32.MinValue <= result && result <= UInt32.MaxValue) {
                return (UInt32)(result);
            } else {
                return result;
            }
        }
        [SpecialName]
        public static object Subtract(UInt32 x, Int32 y) {
            return Int64Ops.Subtract((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static object Subtract(Int32 x, UInt32 y) {
            return Int64Ops.Subtract((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static object Multiply(UInt32 x, UInt32 y) {
            Int64 result = (Int64)(((Int64)x) * ((Int64)y));
            if (UInt32.MinValue <= result && result <= UInt32.MaxValue) {
                return (UInt32)(result);
            } else {
                return result;
            }
        }
        [SpecialName]
        public static object Multiply(UInt32 x, Int32 y) {
            return Int64Ops.Multiply((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static object Multiply(Int32 x, UInt32 y) {
            return Int64Ops.Multiply((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static object Divide(UInt32 x, UInt32 y) {
            return FloorDivide(x, y);
        }
        [SpecialName]
        public static object Divide(UInt32 x, Int32 y) {
            return Int64Ops.Divide((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static object Divide(Int32 x, UInt32 y) {
            return Int64Ops.Divide((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static double TrueDivide(UInt32 x, UInt32 y) {
            return DoubleOps.TrueDivide((double)x, (double)y);

        }
        [SpecialName]
        public static double TrueDivide(UInt32 x, Int32 y) {
            return Int64Ops.TrueDivide((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static double TrueDivide(Int32 x, UInt32 y) {
            return Int64Ops.TrueDivide((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static UInt32 FloorDivide(UInt32 x, UInt32 y) {
            return (UInt32)(x / y);
        }
        [SpecialName]
        public static object FloorDivide(UInt32 x, Int32 y) {
            return Int64Ops.FloorDivide((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static object FloorDivide(Int32 x, UInt32 y) {
            return Int64Ops.FloorDivide((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static UInt32 Mod(UInt32 x, UInt32 y) {
            return (UInt32)(x % y);
        }
        [SpecialName]
        public static Int64 Mod(UInt32 x, Int32 y) {
            return Int64Ops.Mod((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static Int64 Mod(Int32 x, UInt32 y) {
            return Int64Ops.Mod((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static object Power(UInt32 x, UInt32 y) {
            return Int32Ops.Power((Int32)x, (Int32)y);
        }
        [SpecialName]
        public static object Power(UInt32 x, Int32 y) {
            return Int64Ops.Power((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static object Power(Int32 x, UInt32 y) {
            return Int64Ops.Power((Int64)x, (Int64)y);
        }

        // Binary Operations - Bitwise
        [SpecialName]
        public static object LeftShift(UInt32 x, [NotNull]BigInteger y) {
            return BigIntegerOps.LeftShift((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static UInt32 RightShift(UInt32 x, [NotNull]BigInteger y) {
            return (UInt32)BigIntegerOps.RightShift((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static UInt32 BitwiseAnd(UInt32 x, UInt32 y) {
            return (UInt32)(x & y);
        }
        [SpecialName]
        public static Int64 BitwiseAnd(UInt32 x, Int32 y) {
            return Int64Ops.BitwiseAnd((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static Int64 BitwiseAnd(Int32 x, UInt32 y) {
            return Int64Ops.BitwiseAnd((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static UInt32 BitwiseOr(UInt32 x, UInt32 y) {
            return (UInt32)(x | y);
        }
        [SpecialName]
        public static Int64 BitwiseOr(UInt32 x, Int32 y) {
            return Int64Ops.BitwiseOr((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static Int64 BitwiseOr(Int32 x, UInt32 y) {
            return Int64Ops.BitwiseOr((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static UInt32 ExclusiveOr(UInt32 x, UInt32 y) {
            return (UInt32)(x ^ y);
        }
        [SpecialName]
        public static Int64 ExclusiveOr(UInt32 x, Int32 y) {
            return Int64Ops.ExclusiveOr((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static Int64 ExclusiveOr(Int32 x, UInt32 y) {
            return Int64Ops.ExclusiveOr((Int64)x, (Int64)y);
        }

        // Binary Operations - Comparisons
        [SpecialName]
        public static int Compare(UInt32 x, UInt32 y) {
            return x == y ? 0 : x > y ? 1 : -1;
        }
        [SpecialName]
        public static int Compare(UInt32 x, Int32 y) {
            return Int64Ops.Compare((Int64)x, (Int64)y);
        }
        [SpecialName]
        public static int Compare(Int32 x, UInt32 y) {
            return Int64Ops.Compare((Int64)x, (Int64)y);
        }

        // Conversion operators
        [SpecialName, ExplicitConversionMethod]
        public static SByte ConvertToSByte(UInt32 x) {
            if (x <= (UInt32)SByte.MaxValue) {
                return (SByte)x;
            }
            throw Converter.CannotConvertOverflow("SByte", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Byte ConvertToByte(UInt32 x) {
            if (Byte.MinValue <= x && x <= Byte.MaxValue) {
                return (Byte)x;
            }
            throw Converter.CannotConvertOverflow("Byte", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Int16 ConvertToInt16(UInt32 x) {
            if (x <= (UInt32)Int16.MaxValue) {
                return (Int16)x;
            }
            throw Converter.CannotConvertOverflow("Int16", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt16 ConvertToUInt16(UInt32 x) {
            if (UInt16.MinValue <= x && x <= UInt16.MaxValue) {
                return (UInt16)x;
            }
            throw Converter.CannotConvertOverflow("UInt16", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Int32 ConvertToInt32(UInt32 x) {
            if (x <= (UInt32)Int32.MaxValue) {
                return (Int32)x;
            }
            throw Converter.CannotConvertOverflow("Int32", x);
        }
        [SpecialName, ImplicitConversionMethod]
        public static Int64 ConvertToInt64(UInt32 x) {
            return (Int64)x;
        }
        [SpecialName, ImplicitConversionMethod]
        public static UInt64 ConvertToUInt64(UInt32 x) {
            return (UInt64)x;
        }
        [SpecialName, ImplicitConversionMethod]
        public static Single ConvertToSingle(UInt32 x) {
            return (Single)x;
        }
        [SpecialName, ImplicitConversionMethod]
        public static Double ConvertToDouble(UInt32 x) {
            return (Double)x;
        }

        // Public API - Numerics
        [PropertyMethod, SpecialName]
        public static UInt32 Getreal(UInt32 x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static UInt32 Getimag(UInt32 x) {
            return (UInt32)0;
        }
        public static UInt32 conjugate(UInt32 x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static UInt32 Getnumerator(UInt32 x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static UInt32 Getdenominator(UInt32 x) {
            return (UInt32)1;
        }
        public static string __hex__(UInt32 value) {
            return BigIntegerOps.__hex__(value);
        }
        public static int bit_length(UInt32 value) {
            return MathUtils.BitLengthUnsigned(value);
        }
    }

    public static partial class Int64Ops {
        [StaticExtensionMethod]
        public static object __new__(PythonType cls) {
            return __new__(cls, default(Int64));
        }

        [StaticExtensionMethod]
        public static object __new__(PythonType cls, object value) {
            if (cls != DynamicHelpers.GetPythonTypeFromType(typeof(Int64))) {
                throw PythonOps.TypeError("Int64.__new__: first argument must be Int64 type.");
            }
            IConvertible valueConvertible;
            if ((valueConvertible = value as IConvertible) != null) {
                switch (valueConvertible.GetTypeCode()) {
                    case TypeCode.Byte: return (Int64)(Byte)value;
                    case TypeCode.SByte: return (Int64)(SByte)value;
                    case TypeCode.Int16: return (Int64)(Int16)value;
                    case TypeCode.UInt16: return (Int64)(UInt16)value;
                    case TypeCode.Int32: return (Int64)(Int32)value;
                    case TypeCode.UInt32: return (Int64)(UInt32)value;
                    case TypeCode.Int64: return (Int64)(Int64)value;
                    case TypeCode.UInt64: return (Int64)(UInt64)value;
                    case TypeCode.Single: return (Int64)(Single)value;
                    case TypeCode.Double: return (Int64)(Double)value;
                }
            }
            if (value is String) {
                return Int64.Parse((String)value);
            } else if (value is BigInteger) {
                return (Int64)(BigInteger)value;
            } else if (value is Extensible<BigInteger>) {
                return (Int64)((Extensible<BigInteger>)value).Value;
            } else if (value is Extensible<double>) {
                return (Int64)((Extensible<double>)value).Value;
            }
            throw PythonOps.ValueError("invalid value for Int64.__new__");
        }
        // Unary Operations
        [SpecialName]
        public static Int64 Plus(Int64 x) {
            return x;
        }
        [SpecialName]
        public static object Negate(Int64 x) {
            if (x == Int64.MinValue) return -(BigInteger)Int64.MinValue;
            else return (Int64)(-x);
        }
        [SpecialName]
        public static object Abs(Int64 x) {
            if (x < 0) {
                if (x == Int64.MinValue) return -(BigInteger)Int64.MinValue;
                else return (Int64)(-x);
            } else {
                return x;
            }
        }
        [SpecialName]
        public static Int64 OnesComplement(Int64 x) {
            return (Int64)(~(x));
        }
        public static bool __nonzero__(Int64 x) {
            return (x != 0);
        }

        public static string __repr__(Int64 x) {
            return x.ToString(CultureInfo.InvariantCulture);
        }
        public static Int64 __trunc__(Int64 x) {
            return x;
        }
        public static int __hash__(Int64 x) {
            Int64 tmp = x;
            if (tmp < 0) {
                tmp *= -1;
            }
            int total = unchecked((int) (((uint)tmp) + (uint)(tmp >> 32)));
            if (x < 0) {
                return unchecked(-total);
            }
            return total;
        }

        public static BigInteger __index__(Int64 x) {
            return unchecked((BigInteger)x);
        }

        // Binary Operations - Arithmetic
        [SpecialName]
        public static object Add(Int64 x, Int64 y) {
            try {
                return (Int64)(checked(x + y));
            } catch (OverflowException) {
                return BigIntegerOps.Add((BigInteger)x, (BigInteger)y);
            }
        }
        [SpecialName]
        public static object Subtract(Int64 x, Int64 y) {
            try {
                return (Int64)(checked(x - y));
            } catch (OverflowException) {
                return BigIntegerOps.Subtract((BigInteger)x, (BigInteger)y);
            }
        }
        [SpecialName]
        public static object Multiply(Int64 x, Int64 y) {
            try {
                return (Int64)(checked(x * y));
            } catch (OverflowException) {
                return BigIntegerOps.Multiply((BigInteger)x, (BigInteger)y);
            }
        }
        [SpecialName]
        public static object Divide(Int64 x, Int64 y) {
            return FloorDivide(x, y);
        }
        [SpecialName]
        public static double TrueDivide(Int64 x, Int64 y) {
            return DoubleOps.TrueDivide((double)x, (double)y);

        }
        [SpecialName]
        public static object FloorDivide(Int64 x, Int64 y) {
            if (y == -1 && x == Int64.MinValue) {
                return -(BigInteger)Int64.MinValue;
            } else {
                return (Int64)MathUtils.FloorDivideUnchecked(x, y);
            }
        }
        [SpecialName]
        public static Int64 Mod(Int64 x, Int64 y) {
            return (Int64)BigIntegerOps.Mod((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static object Power(Int64 x, Int64 y) {
            return BigIntegerOps.Power((BigInteger)x, (BigInteger)y);
        }

        // Binary Operations - Bitwise
        [SpecialName]
        public static object LeftShift(Int64 x, [NotNull]BigInteger y) {
            return BigIntegerOps.LeftShift((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static Int64 RightShift(Int64 x, [NotNull]BigInteger y) {
            return (Int64)BigIntegerOps.RightShift((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static Int64 BitwiseAnd(Int64 x, Int64 y) {
            return (Int64)(x & y);
        }
        [SpecialName]
        public static Int64 BitwiseOr(Int64 x, Int64 y) {
            return (Int64)(x | y);
        }
        [SpecialName]
        public static Int64 ExclusiveOr(Int64 x, Int64 y) {
            return (Int64)(x ^ y);
        }

        // Binary Operations - Comparisons
        [SpecialName]
        public static int Compare(Int64 x, Int64 y) {
            return x == y ? 0 : x > y ? 1 : -1;
        }

        // Conversion operators
        [SpecialName, ExplicitConversionMethod]
        public static SByte ConvertToSByte(Int64 x) {
            if (SByte.MinValue <= x && x <= SByte.MaxValue) {
                return (SByte)x;
            }
            throw Converter.CannotConvertOverflow("SByte", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Byte ConvertToByte(Int64 x) {
            if (Byte.MinValue <= x && x <= Byte.MaxValue) {
                return (Byte)x;
            }
            throw Converter.CannotConvertOverflow("Byte", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Int16 ConvertToInt16(Int64 x) {
            if (Int16.MinValue <= x && x <= Int16.MaxValue) {
                return (Int16)x;
            }
            throw Converter.CannotConvertOverflow("Int16", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt16 ConvertToUInt16(Int64 x) {
            if (UInt16.MinValue <= x && x <= UInt16.MaxValue) {
                return (UInt16)x;
            }
            throw Converter.CannotConvertOverflow("UInt16", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Int32 ConvertToInt32(Int64 x) {
            if (Int32.MinValue <= x && x <= Int32.MaxValue) {
                return (Int32)x;
            }
            throw Converter.CannotConvertOverflow("Int32", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt32 ConvertToUInt32(Int64 x) {
            if (UInt32.MinValue <= x && x <= UInt32.MaxValue) {
                return (UInt32)x;
            }
            throw Converter.CannotConvertOverflow("UInt32", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt64 ConvertToUInt64(Int64 x) {
            if (x >= 0) {
                return (UInt64)x;
            }
            throw Converter.CannotConvertOverflow("UInt64", x);
        }
        [SpecialName, ImplicitConversionMethod]
        public static Single ConvertToSingle(Int64 x) {
            return (Single)x;
        }
        [SpecialName, ImplicitConversionMethod]
        public static Double ConvertToDouble(Int64 x) {
            return (Double)x;
        }

        // Public API - Numerics
        [PropertyMethod, SpecialName]
        public static Int64 Getreal(Int64 x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static Int64 Getimag(Int64 x) {
            return (Int64)0;
        }
        public static Int64 conjugate(Int64 x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static Int64 Getnumerator(Int64 x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static Int64 Getdenominator(Int64 x) {
            return (Int64)1;
        }
        public static string __hex__(Int64 value) {
            return BigIntegerOps.__hex__(value);
        }
        public static int bit_length(Int64 value) {
            return MathUtils.BitLength(value);
        }
    }

    public static partial class UInt64Ops {
        [StaticExtensionMethod]
        public static object __new__(PythonType cls) {
            return __new__(cls, default(UInt64));
        }

        [StaticExtensionMethod]
        public static object __new__(PythonType cls, object value) {
            if (cls != DynamicHelpers.GetPythonTypeFromType(typeof(UInt64))) {
                throw PythonOps.TypeError("UInt64.__new__: first argument must be UInt64 type.");
            }
            IConvertible valueConvertible;
            if ((valueConvertible = value as IConvertible) != null) {
                switch (valueConvertible.GetTypeCode()) {
                    case TypeCode.Byte: return (UInt64)(Byte)value;
                    case TypeCode.SByte: return (UInt64)(SByte)value;
                    case TypeCode.Int16: return (UInt64)(Int16)value;
                    case TypeCode.UInt16: return (UInt64)(UInt16)value;
                    case TypeCode.Int32: return (UInt64)(Int32)value;
                    case TypeCode.UInt32: return (UInt64)(UInt32)value;
                    case TypeCode.Int64: return (UInt64)(Int64)value;
                    case TypeCode.UInt64: return (UInt64)(UInt64)value;
                    case TypeCode.Single: return (UInt64)(Single)value;
                    case TypeCode.Double: return (UInt64)(Double)value;
                }
            }
            if (value is String) {
                return UInt64.Parse((String)value);
            } else if (value is BigInteger) {
                return (UInt64)(BigInteger)value;
            } else if (value is Extensible<BigInteger>) {
                return (UInt64)((Extensible<BigInteger>)value).Value;
            } else if (value is Extensible<double>) {
                return (UInt64)((Extensible<double>)value).Value;
            }
            throw PythonOps.ValueError("invalid value for UInt64.__new__");
        }
        // Unary Operations
        [SpecialName]
        public static UInt64 Plus(UInt64 x) {
            return x;
        }
        [SpecialName]
        public static object Negate(UInt64 x) {
            return BigIntegerOps.Negate((BigInteger)x);
        }
        [SpecialName]
        public static UInt64 Abs(UInt64 x) {
            return x;
        }
        [SpecialName]
        public static object OnesComplement(UInt64 x) {
            return BigIntegerOps.OnesComplement((BigInteger)x);
        }
        public static bool __nonzero__(UInt64 x) {
            return (x != 0);
        }

        public static string __repr__(UInt64 x) {
            return x.ToString(CultureInfo.InvariantCulture);
        }
        public static UInt64 __trunc__(UInt64 x) {
            return x;
        }
        public static int __hash__(UInt64 x) {
            int total = unchecked((int) (((uint)x) + (uint)(x >> 32)));
            if (x < 0) {
                return unchecked(-total);
            }
            return total;
        }

        public static BigInteger __index__(UInt64 x) {
            return unchecked((BigInteger)x);
        }

        // Binary Operations - Arithmetic
        [SpecialName]
        public static object Add(UInt64 x, UInt64 y) {
            try {
                return (UInt64)(checked(x + y));
            } catch (OverflowException) {
                return BigIntegerOps.Add((BigInteger)x, (BigInteger)y);
            }
        }
        [SpecialName]
        public static object Add(UInt64 x, Int64 y) {
            return BigIntegerOps.Add((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static object Add(Int64 x, UInt64 y) {
            return BigIntegerOps.Add((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static object Subtract(UInt64 x, UInt64 y) {
            try {
                return (UInt64)(checked(x - y));
            } catch (OverflowException) {
                return BigIntegerOps.Subtract((BigInteger)x, (BigInteger)y);
            }
        }
        [SpecialName]
        public static object Subtract(UInt64 x, Int64 y) {
            return BigIntegerOps.Subtract((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static object Subtract(Int64 x, UInt64 y) {
            return BigIntegerOps.Subtract((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static object Multiply(UInt64 x, UInt64 y) {
            try {
                return (UInt64)(checked(x * y));
            } catch (OverflowException) {
                return BigIntegerOps.Multiply((BigInteger)x, (BigInteger)y);
            }
        }
        [SpecialName]
        public static object Multiply(UInt64 x, Int64 y) {
            return BigIntegerOps.Multiply((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static object Multiply(Int64 x, UInt64 y) {
            return BigIntegerOps.Multiply((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static object Divide(UInt64 x, UInt64 y) {
            return FloorDivide(x, y);
        }
        [SpecialName]
        public static object Divide(UInt64 x, Int64 y) {
            return BigIntegerOps.Divide((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static object Divide(Int64 x, UInt64 y) {
            return BigIntegerOps.Divide((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static double TrueDivide(UInt64 x, UInt64 y) {
            return DoubleOps.TrueDivide((double)x, (double)y);

        }
        [SpecialName]
        public static double TrueDivide(UInt64 x, Int64 y) {
            return BigIntegerOps.TrueDivide((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static double TrueDivide(Int64 x, UInt64 y) {
            return BigIntegerOps.TrueDivide((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static UInt64 FloorDivide(UInt64 x, UInt64 y) {
            return (UInt64)(x / y);
        }
        [SpecialName]
        public static object FloorDivide(UInt64 x, Int64 y) {
            return BigIntegerOps.FloorDivide((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static object FloorDivide(Int64 x, UInt64 y) {
            return BigIntegerOps.FloorDivide((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static UInt64 Mod(UInt64 x, UInt64 y) {
            return (UInt64)(x % y);
        }
        [SpecialName]
        public static BigInteger Mod(UInt64 x, Int64 y) {
            return BigIntegerOps.Mod((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static BigInteger Mod(Int64 x, UInt64 y) {
            return BigIntegerOps.Mod((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static object Power(UInt64 x, UInt64 y) {
            return BigIntegerOps.Power((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static object Power(UInt64 x, Int64 y) {
            return BigIntegerOps.Power((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static object Power(Int64 x, UInt64 y) {
            return BigIntegerOps.Power((BigInteger)x, (BigInteger)y);
        }

        // Binary Operations - Bitwise
        [SpecialName]
        public static object LeftShift(UInt64 x, [NotNull]BigInteger y) {
            return BigIntegerOps.LeftShift((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static UInt64 RightShift(UInt64 x, [NotNull]BigInteger y) {
            return (UInt64)BigIntegerOps.RightShift((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static UInt64 BitwiseAnd(UInt64 x, UInt64 y) {
            return (UInt64)(x & y);
        }
        [SpecialName]
        public static BigInteger BitwiseAnd(UInt64 x, Int64 y) {
            return BigIntegerOps.BitwiseAnd((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static BigInteger BitwiseAnd(Int64 x, UInt64 y) {
            return BigIntegerOps.BitwiseAnd((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static UInt64 BitwiseOr(UInt64 x, UInt64 y) {
            return (UInt64)(x | y);
        }
        [SpecialName]
        public static BigInteger BitwiseOr(UInt64 x, Int64 y) {
            return BigIntegerOps.BitwiseOr((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static BigInteger BitwiseOr(Int64 x, UInt64 y) {
            return BigIntegerOps.BitwiseOr((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static UInt64 ExclusiveOr(UInt64 x, UInt64 y) {
            return (UInt64)(x ^ y);
        }
        [SpecialName]
        public static BigInteger ExclusiveOr(UInt64 x, Int64 y) {
            return BigIntegerOps.ExclusiveOr((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static BigInteger ExclusiveOr(Int64 x, UInt64 y) {
            return BigIntegerOps.ExclusiveOr((BigInteger)x, (BigInteger)y);
        }

        // Binary Operations - Comparisons
        [SpecialName]
        public static int Compare(UInt64 x, UInt64 y) {
            return x == y ? 0 : x > y ? 1 : -1;
        }
        [SpecialName]
        public static int Compare(UInt64 x, Int64 y) {
            return BigIntegerOps.Compare((BigInteger)x, (BigInteger)y);
        }
        [SpecialName]
        public static int Compare(Int64 x, UInt64 y) {
            return BigIntegerOps.Compare((BigInteger)x, (BigInteger)y);
        }

        // Conversion operators
        [SpecialName, ExplicitConversionMethod]
        public static SByte ConvertToSByte(UInt64 x) {
            if (x <= (UInt64)SByte.MaxValue) {
                return (SByte)x;
            }
            throw Converter.CannotConvertOverflow("SByte", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Byte ConvertToByte(UInt64 x) {
            if (Byte.MinValue <= x && x <= Byte.MaxValue) {
                return (Byte)x;
            }
            throw Converter.CannotConvertOverflow("Byte", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Int16 ConvertToInt16(UInt64 x) {
            if (x <= (UInt64)Int16.MaxValue) {
                return (Int16)x;
            }
            throw Converter.CannotConvertOverflow("Int16", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt16 ConvertToUInt16(UInt64 x) {
            if (UInt16.MinValue <= x && x <= UInt16.MaxValue) {
                return (UInt16)x;
            }
            throw Converter.CannotConvertOverflow("UInt16", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Int32 ConvertToInt32(UInt64 x) {
            if (x <= (UInt64)Int32.MaxValue) {
                return (Int32)x;
            }
            throw Converter.CannotConvertOverflow("Int32", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt32 ConvertToUInt32(UInt64 x) {
            if (UInt32.MinValue <= x && x <= UInt32.MaxValue) {
                return (UInt32)x;
            }
            throw Converter.CannotConvertOverflow("UInt32", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Int64 ConvertToInt64(UInt64 x) {
            if (x <= (UInt64)Int64.MaxValue) {
                return (Int64)x;
            }
            throw Converter.CannotConvertOverflow("Int64", x);
        }
        [SpecialName, ImplicitConversionMethod]
        public static Single ConvertToSingle(UInt64 x) {
            return (Single)x;
        }
        [SpecialName, ImplicitConversionMethod]
        public static Double ConvertToDouble(UInt64 x) {
            return (Double)x;
        }

        // Public API - Numerics
        [PropertyMethod, SpecialName]
        public static UInt64 Getreal(UInt64 x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static UInt64 Getimag(UInt64 x) {
            return (UInt64)0;
        }
        public static UInt64 conjugate(UInt64 x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static UInt64 Getnumerator(UInt64 x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static UInt64 Getdenominator(UInt64 x) {
            return (UInt64)1;
        }
        public static string __hex__(UInt64 value) {
            return BigIntegerOps.__hex__(value);
        }
        public static int bit_length(UInt64 value) {
            return MathUtils.BitLengthUnsigned(value);
        }
    }

    public static partial class SingleOps {
        // Unary Operations
        [SpecialName]
        public static Single Plus(Single x) {
            return x;
        }
        [SpecialName]
        public static Single Negate(Single x) {
            return (Single)(-(x));
        }
        [SpecialName]
        public static Single Abs(Single x) {
            return (Single)(Math.Abs(x));
        }
        public static bool __nonzero__(Single x) {
            return (x != 0);
        }

        public static object __trunc__(Single x) {
            if (x >= int.MaxValue || x <= int.MinValue) {
                return (BigInteger)x;
            } else {
                return (int)x;
            }
        }

        // Binary Operations - Arithmetic
        [SpecialName]
        public static Single Add(Single x, Single y) {
            return x + y;
        }
        [SpecialName]
        public static Single Subtract(Single x, Single y) {
            return x - y;
        }
        [SpecialName]
        public static Single Multiply(Single x, Single y) {
            return x * y;
        }
        [SpecialName]
        public static Single Divide(Single x, Single y) {
            return TrueDivide(x, y);
        }
        [SpecialName]
        public static Single TrueDivide(Single x, Single y) {
            if (y == 0) throw PythonOps.ZeroDivisionError();
            return x / y;

        }
        [SpecialName]
        public static Single FloorDivide(Single x, Single y) {
            if (y == 0) throw PythonOps.ZeroDivisionError();
            return (Single)Math.Floor(x / y);

        }

        // Conversion operators
        [SpecialName, ExplicitConversionMethod]
        public static SByte ConvertToSByte(Single x) {
            if (SByte.MinValue <= x && x <= SByte.MaxValue) {
                return (SByte)x;
            }
            throw Converter.CannotConvertOverflow("SByte", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Byte ConvertToByte(Single x) {
            if (Byte.MinValue <= x && x <= Byte.MaxValue) {
                return (Byte)x;
            }
            throw Converter.CannotConvertOverflow("Byte", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Int16 ConvertToInt16(Single x) {
            if (Int16.MinValue <= x && x <= Int16.MaxValue) {
                return (Int16)x;
            }
            throw Converter.CannotConvertOverflow("Int16", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt16 ConvertToUInt16(Single x) {
            if (UInt16.MinValue <= x && x <= UInt16.MaxValue) {
                return (UInt16)x;
            }
            throw Converter.CannotConvertOverflow("UInt16", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Int32 ConvertToInt32(Single x) {
            if (Int32.MinValue <= x && x <= Int32.MaxValue) {
                return (Int32)x;
            }
            throw Converter.CannotConvertOverflow("Int32", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt32 ConvertToUInt32(Single x) {
            if (UInt32.MinValue <= x && x <= UInt32.MaxValue) {
                return (UInt32)x;
            }
            throw Converter.CannotConvertOverflow("UInt32", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Int64 ConvertToInt64(Single x) {
            if (Int64.MinValue <= x && x <= Int64.MaxValue) {
                return (Int64)x;
            }
            throw Converter.CannotConvertOverflow("Int64", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt64 ConvertToUInt64(Single x) {
            if (UInt64.MinValue <= x && x <= UInt64.MaxValue) {
                return (UInt64)x;
            }
            throw Converter.CannotConvertOverflow("UInt64", x);
        }
        [SpecialName, ImplicitConversionMethod]
        public static Double ConvertToDouble(Single x) {
            return (Double)x;
        }

        // Public API - Numerics
        [PropertyMethod, SpecialName]
        public static Single Getreal(Single x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static Single Getimag(Single x) {
            return (Single)0;
        }
        public static Single conjugate(Single x) {
            return x;
        }
    }

    public static partial class DoubleOps {
        // Unary Operations
        [SpecialName]
        public static Double Plus(Double x) {
            return x;
        }
        [SpecialName]
        public static Double Negate(Double x) {
            return (Double)(-(x));
        }
        [SpecialName]
        public static Double Abs(Double x) {
            return (Double)(Math.Abs(x));
        }
        public static bool __nonzero__(Double x) {
            return (x != 0);
        }

        public static object __trunc__(Double x) {
            if (x >= int.MaxValue || x <= int.MinValue) {
                return (BigInteger)x;
            } else {
                return (int)x;
            }
        }

        // Binary Operations - Arithmetic
        [SpecialName]
        public static Double Add(Double x, Double y) {
            return x + y;
        }
        [SpecialName]
        public static Double Subtract(Double x, Double y) {
            return x - y;
        }
        [SpecialName]
        public static Double Multiply(Double x, Double y) {
            return x * y;
        }
        [SpecialName]
        public static Double Divide(Double x, Double y) {
            return TrueDivide(x, y);
        }
        [SpecialName]
        public static Double TrueDivide(Double x, Double y) {
            if (y == 0) throw PythonOps.ZeroDivisionError();
            return x / y;

        }
        [SpecialName]
        public static Double FloorDivide(Double x, Double y) {
            if (y == 0) throw PythonOps.ZeroDivisionError();
            return (Double)Math.Floor(x / y);

        }

        // Conversion operators
        [SpecialName, ExplicitConversionMethod]
        public static SByte ConvertToSByte(Double x) {
            if (SByte.MinValue <= x && x <= SByte.MaxValue) {
                return (SByte)x;
            }
            throw Converter.CannotConvertOverflow("SByte", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Byte ConvertToByte(Double x) {
            if (Byte.MinValue <= x && x <= Byte.MaxValue) {
                return (Byte)x;
            }
            throw Converter.CannotConvertOverflow("Byte", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Int16 ConvertToInt16(Double x) {
            if (Int16.MinValue <= x && x <= Int16.MaxValue) {
                return (Int16)x;
            }
            throw Converter.CannotConvertOverflow("Int16", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt16 ConvertToUInt16(Double x) {
            if (UInt16.MinValue <= x && x <= UInt16.MaxValue) {
                return (UInt16)x;
            }
            throw Converter.CannotConvertOverflow("UInt16", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Int32 ConvertToInt32(Double x) {
            if (Int32.MinValue <= x && x <= Int32.MaxValue) {
                return (Int32)x;
            }
            throw Converter.CannotConvertOverflow("Int32", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt32 ConvertToUInt32(Double x) {
            if (UInt32.MinValue <= x && x <= UInt32.MaxValue) {
                return (UInt32)x;
            }
            throw Converter.CannotConvertOverflow("UInt32", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static Int64 ConvertToInt64(Double x) {
            if (Int64.MinValue <= x && x <= Int64.MaxValue) {
                return (Int64)x;
            }
            throw Converter.CannotConvertOverflow("Int64", x);
        }
        [SpecialName, ExplicitConversionMethod]
        public static UInt64 ConvertToUInt64(Double x) {
            if (UInt64.MinValue <= x && x <= UInt64.MaxValue) {
                return (UInt64)x;
            }
            throw Converter.CannotConvertOverflow("UInt64", x);
        }
        [SpecialName, ImplicitConversionMethod]
        public static Single ConvertToSingle(Double x) {
            return (Single)x;
        }

        // Public API - Numerics
        [PropertyMethod, SpecialName]
        public static Double Getreal(Double x) {
            return x;
        }
        [PropertyMethod, SpecialName]
        public static Double Getimag(Double x) {
            return (Double)0;
        }
        public static Double conjugate(Double x) {
            return x;
        }
    }


    // *** END GENERATED CODE ***

    #endregion
}
