// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.IO;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading;

using Microsoft.Scripting;
using Microsoft.Scripting.Runtime;

using IronPython.Runtime.Operations;
using IronPython.Runtime.Types;
using Microsoft.Scripting.Utils;

// This generated code is updated by the generate_exceptions.py script.
namespace IronPython.Runtime.Exceptions {
    public static partial class PythonExceptions {

        #region Generated Python New-Style Exceptions

        // *** BEGIN GENERATED CODE ***
        // generated by function: newstyle_gen from: generate_exceptions.py

        [MultiRuntimeAware]
        private static PythonType GeneratorExitStorage;
        public static PythonType GeneratorExit {
            get {
                if (GeneratorExitStorage == null) {
                    Interlocked.CompareExchange(ref GeneratorExitStorage, CreateSubType(DynamicHelpers.GetPythonTypeFromType(typeof(BaseException)), "GeneratorExit", (msg) => new GeneratorExitException(msg)), null);
                }
                return GeneratorExitStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType SystemExitStorage;
        public static PythonType SystemExit {
            get {
                if (SystemExitStorage == null) {
                    Interlocked.CompareExchange(ref SystemExitStorage, CreateSubType(DynamicHelpers.GetPythonTypeFromType(typeof(BaseException)), typeof(_SystemExit), (msg) => new SystemExitException(msg)), null);
                }
                return SystemExitStorage;
            }
        }

        [PythonType("SystemExit"), PythonHidden, DynamicBaseTypeAttribute, Serializable]
        public partial class _SystemExit : BaseException {
            private object _code;

            public _SystemExit() : base(SystemExit) { }
            public _SystemExit(PythonType type) : base(type) { }

            public new static object __new__(PythonType cls, [ParamDictionary]IDictionary<object, object> kwArgs, params object[] args) {
                return Activator.CreateInstance(cls.UnderlyingSystemType, cls);
            }

            public object code {
                get { return _code; }
                set { _code = value; }
            }

        }

        [MultiRuntimeAware]
        private static PythonType KeyboardInterruptStorage;
        public static PythonType KeyboardInterrupt {
            get {
                if (KeyboardInterruptStorage == null) {
                    Interlocked.CompareExchange(ref KeyboardInterruptStorage, CreateSubType(DynamicHelpers.GetPythonTypeFromType(typeof(BaseException)), "KeyboardInterrupt", (msg) => new KeyboardInterruptException(msg)), null);
                }
                return KeyboardInterruptStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ExceptionStorage;
        public static PythonType Exception {
            get {
                if (ExceptionStorage == null) {
                    Interlocked.CompareExchange(ref ExceptionStorage, CreateSubType(DynamicHelpers.GetPythonTypeFromType(typeof(BaseException)), "Exception", (msg) => new PythonException(msg)), null);
                }
                return ExceptionStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType StopIterationStorage;
        public static PythonType StopIteration {
            get {
                if (StopIterationStorage == null) {
                    Interlocked.CompareExchange(ref StopIterationStorage, CreateSubType(Exception, "StopIteration", (msg) => new StopIterationException(msg)), null);
                }
                return StopIterationStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType StandardErrorStorage;
        public static PythonType StandardError {
            get {
                if (StandardErrorStorage == null) {
                    Interlocked.CompareExchange(ref StandardErrorStorage, CreateSubType(Exception, "StandardError", (msg) => new ApplicationException(msg)), null);
                }
                return StandardErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType BufferErrorStorage;
        public static PythonType BufferError {
            get {
                if (BufferErrorStorage == null) {
                    Interlocked.CompareExchange(ref BufferErrorStorage, CreateSubType(StandardError, "BufferError", (msg) => new BufferException(msg)), null);
                }
                return BufferErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ArithmeticErrorStorage;
        public static PythonType ArithmeticError {
            get {
                if (ArithmeticErrorStorage == null) {
                    Interlocked.CompareExchange(ref ArithmeticErrorStorage, CreateSubType(StandardError, "ArithmeticError", (msg) => new ArithmeticException(msg)), null);
                }
                return ArithmeticErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType FloatingPointErrorStorage;
        public static PythonType FloatingPointError {
            get {
                if (FloatingPointErrorStorage == null) {
                    Interlocked.CompareExchange(ref FloatingPointErrorStorage, CreateSubType(ArithmeticError, "FloatingPointError", (msg) => new FloatingPointException(msg)), null);
                }
                return FloatingPointErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType OverflowErrorStorage;
        public static PythonType OverflowError {
            get {
                if (OverflowErrorStorage == null) {
                    Interlocked.CompareExchange(ref OverflowErrorStorage, CreateSubType(ArithmeticError, "OverflowError", (msg) => new OverflowException(msg)), null);
                }
                return OverflowErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ZeroDivisionErrorStorage;
        public static PythonType ZeroDivisionError {
            get {
                if (ZeroDivisionErrorStorage == null) {
                    Interlocked.CompareExchange(ref ZeroDivisionErrorStorage, CreateSubType(ArithmeticError, "ZeroDivisionError", (msg) => new DivideByZeroException(msg)), null);
                }
                return ZeroDivisionErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType AssertionErrorStorage;
        public static PythonType AssertionError {
            get {
                if (AssertionErrorStorage == null) {
                    Interlocked.CompareExchange(ref AssertionErrorStorage, CreateSubType(StandardError, "AssertionError", (msg) => new AssertionException(msg)), null);
                }
                return AssertionErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType AttributeErrorStorage;
        public static PythonType AttributeError {
            get {
                if (AttributeErrorStorage == null) {
                    Interlocked.CompareExchange(ref AttributeErrorStorage, CreateSubType(StandardError, "AttributeError", (msg) => new AttributeErrorException(msg)), null);
                }
                return AttributeErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType EnvironmentErrorStorage;
        public static PythonType EnvironmentError {
            get {
                if (EnvironmentErrorStorage == null) {
                    Interlocked.CompareExchange(ref EnvironmentErrorStorage, CreateSubType(StandardError, typeof(_EnvironmentError), (msg) => new ExternalException(msg)), null);
                }
                return EnvironmentErrorStorage;
            }
        }

        [PythonType("EnvironmentError"), PythonHidden, DynamicBaseTypeAttribute, Serializable]
        public partial class _EnvironmentError : BaseException {
            private object _errno;
            private object _strerror;
            private object _filename;

            public _EnvironmentError() : base(EnvironmentError) { }
            public _EnvironmentError(PythonType type) : base(type) { }

            public new static object __new__(PythonType cls, [ParamDictionary]IDictionary<object, object> kwArgs, params object[] args) {
                return Activator.CreateInstance(cls.UnderlyingSystemType, cls);
            }

            public object errno {
                get { return _errno; }
                set { _errno = value; }
            }

            public object strerror {
                get { return _strerror; }
                set { _strerror = value; }
            }

            public object filename {
                get { return _filename; }
                set { _filename = value; }
            }

        }

        [MultiRuntimeAware]
        private static PythonType IOErrorStorage;
        public static PythonType IOError {
            get {
                if (IOErrorStorage == null) {
                    Interlocked.CompareExchange(ref IOErrorStorage, CreateSubType(EnvironmentError, "IOError", (msg) => new IOException(msg)), null);
                }
                return IOErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType OSErrorStorage;
        public static PythonType OSError {
            get {
                if (OSErrorStorage == null) {
                    Interlocked.CompareExchange(ref OSErrorStorage, CreateSubType(EnvironmentError, "OSError", (msg) => new OSException(msg)), null);
                }
                return OSErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType WindowsErrorStorage;
        public static PythonType WindowsError {
            get {
                if (WindowsErrorStorage == null) {
                    Interlocked.CompareExchange(ref WindowsErrorStorage, CreateSubType(OSError, typeof(_WindowsError), (msg) => new Win32Exception(msg)), null);
                }
                return WindowsErrorStorage;
            }
        }

        [PythonType("WindowsError"), PythonHidden, DynamicBaseTypeAttribute, Serializable]
        public partial class _WindowsError : _EnvironmentError {
            private object _winerror;

            public _WindowsError() : base(WindowsError) { }
            public _WindowsError(PythonType type) : base(type) { }

            public new static object __new__(PythonType cls, [ParamDictionary]IDictionary<object, object> kwArgs, params object[] args) {
                return Activator.CreateInstance(cls.UnderlyingSystemType, cls);
            }

            public object winerror {
                get { return _winerror; }
                set { _winerror = value; }
            }

        }

        [MultiRuntimeAware]
        private static PythonType EOFErrorStorage;
        public static PythonType EOFError {
            get {
                if (EOFErrorStorage == null) {
                    Interlocked.CompareExchange(ref EOFErrorStorage, CreateSubType(StandardError, "EOFError", (msg) => new EndOfStreamException(msg)), null);
                }
                return EOFErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ImportErrorStorage;
        public static PythonType ImportError {
            get {
                if (ImportErrorStorage == null) {
                    Interlocked.CompareExchange(ref ImportErrorStorage, CreateSubType(StandardError, "ImportError", (msg) => new ImportException(msg)), null);
                }
                return ImportErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType LookupErrorStorage;
        public static PythonType LookupError {
            get {
                if (LookupErrorStorage == null) {
                    Interlocked.CompareExchange(ref LookupErrorStorage, CreateSubType(StandardError, "LookupError", (msg) => new LookupException(msg)), null);
                }
                return LookupErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType IndexErrorStorage;
        public static PythonType IndexError {
            get {
                if (IndexErrorStorage == null) {
                    Interlocked.CompareExchange(ref IndexErrorStorage, CreateSubType(LookupError, "IndexError", (msg) => new IndexOutOfRangeException(msg)), null);
                }
                return IndexErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType KeyErrorStorage;
        public static PythonType KeyError {
            get {
                if (KeyErrorStorage == null) {
                    Interlocked.CompareExchange(ref KeyErrorStorage, CreateSubType(LookupError, "KeyError", (msg) => new KeyNotFoundException(msg)), null);
                }
                return KeyErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType MemoryErrorStorage;
        public static PythonType MemoryError {
            get {
                if (MemoryErrorStorage == null) {
                    Interlocked.CompareExchange(ref MemoryErrorStorage, CreateSubType(StandardError, "MemoryError", (msg) => new OutOfMemoryException(msg)), null);
                }
                return MemoryErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType NameErrorStorage;
        public static PythonType NameError {
            get {
                if (NameErrorStorage == null) {
                    Interlocked.CompareExchange(ref NameErrorStorage, CreateSubType(StandardError, "NameError", (msg) => new UnboundNameException(msg)), null);
                }
                return NameErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType UnboundLocalErrorStorage;
        public static PythonType UnboundLocalError {
            get {
                if (UnboundLocalErrorStorage == null) {
                    Interlocked.CompareExchange(ref UnboundLocalErrorStorage, CreateSubType(NameError, "UnboundLocalError", (msg) => new UnboundLocalException(msg)), null);
                }
                return UnboundLocalErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ReferenceErrorStorage;
        public static PythonType ReferenceError {
            get {
                if (ReferenceErrorStorage == null) {
                    Interlocked.CompareExchange(ref ReferenceErrorStorage, CreateSubType(StandardError, "ReferenceError", (msg) => new ReferenceException(msg)), null);
                }
                return ReferenceErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType RuntimeErrorStorage;
        public static PythonType RuntimeError {
            get {
                if (RuntimeErrorStorage == null) {
                    Interlocked.CompareExchange(ref RuntimeErrorStorage, CreateSubType(StandardError, "RuntimeError", (msg) => new RuntimeException(msg)), null);
                }
                return RuntimeErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType NotImplementedErrorStorage;
        public static PythonType NotImplementedError {
            get {
                if (NotImplementedErrorStorage == null) {
                    Interlocked.CompareExchange(ref NotImplementedErrorStorage, CreateSubType(RuntimeError, "NotImplementedError", (msg) => new NotImplementedException(msg)), null);
                }
                return NotImplementedErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType SyntaxErrorStorage;
        public static PythonType SyntaxError {
            get {
                if (SyntaxErrorStorage == null) {
                    Interlocked.CompareExchange(ref SyntaxErrorStorage, CreateSubType(StandardError, typeof(_SyntaxError), (msg) => new SyntaxErrorException(msg)), null);
                }
                return SyntaxErrorStorage;
            }
        }

        [PythonType("SyntaxError"), PythonHidden, DynamicBaseTypeAttribute, Serializable]
        public partial class _SyntaxError : BaseException {
            private object _text;
            private object _print_file_and_line;
            private object _filename;
            private object _lineno;
            private object _offset;
            private object _msg;

            public _SyntaxError() : base(SyntaxError) { }
            public _SyntaxError(PythonType type) : base(type) { }

            public new static object __new__(PythonType cls, [ParamDictionary]IDictionary<object, object> kwArgs, params object[] args) {
                return Activator.CreateInstance(cls.UnderlyingSystemType, cls);
            }

            public object text {
                get { return _text; }
                set { _text = value; }
            }

            public object print_file_and_line {
                get { return _print_file_and_line; }
                set { _print_file_and_line = value; }
            }

            public object filename {
                get { return _filename; }
                set { _filename = value; }
            }

            public object lineno {
                get { return _lineno; }
                set { _lineno = value; }
            }

            public object offset {
                get { return _offset; }
                set { _offset = value; }
            }

            public object msg {
                get { return _msg; }
                set { _msg = value; }
            }

        }

        [MultiRuntimeAware]
        private static PythonType IndentationErrorStorage;
        public static PythonType IndentationError {
            get {
                if (IndentationErrorStorage == null) {
                    Interlocked.CompareExchange(ref IndentationErrorStorage, CreateSubType(SyntaxError, "IndentationError", (msg) => new IndentationException(msg)), null);
                }
                return IndentationErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType TabErrorStorage;
        public static PythonType TabError {
            get {
                if (TabErrorStorage == null) {
                    Interlocked.CompareExchange(ref TabErrorStorage, CreateSubType(IndentationError, "TabError", (msg) => new TabException(msg)), null);
                }
                return TabErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType SystemErrorStorage;
        public static PythonType SystemError {
            get {
                if (SystemErrorStorage == null) {
                    Interlocked.CompareExchange(ref SystemErrorStorage, CreateSubType(StandardError, "SystemError", (msg) => new SystemException(msg)), null);
                }
                return SystemErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType TypeErrorStorage;
        public static PythonType TypeError {
            get {
                if (TypeErrorStorage == null) {
                    Interlocked.CompareExchange(ref TypeErrorStorage, CreateSubType(StandardError, "TypeError", (msg) => new TypeErrorException(msg)), null);
                }
                return TypeErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ValueErrorStorage;
        public static PythonType ValueError {
            get {
                if (ValueErrorStorage == null) {
                    Interlocked.CompareExchange(ref ValueErrorStorage, CreateSubType(StandardError, "ValueError", (msg) => new ValueErrorException(msg)), null);
                }
                return ValueErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType UnicodeErrorStorage;
        public static PythonType UnicodeError {
            get {
                if (UnicodeErrorStorage == null) {
                    Interlocked.CompareExchange(ref UnicodeErrorStorage, CreateSubType(ValueError, "UnicodeError", (msg) => new UnicodeException(msg)), null);
                }
                return UnicodeErrorStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType UnicodeDecodeErrorStorage;
        public static PythonType UnicodeDecodeError {
            get {
                if (UnicodeDecodeErrorStorage == null) {
                    Interlocked.CompareExchange(ref UnicodeDecodeErrorStorage, CreateSubType(UnicodeError, typeof(_UnicodeDecodeError), (msg) => new DecoderFallbackException(msg)), null);
                }
                return UnicodeDecodeErrorStorage;
            }
        }

        [PythonType("UnicodeDecodeError"), PythonHidden, DynamicBaseTypeAttribute, Serializable]
        public partial class _UnicodeDecodeError : BaseException {
            private object _start;
            private object _reason;
            private object _object;
            private object _end;
            private object _encoding;

            public _UnicodeDecodeError() : base(UnicodeDecodeError) { }
            public _UnicodeDecodeError(PythonType type) : base(type) { }

            public new static object __new__(PythonType cls, [ParamDictionary]IDictionary<object, object> kwArgs, params object[] args) {
                return Activator.CreateInstance(cls.UnderlyingSystemType, cls);
            }

            public void __init__(object encoding, object @object, object start, object end, object reason) {
                _encoding = encoding;
                _object = @object;
                _start = start;
                _end = end;
                _reason = reason;
                args = PythonTuple.MakeTuple(encoding, @object, start, end, reason);
            }

            public override void __init__(params object[] args) {
                if (args == null || args.Length != 5) {
                    throw PythonOps.TypeError("__init__ takes exactly 5 arguments ({0} given)", args.Length);
                }
                __init__(encoding, @object, start, end, reason);
            }

            public object start {
                get { return _start; }
                set { _start = value; }
            }

            public object reason {
                get { return _reason; }
                set { _reason = value; }
            }

            public object @object {
                get { return _object; }
                set { _object = value; }
            }

            public object end {
                get { return _end; }
                set { _end = value; }
            }

            public object encoding {
                get { return _encoding; }
                set { _encoding = value; }
            }

        }

        [MultiRuntimeAware]
        private static PythonType UnicodeEncodeErrorStorage;
        public static PythonType UnicodeEncodeError {
            get {
                if (UnicodeEncodeErrorStorage == null) {
                    Interlocked.CompareExchange(ref UnicodeEncodeErrorStorage, CreateSubType(UnicodeError, typeof(_UnicodeEncodeError), (msg) => new EncoderFallbackException(msg)), null);
                }
                return UnicodeEncodeErrorStorage;
            }
        }

        [PythonType("UnicodeEncodeError"), PythonHidden, DynamicBaseTypeAttribute, Serializable]
        public partial class _UnicodeEncodeError : BaseException {
            private object _start;
            private object _reason;
            private object _object;
            private object _end;
            private object _encoding;

            public _UnicodeEncodeError() : base(UnicodeEncodeError) { }
            public _UnicodeEncodeError(PythonType type) : base(type) { }

            public new static object __new__(PythonType cls, [ParamDictionary]IDictionary<object, object> kwArgs, params object[] args) {
                return Activator.CreateInstance(cls.UnderlyingSystemType, cls);
            }

            public void __init__(object encoding, object @object, object start, object end, object reason) {
                _encoding = encoding;
                _object = @object;
                _start = start;
                _end = end;
                _reason = reason;
                args = PythonTuple.MakeTuple(encoding, @object, start, end, reason);
            }

            public override void __init__(params object[] args) {
                if (args == null || args.Length != 5) {
                    throw PythonOps.TypeError("__init__ takes exactly 5 arguments ({0} given)", args.Length);
                }
                __init__(encoding, @object, start, end, reason);
            }

            public object start {
                get { return _start; }
                set { _start = value; }
            }

            public object reason {
                get { return _reason; }
                set { _reason = value; }
            }

            public object @object {
                get { return _object; }
                set { _object = value; }
            }

            public object end {
                get { return _end; }
                set { _end = value; }
            }

            public object encoding {
                get { return _encoding; }
                set { _encoding = value; }
            }

        }

        [MultiRuntimeAware]
        private static PythonType UnicodeTranslateErrorStorage;
        public static PythonType UnicodeTranslateError {
            get {
                if (UnicodeTranslateErrorStorage == null) {
                    Interlocked.CompareExchange(ref UnicodeTranslateErrorStorage, CreateSubType(UnicodeError, typeof(_UnicodeTranslateError), (msg) => new UnicodeTranslateException(msg)), null);
                }
                return UnicodeTranslateErrorStorage;
            }
        }

        [PythonType("UnicodeTranslateError"), PythonHidden, DynamicBaseTypeAttribute, Serializable]
        public partial class _UnicodeTranslateError : BaseException {
            private object _start;
            private object _reason;
            private object _object;
            private object _end;
            private object _encoding;

            public _UnicodeTranslateError() : base(UnicodeTranslateError) { }
            public _UnicodeTranslateError(PythonType type) : base(type) { }

            public new static object __new__(PythonType cls, [ParamDictionary]IDictionary<object, object> kwArgs, params object[] args) {
                return Activator.CreateInstance(cls.UnderlyingSystemType, cls);
            }

            public object start {
                get { return _start; }
                set { _start = value; }
            }

            public object reason {
                get { return _reason; }
                set { _reason = value; }
            }

            public object @object {
                get { return _object; }
                set { _object = value; }
            }

            public object end {
                get { return _end; }
                set { _end = value; }
            }

            public object encoding {
                get { return _encoding; }
                set { _encoding = value; }
            }

        }

        [MultiRuntimeAware]
        private static PythonType WarningStorage;
        public static PythonType Warning {
            get {
                if (WarningStorage == null) {
                    Interlocked.CompareExchange(ref WarningStorage, CreateSubType(Exception, "Warning", (msg) => new WarningException(msg)), null);
                }
                return WarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType DeprecationWarningStorage;
        public static PythonType DeprecationWarning {
            get {
                if (DeprecationWarningStorage == null) {
                    Interlocked.CompareExchange(ref DeprecationWarningStorage, CreateSubType(Warning, "DeprecationWarning", (msg) => new DeprecationWarningException(msg)), null);
                }
                return DeprecationWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType PendingDeprecationWarningStorage;
        public static PythonType PendingDeprecationWarning {
            get {
                if (PendingDeprecationWarningStorage == null) {
                    Interlocked.CompareExchange(ref PendingDeprecationWarningStorage, CreateSubType(Warning, "PendingDeprecationWarning", (msg) => new PendingDeprecationWarningException(msg)), null);
                }
                return PendingDeprecationWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType RuntimeWarningStorage;
        public static PythonType RuntimeWarning {
            get {
                if (RuntimeWarningStorage == null) {
                    Interlocked.CompareExchange(ref RuntimeWarningStorage, CreateSubType(Warning, "RuntimeWarning", (msg) => new RuntimeWarningException(msg)), null);
                }
                return RuntimeWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType SyntaxWarningStorage;
        public static PythonType SyntaxWarning {
            get {
                if (SyntaxWarningStorage == null) {
                    Interlocked.CompareExchange(ref SyntaxWarningStorage, CreateSubType(Warning, "SyntaxWarning", (msg) => new SyntaxWarningException(msg)), null);
                }
                return SyntaxWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType UserWarningStorage;
        public static PythonType UserWarning {
            get {
                if (UserWarningStorage == null) {
                    Interlocked.CompareExchange(ref UserWarningStorage, CreateSubType(Warning, "UserWarning", (msg) => new UserWarningException(msg)), null);
                }
                return UserWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType FutureWarningStorage;
        public static PythonType FutureWarning {
            get {
                if (FutureWarningStorage == null) {
                    Interlocked.CompareExchange(ref FutureWarningStorage, CreateSubType(Warning, "FutureWarning", (msg) => new FutureWarningException(msg)), null);
                }
                return FutureWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType ImportWarningStorage;
        public static PythonType ImportWarning {
            get {
                if (ImportWarningStorage == null) {
                    Interlocked.CompareExchange(ref ImportWarningStorage, CreateSubType(Warning, "ImportWarning", (msg) => new ImportWarningException(msg)), null);
                }
                return ImportWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType UnicodeWarningStorage;
        public static PythonType UnicodeWarning {
            get {
                if (UnicodeWarningStorage == null) {
                    Interlocked.CompareExchange(ref UnicodeWarningStorage, CreateSubType(Warning, "UnicodeWarning", (msg) => new UnicodeWarningException(msg)), null);
                }
                return UnicodeWarningStorage;
            }
        }

        [MultiRuntimeAware]
        private static PythonType BytesWarningStorage;
        public static PythonType BytesWarning {
            get {
                if (BytesWarningStorage == null) {
                    Interlocked.CompareExchange(ref BytesWarningStorage, CreateSubType(Warning, "BytesWarning", (msg) => new BytesWarningException(msg)), null);
                }
                return BytesWarningStorage;
            }
        }


        // *** END GENERATED CODE ***

        #endregion

        #region Generated ToPython Exception Helper

        // *** BEGIN GENERATED CODE ***
        // generated by function: gen_topython_helper from: generate_exceptions.py

        private static BaseException/*!*/ ToPythonHelper(System.Exception clrException) {
            if (clrException is BytesWarningException) return new PythonExceptions.BaseException(PythonExceptions.BytesWarning);
            if (clrException is DecoderFallbackException) return new PythonExceptions._UnicodeDecodeError();
            if (clrException is DeprecationWarningException) return new PythonExceptions.BaseException(PythonExceptions.DeprecationWarning);
            if (clrException is DivideByZeroException) return new PythonExceptions.BaseException(PythonExceptions.ZeroDivisionError);
            if (clrException is EncoderFallbackException) return new PythonExceptions._UnicodeEncodeError();
            if (clrException is EndOfStreamException) return new PythonExceptions.BaseException(PythonExceptions.EOFError);
            if (clrException is FutureWarningException) return new PythonExceptions.BaseException(PythonExceptions.FutureWarning);
            if (clrException is ImportWarningException) return new PythonExceptions.BaseException(PythonExceptions.ImportWarning);
            if (clrException is MissingMemberException) return new PythonExceptions.BaseException(PythonExceptions.AttributeError);
            if (clrException is OverflowException) return new PythonExceptions.BaseException(PythonExceptions.OverflowError);
            if (clrException is PendingDeprecationWarningException) return new PythonExceptions.BaseException(PythonExceptions.PendingDeprecationWarning);
            if (clrException is RuntimeWarningException) return new PythonExceptions.BaseException(PythonExceptions.RuntimeWarning);
            if (clrException is SyntaxWarningException) return new PythonExceptions.BaseException(PythonExceptions.SyntaxWarning);
            if (clrException is TabException) return new PythonExceptions._SyntaxError(PythonExceptions.TabError);
            if (clrException is UnicodeWarningException) return new PythonExceptions.BaseException(PythonExceptions.UnicodeWarning);
            if (clrException is UserWarningException) return new PythonExceptions.BaseException(PythonExceptions.UserWarning);
            if (clrException is Win32Exception) return new PythonExceptions._WindowsError();
            if (clrException is ArgumentException) return new PythonExceptions.BaseException(PythonExceptions.ValueError);
            if (clrException is ArithmeticException) return new PythonExceptions.BaseException(PythonExceptions.ArithmeticError);
            if (clrException is ExternalException) return new PythonExceptions._EnvironmentError();
            if (clrException is IOException) return new PythonExceptions._EnvironmentError(PythonExceptions.IOError);
            if (clrException is IndentationException) return new PythonExceptions._SyntaxError(PythonExceptions.IndentationError);
            if (clrException is IndexOutOfRangeException) return new PythonExceptions.BaseException(PythonExceptions.IndexError);
            if (clrException is KeyNotFoundException) return new PythonExceptions.BaseException(PythonExceptions.KeyError);
            if (clrException is NotImplementedException) return new PythonExceptions.BaseException(PythonExceptions.NotImplementedError);
            if (clrException is OSException) return new PythonExceptions._EnvironmentError(PythonExceptions.OSError);
            if (clrException is OutOfMemoryException) return new PythonExceptions.BaseException(PythonExceptions.MemoryError);
            if (clrException is UnboundLocalException) return new PythonExceptions.BaseException(PythonExceptions.UnboundLocalError);
            if (clrException is UnicodeTranslateException) return new PythonExceptions._UnicodeTranslateError();
            if (clrException is WarningException) return new PythonExceptions.BaseException(PythonExceptions.Warning);
            if (clrException is ApplicationException) return new PythonExceptions.BaseException(PythonExceptions.StandardError);
            if (clrException is ArgumentTypeException) return new PythonExceptions.BaseException(PythonExceptions.TypeError);
            if (clrException is AssertionException) return new PythonExceptions.BaseException(PythonExceptions.AssertionError);
            if (clrException is BufferException) return new PythonExceptions.BaseException(PythonExceptions.BufferError);
            if (clrException is FloatingPointException) return new PythonExceptions.BaseException(PythonExceptions.FloatingPointError);
            if (clrException is GeneratorExitException) return new PythonExceptions.BaseException(PythonExceptions.GeneratorExit);
            if (clrException is ImportException) return new PythonExceptions.BaseException(PythonExceptions.ImportError);
            if (clrException is KeyboardInterruptException) return new PythonExceptions.BaseException(PythonExceptions.KeyboardInterrupt);
            if (clrException is LookupException) return new PythonExceptions.BaseException(PythonExceptions.LookupError);
            if (clrException is PythonException) return new PythonExceptions.BaseException(PythonExceptions.Exception);
            if (clrException is ReferenceException) return new PythonExceptions.BaseException(PythonExceptions.ReferenceError);
            if (clrException is RuntimeException) return new PythonExceptions.BaseException(PythonExceptions.RuntimeError);
            if (clrException is StopIterationException) return new PythonExceptions.BaseException(PythonExceptions.StopIteration);
            if (clrException is SyntaxErrorException) return new PythonExceptions._SyntaxError();
            if (clrException is SystemException) return new PythonExceptions.BaseException(PythonExceptions.SystemError);
            if (clrException is SystemExitException) return new PythonExceptions._SystemExit();
            if (clrException is UnboundNameException) return new PythonExceptions.BaseException(PythonExceptions.NameError);
            if (clrException is UnicodeException) return new PythonExceptions.BaseException(PythonExceptions.UnicodeError);
            return new BaseException(Exception);
        }

        // *** END GENERATED CODE ***

        #endregion
    }
}
