﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.

#if FEATURE_REFEMIT

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Dynamic;
using System.Reflection;
using System.Runtime.CompilerServices;
using System.Text;

using Microsoft.Scripting;
using Microsoft.Scripting.Utils;

using IronPython.Runtime;
using IronPython.Runtime.Operations;

using MSAst = System.Linq.Expressions;


namespace IronPython.Compiler.Ast {
    using Ast = MSAst.Expression;
    
    /// <summary>
    /// Implements globals which are backed by a static type, followed by an array if the static types' slots become full.  The global
    /// variables are stored in static fields on a type for fast access.  The type also includes fields for constants and call sites
    /// so they can be accessed much fasetr.
    /// 
    /// We don't generate any code into the type though - DynamicMethod's are much faster for code gen then normal ref emit.
    /// </summary>
    partial class UncollectableCompilationMode {
        #region Generated Cached Site Support

        // *** BEGIN GENERATED CODE ***
        // generated by function: gen_dynamic from: generate_UncollectableCompilationMode.py

        public override MSAst.Expression/*!*/ ReduceDynamic(DynamicMetaObjectBinder/*!*/ binder, Type/*!*/ retType, MSAst.Expression/*!*/ arg0) {
            Assert.NotNull(binder, retType, arg0);

            DelegateCache info;
            lock (_delegateCache) {
                info = DelegateCache.FirstCacheNode(arg0.Type).NextCacheNode(retType);
                if (info.DelegateType == null) {
                    info.MakeDelegateType(retType, arg0);
                }
            }

            SiteInfo si = info.NextSite(binder);

            return MakeDynamicExpression(binder, si.Expression, info.TargetField, info.InvokeMethod, arg0);
        }

        private static MSAst.Expression/*!*/ MakeDynamicExpression(DynamicMetaObjectBinder/*!*/ binder, MSAst.Expression/*!*/ expr, FieldInfo/*!*/ targetField, MethodInfo/*!*/ invokeMethod, MSAst.Expression/*!*/ arg0) {
            return new ReducableDynamicExpression(
                Ast.Call(
                    Ast.Field(expr, targetField),
                    invokeMethod,
                    expr, arg0
                ),
                binder,
                new[] { arg0 }
            );
        }

        public override MSAst.Expression/*!*/ ReduceDynamic(DynamicMetaObjectBinder/*!*/ binder, Type/*!*/ retType, MSAst.Expression/*!*/ arg0, MSAst.Expression/*!*/ arg1) {
            Assert.NotNull(binder, retType, arg0, arg1);

            DelegateCache info;
            lock (_delegateCache) {
                info = DelegateCache.FirstCacheNode(arg0.Type).NextCacheNode(arg1.Type).NextCacheNode(retType);
                if (info.DelegateType == null) {
                    info.MakeDelegateType(retType, arg0, arg1);
                }
            }

            SiteInfo si = info.NextSite(binder);

            return MakeDynamicExpression(binder, si.Expression, info.TargetField, info.InvokeMethod, arg0, arg1);
        }

        private static MSAst.Expression/*!*/ MakeDynamicExpression(DynamicMetaObjectBinder/*!*/ binder, MSAst.Expression/*!*/ expr, FieldInfo/*!*/ targetField, MethodInfo/*!*/ invokeMethod, MSAst.Expression/*!*/ arg0, MSAst.Expression/*!*/ arg1) {
            return new ReducableDynamicExpression(
                Ast.Call(
                    Ast.Field(expr, targetField),
                    invokeMethod,
                    expr, arg0, arg1
                ),
                binder,
                new[] { arg0, arg1 }
            );
        }

        public override MSAst.Expression/*!*/ ReduceDynamic(DynamicMetaObjectBinder/*!*/ binder, Type/*!*/ retType, MSAst.Expression/*!*/ arg0, MSAst.Expression/*!*/ arg1, MSAst.Expression/*!*/ arg2) {
            Assert.NotNull(binder, retType);
            Assert.NotNull(arg0, arg1, arg2);

            DelegateCache info;
            lock (_delegateCache) {
                info = DelegateCache.FirstCacheNode(arg0.Type).NextCacheNode(arg1.Type).NextCacheNode(arg2.Type).NextCacheNode(retType);
                if (info.DelegateType == null) {
                    info.MakeDelegateType(retType, arg0, arg1, arg2);
                }
            }

            SiteInfo si = info.NextSite(binder);

            return MakeDynamicExpression(binder, si.Expression, info.TargetField, info.InvokeMethod, arg0, arg1, arg2);
        }

        private static MSAst.Expression/*!*/ MakeDynamicExpression(DynamicMetaObjectBinder/*!*/ binder, MSAst.Expression/*!*/ expr, FieldInfo/*!*/ targetField, MethodInfo/*!*/ invokeMethod, MSAst.Expression/*!*/ arg0, MSAst.Expression/*!*/ arg1, MSAst.Expression/*!*/ arg2) {
            return new ReducableDynamicExpression(
                Ast.Call(
                    Ast.Field(expr, targetField),
                    invokeMethod,
                    expr, arg0, arg1, arg2
                ),
                binder,
                new[] { arg0, arg1, arg2 }
            );
        }

        public override MSAst.Expression/*!*/ ReduceDynamic(DynamicMetaObjectBinder/*!*/ binder, Type/*!*/ retType, MSAst.Expression/*!*/ arg0, MSAst.Expression/*!*/ arg1, MSAst.Expression/*!*/ arg2, MSAst.Expression/*!*/ arg3) {
            Assert.NotNull(binder, retType);
            Assert.NotNull(arg0, arg1, arg2, arg3);

            DelegateCache info;
            lock (_delegateCache) {
                info = DelegateCache.FirstCacheNode(arg0.Type).NextCacheNode(arg1.Type).NextCacheNode(arg2.Type).NextCacheNode(arg3.Type).NextCacheNode(retType);
                if (info.DelegateType == null) {
                    info.MakeDelegateType(retType, arg0, arg1, arg2, arg3);
                }
            }

            SiteInfo si = info.NextSite(binder);

            return MakeDynamicExpression(binder, si.Expression, info.TargetField, info.InvokeMethod, arg0, arg1, arg2, arg3);
        }

        private static MSAst.Expression/*!*/ MakeDynamicExpression(DynamicMetaObjectBinder/*!*/ binder, MSAst.Expression/*!*/ expr, FieldInfo/*!*/ targetField, MethodInfo/*!*/ invokeMethod, MSAst.Expression/*!*/ arg0, MSAst.Expression/*!*/ arg1, MSAst.Expression/*!*/ arg2, MSAst.Expression/*!*/ arg3) {
            var builder = new ReadOnlyCollectionBuilder<MSAst.Expression>(5);
            builder.Add(expr);
            builder.Add(arg0);
            builder.Add(arg1);
            builder.Add(arg2);
            builder.Add(arg3);

            return new ReducableDynamicExpression(
                Ast.Call(
                    Ast.Field(expr, targetField),
                    invokeMethod,
                    builder.ToReadOnlyCollection()
                ),
                binder,
                new[] { arg0, arg1, arg2, arg3 }
            );
        }

        // *** END GENERATED CODE ***

        #endregion

        #region Cached Site Support

        public override MSAst.Expression/*!*/ ReduceDynamic(DynamicMetaObjectBinder/*!*/ binder, Type/*!*/ retType, MSAst.Expression/*!*/[]/*!*/ args) {
            Assert.NotNull(binder, retType, args);
            Assert.NotNullItems(args);

            Type delegateType = GetDelegateType(retType, args);
            Type siteType = typeof(CallSite<>).MakeGenericType(delegateType);

            SiteInfo si = NextSite(binder, delegateType);

            return MakeDynamicExpression(binder, si.Expression, siteType.GetField("Target"), delegateType.GetMethod("Invoke"), args);
        }

        private static MSAst.Expression/*!*/ MakeDynamicExpression(DynamicMetaObjectBinder/*!*/ binder, MSAst.Expression/*!*/ expr, FieldInfo/*!*/ targetField, MethodInfo/*!*/ invokeMethod, IList<MSAst.Expression/*!*/>/*!*/ args) {
            var builder = new ReadOnlyCollectionBuilder<MSAst.Expression>(args.Count + 1);
            builder.Add(expr);
            foreach (MSAst.Expression arg in args) {
                builder.Add(arg);
            }

            return new ReducableDynamicExpression(
                Ast.Call(
                    Ast.Field(expr, targetField),
                    invokeMethod,
                    builder.ToReadOnlyCollection()
                ),
                binder,
                args
            );
        }

        private static Type/*!*/ GetDelegateType(Type/*!*/ retType, IList<MSAst.Expression/*!*/>/*!*/ args) {
            Assert.NotNull(retType);
            Assert.NotNull(args);

            Type delegateType;
            if (retType != typeof(void)) {
                Type[] types = new Type[args.Count + 2];
                types[0] = typeof(CallSite);

                for (int i = 0; i < args.Count; i++) {
                    types[i + 1] = args[i].Type;
                }

                types[types.Length - 1] = retType;
                delegateType = GetFuncType(types) ?? PythonOps.MakeNewCustomDelegate(types);
            } else {
                Type[] types = new Type[args.Count + 1];
                types[0] = typeof(CallSite);

                for (int i = 0; i < args.Count; i++) {
                    types[i + 1] = args[i].Type;
                }
                delegateType = GetActionType(types) ?? PythonOps.MakeNewCustomDelegate(ArrayUtils.Append(types, typeof(void)));
            }
            return delegateType;
        }

        private static Type GetFuncType(Type/*!*/[]/*!*/ types) {
            switch (types.Length) {
                #region Generated Delegate Func Types

                // *** BEGIN GENERATED CODE ***
                // generated by function: gen_delegate_func from: generate_dynsites.py

                case 1: return typeof(Func<>).MakeGenericType(types);
                case 2: return typeof(Func<,>).MakeGenericType(types);
                case 3: return typeof(Func<,,>).MakeGenericType(types);
                case 4: return typeof(Func<,,,>).MakeGenericType(types);
                case 5: return typeof(Func<,,,,>).MakeGenericType(types);
                case 6: return typeof(Func<,,,,,>).MakeGenericType(types);
                case 7: return typeof(Func<,,,,,,>).MakeGenericType(types);
                case 8: return typeof(Func<,,,,,,,>).MakeGenericType(types);
                case 9: return typeof(Func<,,,,,,,,>).MakeGenericType(types);
                case 10: return typeof(Func<,,,,,,,,,>).MakeGenericType(types);
                case 11: return typeof(Func<,,,,,,,,,,>).MakeGenericType(types);
                case 12: return typeof(Func<,,,,,,,,,,,>).MakeGenericType(types);
                case 13: return typeof(Func<,,,,,,,,,,,,>).MakeGenericType(types);
                case 14: return typeof(Func<,,,,,,,,,,,,,>).MakeGenericType(types);
                case 15: return typeof(Func<,,,,,,,,,,,,,,>).MakeGenericType(types);
                case 16: return typeof(Func<,,,,,,,,,,,,,,,>).MakeGenericType(types);
                case 17: return typeof(Func<,,,,,,,,,,,,,,,,>).MakeGenericType(types);

                // *** END GENERATED CODE ***

                #endregion

                default: return null;
            }
        }

        private static Type/*!*/ GetActionType(Type/*!*/[]/*!*/ types) {
            switch (types.Length) {
                case 0: return typeof(Action);
                #region Generated Delegate Action Types

                // *** BEGIN GENERATED CODE ***
                // generated by function: gen_delegate_action from: generate_dynsites.py

                case 1: return typeof(Action<>).MakeGenericType(types);
                case 2: return typeof(Action<,>).MakeGenericType(types);
                case 3: return typeof(Action<,,>).MakeGenericType(types);
                case 4: return typeof(Action<,,,>).MakeGenericType(types);
                case 5: return typeof(Action<,,,,>).MakeGenericType(types);
                case 6: return typeof(Action<,,,,,>).MakeGenericType(types);
                case 7: return typeof(Action<,,,,,,>).MakeGenericType(types);
                case 8: return typeof(Action<,,,,,,,>).MakeGenericType(types);
                case 9: return typeof(Action<,,,,,,,,>).MakeGenericType(types);
                case 10: return typeof(Action<,,,,,,,,,>).MakeGenericType(types);
                case 11: return typeof(Action<,,,,,,,,,,>).MakeGenericType(types);
                case 12: return typeof(Action<,,,,,,,,,,,>).MakeGenericType(types);
                case 13: return typeof(Action<,,,,,,,,,,,,>).MakeGenericType(types);
                case 14: return typeof(Action<,,,,,,,,,,,,,>).MakeGenericType(types);
                case 15: return typeof(Action<,,,,,,,,,,,,,,>).MakeGenericType(types);
                case 16: return typeof(Action<,,,,,,,,,,,,,,,>).MakeGenericType(types);

                // *** END GENERATED CODE ***

                #endregion

                default: return null;
            }
        }

        #endregion
    }

    #region Generated Storage

    // *** BEGIN GENERATED CODE ***
    // generated by function: gen_static_storage from: generate_UncollectableCompilationMode.py

    public static class StorageData {
        // Amount of data currently allocated
        internal static int ContextCount;
        internal static int ConstantCount;
        internal static int SymbolCount;
        internal static int GlobalCount;

        // Number of static fields per storage type
        public const int StaticFields = 50;

        // Number of storage types for each kind of data
        public const int ContextTypes = 1;
        public const int ConstantTypes = 5;
        public const int SymbolTypes = 7;
        public const int GlobalTypes = 20;
        public const int SiteTypes = 30;

        // Fallback array storage and locking objects
        public static CodeContext[] Contexts = new CodeContext[64];
        public static object[] Constants = new object[64];
        public static PythonGlobal[] Globals = new PythonGlobal[64];

        // Locking object for site storage
        public static readonly object SiteLockObj = new object();

        // Indexing helpers

        /// <summary>Ensures the underlying array is long enough to accomodate the given index</summary>
        /// <returns>The context storage type corresponding to the given index</returns>
        public static Type/*!*/ ContextStorageType(int index) {
            Debug.Assert(index >= 0);

            if (index < StaticFields) {
                return typeof(ContextStorage000);
            } else {
                int len = checked(index - StaticFields * ContextTypes + 1);
                if (Contexts.Length < len) {
                    int newLen = Contexts.Length;
                    while (newLen < len) {
                        newLen *= 2;
                    }
                    Array.Resize(ref Contexts, newLen);
                }
                return typeof(StorageData);
            }
        }

        /// <summary>Ensures the underlying array is long enough to accomodate the given index</summary>
        /// <returns>The constant storage type corresponding to the given index</returns>
        public static Type/*!*/ ConstantStorageType(int index) {
            Debug.Assert(index >= 0);

            switch (index / StaticFields) {
                case 000: return typeof(ConstantStorage000);
                case 001: return typeof(ConstantStorage001);
                case 002: return typeof(ConstantStorage002);
                case 003: return typeof(ConstantStorage003);
                case 004: return typeof(ConstantStorage004);

                default:
                    int len = checked(index - StaticFields * ConstantTypes + 1);
                    if (Constants.Length < len) {
                        int newLen = Constants.Length;
                        while (newLen < len) {
                            newLen *= 2;
                        }
                        Array.Resize(ref Constants, newLen);
                    }
                    return typeof(StorageData);
            }
        }

        /// <summary>Ensures the underlying array is long enough to accomodate the given index</summary>
        /// <returns>The global storage type corresponding to the given index</returns>
        public static Type/*!*/ GlobalStorageType(int index) {
            Debug.Assert(index >= 0);

            switch (index / StaticFields) {
                case 000: return typeof(GlobalStorage000);
                case 001: return typeof(GlobalStorage001);
                case 002: return typeof(GlobalStorage002);
                case 003: return typeof(GlobalStorage003);
                case 004: return typeof(GlobalStorage004);
                case 005: return typeof(GlobalStorage005);
                case 006: return typeof(GlobalStorage006);
                case 007: return typeof(GlobalStorage007);
                case 008: return typeof(GlobalStorage008);
                case 009: return typeof(GlobalStorage009);
                case 010: return typeof(GlobalStorage010);
                case 011: return typeof(GlobalStorage011);
                case 012: return typeof(GlobalStorage012);
                case 013: return typeof(GlobalStorage013);
                case 014: return typeof(GlobalStorage014);
                case 015: return typeof(GlobalStorage015);
                case 016: return typeof(GlobalStorage016);
                case 017: return typeof(GlobalStorage017);
                case 018: return typeof(GlobalStorage018);
                case 019: return typeof(GlobalStorage019);

                default:
                    int len = checked(index - StaticFields * GlobalTypes + 1);
                    if (Globals.Length < len) {
                        int newLen = Globals.Length;
                        while (newLen < len) {
                            newLen *= 2;
                        }
                        Array.Resize(ref Globals, newLen);
                    }
                    return typeof(StorageData);
            }
        }
    }

    public static class ContextStorage000 {
        public static CodeContext Context000;
        public static CodeContext Context001;
        public static CodeContext Context002;
        public static CodeContext Context003;
        public static CodeContext Context004;
        public static CodeContext Context005;
        public static CodeContext Context006;
        public static CodeContext Context007;
        public static CodeContext Context008;
        public static CodeContext Context009;
        public static CodeContext Context010;
        public static CodeContext Context011;
        public static CodeContext Context012;
        public static CodeContext Context013;
        public static CodeContext Context014;
        public static CodeContext Context015;
        public static CodeContext Context016;
        public static CodeContext Context017;
        public static CodeContext Context018;
        public static CodeContext Context019;
        public static CodeContext Context020;
        public static CodeContext Context021;
        public static CodeContext Context022;
        public static CodeContext Context023;
        public static CodeContext Context024;
        public static CodeContext Context025;
        public static CodeContext Context026;
        public static CodeContext Context027;
        public static CodeContext Context028;
        public static CodeContext Context029;
        public static CodeContext Context030;
        public static CodeContext Context031;
        public static CodeContext Context032;
        public static CodeContext Context033;
        public static CodeContext Context034;
        public static CodeContext Context035;
        public static CodeContext Context036;
        public static CodeContext Context037;
        public static CodeContext Context038;
        public static CodeContext Context039;
        public static CodeContext Context040;
        public static CodeContext Context041;
        public static CodeContext Context042;
        public static CodeContext Context043;
        public static CodeContext Context044;
        public static CodeContext Context045;
        public static CodeContext Context046;
        public static CodeContext Context047;
        public static CodeContext Context048;
        public static CodeContext Context049;
    }

    public static class ConstantStorage000 {
        public static object Constant000;
        public static object Constant001;
        public static object Constant002;
        public static object Constant003;
        public static object Constant004;
        public static object Constant005;
        public static object Constant006;
        public static object Constant007;
        public static object Constant008;
        public static object Constant009;
        public static object Constant010;
        public static object Constant011;
        public static object Constant012;
        public static object Constant013;
        public static object Constant014;
        public static object Constant015;
        public static object Constant016;
        public static object Constant017;
        public static object Constant018;
        public static object Constant019;
        public static object Constant020;
        public static object Constant021;
        public static object Constant022;
        public static object Constant023;
        public static object Constant024;
        public static object Constant025;
        public static object Constant026;
        public static object Constant027;
        public static object Constant028;
        public static object Constant029;
        public static object Constant030;
        public static object Constant031;
        public static object Constant032;
        public static object Constant033;
        public static object Constant034;
        public static object Constant035;
        public static object Constant036;
        public static object Constant037;
        public static object Constant038;
        public static object Constant039;
        public static object Constant040;
        public static object Constant041;
        public static object Constant042;
        public static object Constant043;
        public static object Constant044;
        public static object Constant045;
        public static object Constant046;
        public static object Constant047;
        public static object Constant048;
        public static object Constant049;
    }
    public static class ConstantStorage001 {
        public static object Constant000;
        public static object Constant001;
        public static object Constant002;
        public static object Constant003;
        public static object Constant004;
        public static object Constant005;
        public static object Constant006;
        public static object Constant007;
        public static object Constant008;
        public static object Constant009;
        public static object Constant010;
        public static object Constant011;
        public static object Constant012;
        public static object Constant013;
        public static object Constant014;
        public static object Constant015;
        public static object Constant016;
        public static object Constant017;
        public static object Constant018;
        public static object Constant019;
        public static object Constant020;
        public static object Constant021;
        public static object Constant022;
        public static object Constant023;
        public static object Constant024;
        public static object Constant025;
        public static object Constant026;
        public static object Constant027;
        public static object Constant028;
        public static object Constant029;
        public static object Constant030;
        public static object Constant031;
        public static object Constant032;
        public static object Constant033;
        public static object Constant034;
        public static object Constant035;
        public static object Constant036;
        public static object Constant037;
        public static object Constant038;
        public static object Constant039;
        public static object Constant040;
        public static object Constant041;
        public static object Constant042;
        public static object Constant043;
        public static object Constant044;
        public static object Constant045;
        public static object Constant046;
        public static object Constant047;
        public static object Constant048;
        public static object Constant049;
    }
    public static class ConstantStorage002 {
        public static object Constant000;
        public static object Constant001;
        public static object Constant002;
        public static object Constant003;
        public static object Constant004;
        public static object Constant005;
        public static object Constant006;
        public static object Constant007;
        public static object Constant008;
        public static object Constant009;
        public static object Constant010;
        public static object Constant011;
        public static object Constant012;
        public static object Constant013;
        public static object Constant014;
        public static object Constant015;
        public static object Constant016;
        public static object Constant017;
        public static object Constant018;
        public static object Constant019;
        public static object Constant020;
        public static object Constant021;
        public static object Constant022;
        public static object Constant023;
        public static object Constant024;
        public static object Constant025;
        public static object Constant026;
        public static object Constant027;
        public static object Constant028;
        public static object Constant029;
        public static object Constant030;
        public static object Constant031;
        public static object Constant032;
        public static object Constant033;
        public static object Constant034;
        public static object Constant035;
        public static object Constant036;
        public static object Constant037;
        public static object Constant038;
        public static object Constant039;
        public static object Constant040;
        public static object Constant041;
        public static object Constant042;
        public static object Constant043;
        public static object Constant044;
        public static object Constant045;
        public static object Constant046;
        public static object Constant047;
        public static object Constant048;
        public static object Constant049;
    }
    public static class ConstantStorage003 {
        public static object Constant000;
        public static object Constant001;
        public static object Constant002;
        public static object Constant003;
        public static object Constant004;
        public static object Constant005;
        public static object Constant006;
        public static object Constant007;
        public static object Constant008;
        public static object Constant009;
        public static object Constant010;
        public static object Constant011;
        public static object Constant012;
        public static object Constant013;
        public static object Constant014;
        public static object Constant015;
        public static object Constant016;
        public static object Constant017;
        public static object Constant018;
        public static object Constant019;
        public static object Constant020;
        public static object Constant021;
        public static object Constant022;
        public static object Constant023;
        public static object Constant024;
        public static object Constant025;
        public static object Constant026;
        public static object Constant027;
        public static object Constant028;
        public static object Constant029;
        public static object Constant030;
        public static object Constant031;
        public static object Constant032;
        public static object Constant033;
        public static object Constant034;
        public static object Constant035;
        public static object Constant036;
        public static object Constant037;
        public static object Constant038;
        public static object Constant039;
        public static object Constant040;
        public static object Constant041;
        public static object Constant042;
        public static object Constant043;
        public static object Constant044;
        public static object Constant045;
        public static object Constant046;
        public static object Constant047;
        public static object Constant048;
        public static object Constant049;
    }
    public static class ConstantStorage004 {
        public static object Constant000;
        public static object Constant001;
        public static object Constant002;
        public static object Constant003;
        public static object Constant004;
        public static object Constant005;
        public static object Constant006;
        public static object Constant007;
        public static object Constant008;
        public static object Constant009;
        public static object Constant010;
        public static object Constant011;
        public static object Constant012;
        public static object Constant013;
        public static object Constant014;
        public static object Constant015;
        public static object Constant016;
        public static object Constant017;
        public static object Constant018;
        public static object Constant019;
        public static object Constant020;
        public static object Constant021;
        public static object Constant022;
        public static object Constant023;
        public static object Constant024;
        public static object Constant025;
        public static object Constant026;
        public static object Constant027;
        public static object Constant028;
        public static object Constant029;
        public static object Constant030;
        public static object Constant031;
        public static object Constant032;
        public static object Constant033;
        public static object Constant034;
        public static object Constant035;
        public static object Constant036;
        public static object Constant037;
        public static object Constant038;
        public static object Constant039;
        public static object Constant040;
        public static object Constant041;
        public static object Constant042;
        public static object Constant043;
        public static object Constant044;
        public static object Constant045;
        public static object Constant046;
        public static object Constant047;
        public static object Constant048;
        public static object Constant049;
    }

    public static class GlobalStorage000 {
        public static PythonGlobal Global000;
        public static PythonGlobal Global001;
        public static PythonGlobal Global002;
        public static PythonGlobal Global003;
        public static PythonGlobal Global004;
        public static PythonGlobal Global005;
        public static PythonGlobal Global006;
        public static PythonGlobal Global007;
        public static PythonGlobal Global008;
        public static PythonGlobal Global009;
        public static PythonGlobal Global010;
        public static PythonGlobal Global011;
        public static PythonGlobal Global012;
        public static PythonGlobal Global013;
        public static PythonGlobal Global014;
        public static PythonGlobal Global015;
        public static PythonGlobal Global016;
        public static PythonGlobal Global017;
        public static PythonGlobal Global018;
        public static PythonGlobal Global019;
        public static PythonGlobal Global020;
        public static PythonGlobal Global021;
        public static PythonGlobal Global022;
        public static PythonGlobal Global023;
        public static PythonGlobal Global024;
        public static PythonGlobal Global025;
        public static PythonGlobal Global026;
        public static PythonGlobal Global027;
        public static PythonGlobal Global028;
        public static PythonGlobal Global029;
        public static PythonGlobal Global030;
        public static PythonGlobal Global031;
        public static PythonGlobal Global032;
        public static PythonGlobal Global033;
        public static PythonGlobal Global034;
        public static PythonGlobal Global035;
        public static PythonGlobal Global036;
        public static PythonGlobal Global037;
        public static PythonGlobal Global038;
        public static PythonGlobal Global039;
        public static PythonGlobal Global040;
        public static PythonGlobal Global041;
        public static PythonGlobal Global042;
        public static PythonGlobal Global043;
        public static PythonGlobal Global044;
        public static PythonGlobal Global045;
        public static PythonGlobal Global046;
        public static PythonGlobal Global047;
        public static PythonGlobal Global048;
        public static PythonGlobal Global049;
    }
    public static class GlobalStorage001 {
        public static PythonGlobal Global000;
        public static PythonGlobal Global001;
        public static PythonGlobal Global002;
        public static PythonGlobal Global003;
        public static PythonGlobal Global004;
        public static PythonGlobal Global005;
        public static PythonGlobal Global006;
        public static PythonGlobal Global007;
        public static PythonGlobal Global008;
        public static PythonGlobal Global009;
        public static PythonGlobal Global010;
        public static PythonGlobal Global011;
        public static PythonGlobal Global012;
        public static PythonGlobal Global013;
        public static PythonGlobal Global014;
        public static PythonGlobal Global015;
        public static PythonGlobal Global016;
        public static PythonGlobal Global017;
        public static PythonGlobal Global018;
        public static PythonGlobal Global019;
        public static PythonGlobal Global020;
        public static PythonGlobal Global021;
        public static PythonGlobal Global022;
        public static PythonGlobal Global023;
        public static PythonGlobal Global024;
        public static PythonGlobal Global025;
        public static PythonGlobal Global026;
        public static PythonGlobal Global027;
        public static PythonGlobal Global028;
        public static PythonGlobal Global029;
        public static PythonGlobal Global030;
        public static PythonGlobal Global031;
        public static PythonGlobal Global032;
        public static PythonGlobal Global033;
        public static PythonGlobal Global034;
        public static PythonGlobal Global035;
        public static PythonGlobal Global036;
        public static PythonGlobal Global037;
        public static PythonGlobal Global038;
        public static PythonGlobal Global039;
        public static PythonGlobal Global040;
        public static PythonGlobal Global041;
        public static PythonGlobal Global042;
        public static PythonGlobal Global043;
        public static PythonGlobal Global044;
        public static PythonGlobal Global045;
        public static PythonGlobal Global046;
        public static PythonGlobal Global047;
        public static PythonGlobal Global048;
        public static PythonGlobal Global049;
    }
    public static class GlobalStorage002 {
        public static PythonGlobal Global000;
        public static PythonGlobal Global001;
        public static PythonGlobal Global002;
        public static PythonGlobal Global003;
        public static PythonGlobal Global004;
        public static PythonGlobal Global005;
        public static PythonGlobal Global006;
        public static PythonGlobal Global007;
        public static PythonGlobal Global008;
        public static PythonGlobal Global009;
        public static PythonGlobal Global010;
        public static PythonGlobal Global011;
        public static PythonGlobal Global012;
        public static PythonGlobal Global013;
        public static PythonGlobal Global014;
        public static PythonGlobal Global015;
        public static PythonGlobal Global016;
        public static PythonGlobal Global017;
        public static PythonGlobal Global018;
        public static PythonGlobal Global019;
        public static PythonGlobal Global020;
        public static PythonGlobal Global021;
        public static PythonGlobal Global022;
        public static PythonGlobal Global023;
        public static PythonGlobal Global024;
        public static PythonGlobal Global025;
        public static PythonGlobal Global026;
        public static PythonGlobal Global027;
        public static PythonGlobal Global028;
        public static PythonGlobal Global029;
        public static PythonGlobal Global030;
        public static PythonGlobal Global031;
        public static PythonGlobal Global032;
        public static PythonGlobal Global033;
        public static PythonGlobal Global034;
        public static PythonGlobal Global035;
        public static PythonGlobal Global036;
        public static PythonGlobal Global037;
        public static PythonGlobal Global038;
        public static PythonGlobal Global039;
        public static PythonGlobal Global040;
        public static PythonGlobal Global041;
        public static PythonGlobal Global042;
        public static PythonGlobal Global043;
        public static PythonGlobal Global044;
        public static PythonGlobal Global045;
        public static PythonGlobal Global046;
        public static PythonGlobal Global047;
        public static PythonGlobal Global048;
        public static PythonGlobal Global049;
    }
    public static class GlobalStorage003 {
        public static PythonGlobal Global000;
        public static PythonGlobal Global001;
        public static PythonGlobal Global002;
        public static PythonGlobal Global003;
        public static PythonGlobal Global004;
        public static PythonGlobal Global005;
        public static PythonGlobal Global006;
        public static PythonGlobal Global007;
        public static PythonGlobal Global008;
        public static PythonGlobal Global009;
        public static PythonGlobal Global010;
        public static PythonGlobal Global011;
        public static PythonGlobal Global012;
        public static PythonGlobal Global013;
        public static PythonGlobal Global014;
        public static PythonGlobal Global015;
        public static PythonGlobal Global016;
        public static PythonGlobal Global017;
        public static PythonGlobal Global018;
        public static PythonGlobal Global019;
        public static PythonGlobal Global020;
        public static PythonGlobal Global021;
        public static PythonGlobal Global022;
        public static PythonGlobal Global023;
        public static PythonGlobal Global024;
        public static PythonGlobal Global025;
        public static PythonGlobal Global026;
        public static PythonGlobal Global027;
        public static PythonGlobal Global028;
        public static PythonGlobal Global029;
        public static PythonGlobal Global030;
        public static PythonGlobal Global031;
        public static PythonGlobal Global032;
        public static PythonGlobal Global033;
        public static PythonGlobal Global034;
        public static PythonGlobal Global035;
        public static PythonGlobal Global036;
        public static PythonGlobal Global037;
        public static PythonGlobal Global038;
        public static PythonGlobal Global039;
        public static PythonGlobal Global040;
        public static PythonGlobal Global041;
        public static PythonGlobal Global042;
        public static PythonGlobal Global043;
        public static PythonGlobal Global044;
        public static PythonGlobal Global045;
        public static PythonGlobal Global046;
        public static PythonGlobal Global047;
        public static PythonGlobal Global048;
        public static PythonGlobal Global049;
    }
    public static class GlobalStorage004 {
        public static PythonGlobal Global000;
        public static PythonGlobal Global001;
        public static PythonGlobal Global002;
        public static PythonGlobal Global003;
        public static PythonGlobal Global004;
        public static PythonGlobal Global005;
        public static PythonGlobal Global006;
        public static PythonGlobal Global007;
        public static PythonGlobal Global008;
        public static PythonGlobal Global009;
        public static PythonGlobal Global010;
        public static PythonGlobal Global011;
        public static PythonGlobal Global012;
        public static PythonGlobal Global013;
        public static PythonGlobal Global014;
        public static PythonGlobal Global015;
        public static PythonGlobal Global016;
        public static PythonGlobal Global017;
        public static PythonGlobal Global018;
        public static PythonGlobal Global019;
        public static PythonGlobal Global020;
        public static PythonGlobal Global021;
        public static PythonGlobal Global022;
        public static PythonGlobal Global023;
        public static PythonGlobal Global024;
        public static PythonGlobal Global025;
        public static PythonGlobal Global026;
        public static PythonGlobal Global027;
        public static PythonGlobal Global028;
        public static PythonGlobal Global029;
        public static PythonGlobal Global030;
        public static PythonGlobal Global031;
        public static PythonGlobal Global032;
        public static PythonGlobal Global033;
        public static PythonGlobal Global034;
        public static PythonGlobal Global035;
        public static PythonGlobal Global036;
        public static PythonGlobal Global037;
        public static PythonGlobal Global038;
        public static PythonGlobal Global039;
        public static PythonGlobal Global040;
        public static PythonGlobal Global041;
        public static PythonGlobal Global042;
        public static PythonGlobal Global043;
        public static PythonGlobal Global044;
        public static PythonGlobal Global045;
        public static PythonGlobal Global046;
        public static PythonGlobal Global047;
        public static PythonGlobal Global048;
        public static PythonGlobal Global049;
    }
    public static class GlobalStorage005 {
        public static PythonGlobal Global000;
        public static PythonGlobal Global001;
        public static PythonGlobal Global002;
        public static PythonGlobal Global003;
        public static PythonGlobal Global004;
        public static PythonGlobal Global005;
        public static PythonGlobal Global006;
        public static PythonGlobal Global007;
        public static PythonGlobal Global008;
        public static PythonGlobal Global009;
        public static PythonGlobal Global010;
        public static PythonGlobal Global011;
        public static PythonGlobal Global012;
        public static PythonGlobal Global013;
        public static PythonGlobal Global014;
        public static PythonGlobal Global015;
        public static PythonGlobal Global016;
        public static PythonGlobal Global017;
        public static PythonGlobal Global018;
        public static PythonGlobal Global019;
        public static PythonGlobal Global020;
        public static PythonGlobal Global021;
        public static PythonGlobal Global022;
        public static PythonGlobal Global023;
        public static PythonGlobal Global024;
        public static PythonGlobal Global025;
        public static PythonGlobal Global026;
        public static PythonGlobal Global027;
        public static PythonGlobal Global028;
        public static PythonGlobal Global029;
        public static PythonGlobal Global030;
        public static PythonGlobal Global031;
        public static PythonGlobal Global032;
        public static PythonGlobal Global033;
        public static PythonGlobal Global034;
        public static PythonGlobal Global035;
        public static PythonGlobal Global036;
        public static PythonGlobal Global037;
        public static PythonGlobal Global038;
        public static PythonGlobal Global039;
        public static PythonGlobal Global040;
        public static PythonGlobal Global041;
        public static PythonGlobal Global042;
        public static PythonGlobal Global043;
        public static PythonGlobal Global044;
        public static PythonGlobal Global045;
        public static PythonGlobal Global046;
        public static PythonGlobal Global047;
        public static PythonGlobal Global048;
        public static PythonGlobal Global049;
    }
    public static class GlobalStorage006 {
        public static PythonGlobal Global000;
        public static PythonGlobal Global001;
        public static PythonGlobal Global002;
        public static PythonGlobal Global003;
        public static PythonGlobal Global004;
        public static PythonGlobal Global005;
        public static PythonGlobal Global006;
        public static PythonGlobal Global007;
        public static PythonGlobal Global008;
        public static PythonGlobal Global009;
        public static PythonGlobal Global010;
        public static PythonGlobal Global011;
        public static PythonGlobal Global012;
        public static PythonGlobal Global013;
        public static PythonGlobal Global014;
        public static PythonGlobal Global015;
        public static PythonGlobal Global016;
        public static PythonGlobal Global017;
        public static PythonGlobal Global018;
        public static PythonGlobal Global019;
        public static PythonGlobal Global020;
        public static PythonGlobal Global021;
        public static PythonGlobal Global022;
        public static PythonGlobal Global023;
        public static PythonGlobal Global024;
        public static PythonGlobal Global025;
        public static PythonGlobal Global026;
        public static PythonGlobal Global027;
        public static PythonGlobal Global028;
        public static PythonGlobal Global029;
        public static PythonGlobal Global030;
        public static PythonGlobal Global031;
        public static PythonGlobal Global032;
        public static PythonGlobal Global033;
        public static PythonGlobal Global034;
        public static PythonGlobal Global035;
        public static PythonGlobal Global036;
        public static PythonGlobal Global037;
        public static PythonGlobal Global038;
        public static PythonGlobal Global039;
        public static PythonGlobal Global040;
        public static PythonGlobal Global041;
        public static PythonGlobal Global042;
        public static PythonGlobal Global043;
        public static PythonGlobal Global044;
        public static PythonGlobal Global045;
        public static PythonGlobal Global046;
        public static PythonGlobal Global047;
        public static PythonGlobal Global048;
        public static PythonGlobal Global049;
    }
    public static class GlobalStorage007 {
        public static PythonGlobal Global000;
        public static PythonGlobal Global001;
        public static PythonGlobal Global002;
        public static PythonGlobal Global003;
        public static PythonGlobal Global004;
        public static PythonGlobal Global005;
        public static PythonGlobal Global006;
        public static PythonGlobal Global007;
        public static PythonGlobal Global008;
        public static PythonGlobal Global009;
        public static PythonGlobal Global010;
        public static PythonGlobal Global011;
        public static PythonGlobal Global012;
        public static PythonGlobal Global013;
        public static PythonGlobal Global014;
        public static PythonGlobal Global015;
        public static PythonGlobal Global016;
        public static PythonGlobal Global017;
        public static PythonGlobal Global018;
        public static PythonGlobal Global019;
        public static PythonGlobal Global020;
        public static PythonGlobal Global021;
        public static PythonGlobal Global022;
        public static PythonGlobal Global023;
        public static PythonGlobal Global024;
        public static PythonGlobal Global025;
        public static PythonGlobal Global026;
        public static PythonGlobal Global027;
        public static PythonGlobal Global028;
        public static PythonGlobal Global029;
        public static PythonGlobal Global030;
        public static PythonGlobal Global031;
        public static PythonGlobal Global032;
        public static PythonGlobal Global033;
        public static PythonGlobal Global034;
        public static PythonGlobal Global035;
        public static PythonGlobal Global036;
        public static PythonGlobal Global037;
        public static PythonGlobal Global038;
        public static PythonGlobal Global039;
        public static PythonGlobal Global040;
        public static PythonGlobal Global041;
        public static PythonGlobal Global042;
        public static PythonGlobal Global043;
        public static PythonGlobal Global044;
        public static PythonGlobal Global045;
        public static PythonGlobal Global046;
        public static PythonGlobal Global047;
        public static PythonGlobal Global048;
        public static PythonGlobal Global049;
    }
    public static class GlobalStorage008 {
        public static PythonGlobal Global000;
        public static PythonGlobal Global001;
        public static PythonGlobal Global002;
        public static PythonGlobal Global003;
        public static PythonGlobal Global004;
        public static PythonGlobal Global005;
        public static PythonGlobal Global006;
        public static PythonGlobal Global007;
        public static PythonGlobal Global008;
        public static PythonGlobal Global009;
        public static PythonGlobal Global010;
        public static PythonGlobal Global011;
        public static PythonGlobal Global012;
        public static PythonGlobal Global013;
        public static PythonGlobal Global014;
        public static PythonGlobal Global015;
        public static PythonGlobal Global016;
        public static PythonGlobal Global017;
        public static PythonGlobal Global018;
        public static PythonGlobal Global019;
        public static PythonGlobal Global020;
        public static PythonGlobal Global021;
        public static PythonGlobal Global022;
        public static PythonGlobal Global023;
        public static PythonGlobal Global024;
        public static PythonGlobal Global025;
        public static PythonGlobal Global026;
        public static PythonGlobal Global027;
        public static PythonGlobal Global028;
        public static PythonGlobal Global029;
        public static PythonGlobal Global030;
        public static PythonGlobal Global031;
        public static PythonGlobal Global032;
        public static PythonGlobal Global033;
        public static PythonGlobal Global034;
        public static PythonGlobal Global035;
        public static PythonGlobal Global036;
        public static PythonGlobal Global037;
        public static PythonGlobal Global038;
        public static PythonGlobal Global039;
        public static PythonGlobal Global040;
        public static PythonGlobal Global041;
        public static PythonGlobal Global042;
        public static PythonGlobal Global043;
        public static PythonGlobal Global044;
        public static PythonGlobal Global045;
        public static PythonGlobal Global046;
        public static PythonGlobal Global047;
        public static PythonGlobal Global048;
        public static PythonGlobal Global049;
    }
    public static class GlobalStorage009 {
        public static PythonGlobal Global000;
        public static PythonGlobal Global001;
        public static PythonGlobal Global002;
        public static PythonGlobal Global003;
        public static PythonGlobal Global004;
        public static PythonGlobal Global005;
        public static PythonGlobal Global006;
        public static PythonGlobal Global007;
        public static PythonGlobal Global008;
        public static PythonGlobal Global009;
        public static PythonGlobal Global010;
        public static PythonGlobal Global011;
        public static PythonGlobal Global012;
        public static PythonGlobal Global013;
        public static PythonGlobal Global014;
        public static PythonGlobal Global015;
        public static PythonGlobal Global016;
        public static PythonGlobal Global017;
        public static PythonGlobal Global018;
        public static PythonGlobal Global019;
        public static PythonGlobal Global020;
        public static PythonGlobal Global021;
        public static PythonGlobal Global022;
        public static PythonGlobal Global023;
        public static PythonGlobal Global024;
        public static PythonGlobal Global025;
        public static PythonGlobal Global026;
        public static PythonGlobal Global027;
        public static PythonGlobal Global028;
        public static PythonGlobal Global029;
        public static PythonGlobal Global030;
        public static PythonGlobal Global031;
        public static PythonGlobal Global032;
        public static PythonGlobal Global033;
        public static PythonGlobal Global034;
        public static PythonGlobal Global035;
        public static PythonGlobal Global036;
        public static PythonGlobal Global037;
        public static PythonGlobal Global038;
        public static PythonGlobal Global039;
        public static PythonGlobal Global040;
        public static PythonGlobal Global041;
        public static PythonGlobal Global042;
        public static PythonGlobal Global043;
        public static PythonGlobal Global044;
        public static PythonGlobal Global045;
        public static PythonGlobal Global046;
        public static PythonGlobal Global047;
        public static PythonGlobal Global048;
        public static PythonGlobal Global049;
    }
    public static class GlobalStorage010 {
        public static PythonGlobal Global000;
        public static PythonGlobal Global001;
        public static PythonGlobal Global002;
        public static PythonGlobal Global003;
        public static PythonGlobal Global004;
        public static PythonGlobal Global005;
        public static PythonGlobal Global006;
        public static PythonGlobal Global007;
        public static PythonGlobal Global008;
        public static PythonGlobal Global009;
        public static PythonGlobal Global010;
        public static PythonGlobal Global011;
        public static PythonGlobal Global012;
        public static PythonGlobal Global013;
        public static PythonGlobal Global014;
        public static PythonGlobal Global015;
        public static PythonGlobal Global016;
        public static PythonGlobal Global017;
        public static PythonGlobal Global018;
        public static PythonGlobal Global019;
        public static PythonGlobal Global020;
        public static PythonGlobal Global021;
        public static PythonGlobal Global022;
        public static PythonGlobal Global023;
        public static PythonGlobal Global024;
        public static PythonGlobal Global025;
        public static PythonGlobal Global026;
        public static PythonGlobal Global027;
        public static PythonGlobal Global028;
        public static PythonGlobal Global029;
        public static PythonGlobal Global030;
        public static PythonGlobal Global031;
        public static PythonGlobal Global032;
        public static PythonGlobal Global033;
        public static PythonGlobal Global034;
        public static PythonGlobal Global035;
        public static PythonGlobal Global036;
        public static PythonGlobal Global037;
        public static PythonGlobal Global038;
        public static PythonGlobal Global039;
        public static PythonGlobal Global040;
        public static PythonGlobal Global041;
        public static PythonGlobal Global042;
        public static PythonGlobal Global043;
        public static PythonGlobal Global044;
        public static PythonGlobal Global045;
        public static PythonGlobal Global046;
        public static PythonGlobal Global047;
        public static PythonGlobal Global048;
        public static PythonGlobal Global049;
    }
    public static class GlobalStorage011 {
        public static PythonGlobal Global000;
        public static PythonGlobal Global001;
        public static PythonGlobal Global002;
        public static PythonGlobal Global003;
        public static PythonGlobal Global004;
        public static PythonGlobal Global005;
        public static PythonGlobal Global006;
        public static PythonGlobal Global007;
        public static PythonGlobal Global008;
        public static PythonGlobal Global009;
        public static PythonGlobal Global010;
        public static PythonGlobal Global011;
        public static PythonGlobal Global012;
        public static PythonGlobal Global013;
        public static PythonGlobal Global014;
        public static PythonGlobal Global015;
        public static PythonGlobal Global016;
        public static PythonGlobal Global017;
        public static PythonGlobal Global018;
        public static PythonGlobal Global019;
        public static PythonGlobal Global020;
        public static PythonGlobal Global021;
        public static PythonGlobal Global022;
        public static PythonGlobal Global023;
        public static PythonGlobal Global024;
        public static PythonGlobal Global025;
        public static PythonGlobal Global026;
        public static PythonGlobal Global027;
        public static PythonGlobal Global028;
        public static PythonGlobal Global029;
        public static PythonGlobal Global030;
        public static PythonGlobal Global031;
        public static PythonGlobal Global032;
        public static PythonGlobal Global033;
        public static PythonGlobal Global034;
        public static PythonGlobal Global035;
        public static PythonGlobal Global036;
        public static PythonGlobal Global037;
        public static PythonGlobal Global038;
        public static PythonGlobal Global039;
        public static PythonGlobal Global040;
        public static PythonGlobal Global041;
        public static PythonGlobal Global042;
        public static PythonGlobal Global043;
        public static PythonGlobal Global044;
        public static PythonGlobal Global045;
        public static PythonGlobal Global046;
        public static PythonGlobal Global047;
        public static PythonGlobal Global048;
        public static PythonGlobal Global049;
    }
    public static class GlobalStorage012 {
        public static PythonGlobal Global000;
        public static PythonGlobal Global001;
        public static PythonGlobal Global002;
        public static PythonGlobal Global003;
        public static PythonGlobal Global004;
        public static PythonGlobal Global005;
        public static PythonGlobal Global006;
        public static PythonGlobal Global007;
        public static PythonGlobal Global008;
        public static PythonGlobal Global009;
        public static PythonGlobal Global010;
        public static PythonGlobal Global011;
        public static PythonGlobal Global012;
        public static PythonGlobal Global013;
        public static PythonGlobal Global014;
        public static PythonGlobal Global015;
        public static PythonGlobal Global016;
        public static PythonGlobal Global017;
        public static PythonGlobal Global018;
        public static PythonGlobal Global019;
        public static PythonGlobal Global020;
        public static PythonGlobal Global021;
        public static PythonGlobal Global022;
        public static PythonGlobal Global023;
        public static PythonGlobal Global024;
        public static PythonGlobal Global025;
        public static PythonGlobal Global026;
        public static PythonGlobal Global027;
        public static PythonGlobal Global028;
        public static PythonGlobal Global029;
        public static PythonGlobal Global030;
        public static PythonGlobal Global031;
        public static PythonGlobal Global032;
        public static PythonGlobal Global033;
        public static PythonGlobal Global034;
        public static PythonGlobal Global035;
        public static PythonGlobal Global036;
        public static PythonGlobal Global037;
        public static PythonGlobal Global038;
        public static PythonGlobal Global039;
        public static PythonGlobal Global040;
        public static PythonGlobal Global041;
        public static PythonGlobal Global042;
        public static PythonGlobal Global043;
        public static PythonGlobal Global044;
        public static PythonGlobal Global045;
        public static PythonGlobal Global046;
        public static PythonGlobal Global047;
        public static PythonGlobal Global048;
        public static PythonGlobal Global049;
    }
    public static class GlobalStorage013 {
        public static PythonGlobal Global000;
        public static PythonGlobal Global001;
        public static PythonGlobal Global002;
        public static PythonGlobal Global003;
        public static PythonGlobal Global004;
        public static PythonGlobal Global005;
        public static PythonGlobal Global006;
        public static PythonGlobal Global007;
        public static PythonGlobal Global008;
        public static PythonGlobal Global009;
        public static PythonGlobal Global010;
        public static PythonGlobal Global011;
        public static PythonGlobal Global012;
        public static PythonGlobal Global013;
        public static PythonGlobal Global014;
        public static PythonGlobal Global015;
        public static PythonGlobal Global016;
        public static PythonGlobal Global017;
        public static PythonGlobal Global018;
        public static PythonGlobal Global019;
        public static PythonGlobal Global020;
        public static PythonGlobal Global021;
        public static PythonGlobal Global022;
        public static PythonGlobal Global023;
        public static PythonGlobal Global024;
        public static PythonGlobal Global025;
        public static PythonGlobal Global026;
        public static PythonGlobal Global027;
        public static PythonGlobal Global028;
        public static PythonGlobal Global029;
        public static PythonGlobal Global030;
        public static PythonGlobal Global031;
        public static PythonGlobal Global032;
        public static PythonGlobal Global033;
        public static PythonGlobal Global034;
        public static PythonGlobal Global035;
        public static PythonGlobal Global036;
        public static PythonGlobal Global037;
        public static PythonGlobal Global038;
        public static PythonGlobal Global039;
        public static PythonGlobal Global040;
        public static PythonGlobal Global041;
        public static PythonGlobal Global042;
        public static PythonGlobal Global043;
        public static PythonGlobal Global044;
        public static PythonGlobal Global045;
        public static PythonGlobal Global046;
        public static PythonGlobal Global047;
        public static PythonGlobal Global048;
        public static PythonGlobal Global049;
    }
    public static class GlobalStorage014 {
        public static PythonGlobal Global000;
        public static PythonGlobal Global001;
        public static PythonGlobal Global002;
        public static PythonGlobal Global003;
        public static PythonGlobal Global004;
        public static PythonGlobal Global005;
        public static PythonGlobal Global006;
        public static PythonGlobal Global007;
        public static PythonGlobal Global008;
        public static PythonGlobal Global009;
        public static PythonGlobal Global010;
        public static PythonGlobal Global011;
        public static PythonGlobal Global012;
        public static PythonGlobal Global013;
        public static PythonGlobal Global014;
        public static PythonGlobal Global015;
        public static PythonGlobal Global016;
        public static PythonGlobal Global017;
        public static PythonGlobal Global018;
        public static PythonGlobal Global019;
        public static PythonGlobal Global020;
        public static PythonGlobal Global021;
        public static PythonGlobal Global022;
        public static PythonGlobal Global023;
        public static PythonGlobal Global024;
        public static PythonGlobal Global025;
        public static PythonGlobal Global026;
        public static PythonGlobal Global027;
        public static PythonGlobal Global028;
        public static PythonGlobal Global029;
        public static PythonGlobal Global030;
        public static PythonGlobal Global031;
        public static PythonGlobal Global032;
        public static PythonGlobal Global033;
        public static PythonGlobal Global034;
        public static PythonGlobal Global035;
        public static PythonGlobal Global036;
        public static PythonGlobal Global037;
        public static PythonGlobal Global038;
        public static PythonGlobal Global039;
        public static PythonGlobal Global040;
        public static PythonGlobal Global041;
        public static PythonGlobal Global042;
        public static PythonGlobal Global043;
        public static PythonGlobal Global044;
        public static PythonGlobal Global045;
        public static PythonGlobal Global046;
        public static PythonGlobal Global047;
        public static PythonGlobal Global048;
        public static PythonGlobal Global049;
    }
    public static class GlobalStorage015 {
        public static PythonGlobal Global000;
        public static PythonGlobal Global001;
        public static PythonGlobal Global002;
        public static PythonGlobal Global003;
        public static PythonGlobal Global004;
        public static PythonGlobal Global005;
        public static PythonGlobal Global006;
        public static PythonGlobal Global007;
        public static PythonGlobal Global008;
        public static PythonGlobal Global009;
        public static PythonGlobal Global010;
        public static PythonGlobal Global011;
        public static PythonGlobal Global012;
        public static PythonGlobal Global013;
        public static PythonGlobal Global014;
        public static PythonGlobal Global015;
        public static PythonGlobal Global016;
        public static PythonGlobal Global017;
        public static PythonGlobal Global018;
        public static PythonGlobal Global019;
        public static PythonGlobal Global020;
        public static PythonGlobal Global021;
        public static PythonGlobal Global022;
        public static PythonGlobal Global023;
        public static PythonGlobal Global024;
        public static PythonGlobal Global025;
        public static PythonGlobal Global026;
        public static PythonGlobal Global027;
        public static PythonGlobal Global028;
        public static PythonGlobal Global029;
        public static PythonGlobal Global030;
        public static PythonGlobal Global031;
        public static PythonGlobal Global032;
        public static PythonGlobal Global033;
        public static PythonGlobal Global034;
        public static PythonGlobal Global035;
        public static PythonGlobal Global036;
        public static PythonGlobal Global037;
        public static PythonGlobal Global038;
        public static PythonGlobal Global039;
        public static PythonGlobal Global040;
        public static PythonGlobal Global041;
        public static PythonGlobal Global042;
        public static PythonGlobal Global043;
        public static PythonGlobal Global044;
        public static PythonGlobal Global045;
        public static PythonGlobal Global046;
        public static PythonGlobal Global047;
        public static PythonGlobal Global048;
        public static PythonGlobal Global049;
    }
    public static class GlobalStorage016 {
        public static PythonGlobal Global000;
        public static PythonGlobal Global001;
        public static PythonGlobal Global002;
        public static PythonGlobal Global003;
        public static PythonGlobal Global004;
        public static PythonGlobal Global005;
        public static PythonGlobal Global006;
        public static PythonGlobal Global007;
        public static PythonGlobal Global008;
        public static PythonGlobal Global009;
        public static PythonGlobal Global010;
        public static PythonGlobal Global011;
        public static PythonGlobal Global012;
        public static PythonGlobal Global013;
        public static PythonGlobal Global014;
        public static PythonGlobal Global015;
        public static PythonGlobal Global016;
        public static PythonGlobal Global017;
        public static PythonGlobal Global018;
        public static PythonGlobal Global019;
        public static PythonGlobal Global020;
        public static PythonGlobal Global021;
        public static PythonGlobal Global022;
        public static PythonGlobal Global023;
        public static PythonGlobal Global024;
        public static PythonGlobal Global025;
        public static PythonGlobal Global026;
        public static PythonGlobal Global027;
        public static PythonGlobal Global028;
        public static PythonGlobal Global029;
        public static PythonGlobal Global030;
        public static PythonGlobal Global031;
        public static PythonGlobal Global032;
        public static PythonGlobal Global033;
        public static PythonGlobal Global034;
        public static PythonGlobal Global035;
        public static PythonGlobal Global036;
        public static PythonGlobal Global037;
        public static PythonGlobal Global038;
        public static PythonGlobal Global039;
        public static PythonGlobal Global040;
        public static PythonGlobal Global041;
        public static PythonGlobal Global042;
        public static PythonGlobal Global043;
        public static PythonGlobal Global044;
        public static PythonGlobal Global045;
        public static PythonGlobal Global046;
        public static PythonGlobal Global047;
        public static PythonGlobal Global048;
        public static PythonGlobal Global049;
    }
    public static class GlobalStorage017 {
        public static PythonGlobal Global000;
        public static PythonGlobal Global001;
        public static PythonGlobal Global002;
        public static PythonGlobal Global003;
        public static PythonGlobal Global004;
        public static PythonGlobal Global005;
        public static PythonGlobal Global006;
        public static PythonGlobal Global007;
        public static PythonGlobal Global008;
        public static PythonGlobal Global009;
        public static PythonGlobal Global010;
        public static PythonGlobal Global011;
        public static PythonGlobal Global012;
        public static PythonGlobal Global013;
        public static PythonGlobal Global014;
        public static PythonGlobal Global015;
        public static PythonGlobal Global016;
        public static PythonGlobal Global017;
        public static PythonGlobal Global018;
        public static PythonGlobal Global019;
        public static PythonGlobal Global020;
        public static PythonGlobal Global021;
        public static PythonGlobal Global022;
        public static PythonGlobal Global023;
        public static PythonGlobal Global024;
        public static PythonGlobal Global025;
        public static PythonGlobal Global026;
        public static PythonGlobal Global027;
        public static PythonGlobal Global028;
        public static PythonGlobal Global029;
        public static PythonGlobal Global030;
        public static PythonGlobal Global031;
        public static PythonGlobal Global032;
        public static PythonGlobal Global033;
        public static PythonGlobal Global034;
        public static PythonGlobal Global035;
        public static PythonGlobal Global036;
        public static PythonGlobal Global037;
        public static PythonGlobal Global038;
        public static PythonGlobal Global039;
        public static PythonGlobal Global040;
        public static PythonGlobal Global041;
        public static PythonGlobal Global042;
        public static PythonGlobal Global043;
        public static PythonGlobal Global044;
        public static PythonGlobal Global045;
        public static PythonGlobal Global046;
        public static PythonGlobal Global047;
        public static PythonGlobal Global048;
        public static PythonGlobal Global049;
    }
    public static class GlobalStorage018 {
        public static PythonGlobal Global000;
        public static PythonGlobal Global001;
        public static PythonGlobal Global002;
        public static PythonGlobal Global003;
        public static PythonGlobal Global004;
        public static PythonGlobal Global005;
        public static PythonGlobal Global006;
        public static PythonGlobal Global007;
        public static PythonGlobal Global008;
        public static PythonGlobal Global009;
        public static PythonGlobal Global010;
        public static PythonGlobal Global011;
        public static PythonGlobal Global012;
        public static PythonGlobal Global013;
        public static PythonGlobal Global014;
        public static PythonGlobal Global015;
        public static PythonGlobal Global016;
        public static PythonGlobal Global017;
        public static PythonGlobal Global018;
        public static PythonGlobal Global019;
        public static PythonGlobal Global020;
        public static PythonGlobal Global021;
        public static PythonGlobal Global022;
        public static PythonGlobal Global023;
        public static PythonGlobal Global024;
        public static PythonGlobal Global025;
        public static PythonGlobal Global026;
        public static PythonGlobal Global027;
        public static PythonGlobal Global028;
        public static PythonGlobal Global029;
        public static PythonGlobal Global030;
        public static PythonGlobal Global031;
        public static PythonGlobal Global032;
        public static PythonGlobal Global033;
        public static PythonGlobal Global034;
        public static PythonGlobal Global035;
        public static PythonGlobal Global036;
        public static PythonGlobal Global037;
        public static PythonGlobal Global038;
        public static PythonGlobal Global039;
        public static PythonGlobal Global040;
        public static PythonGlobal Global041;
        public static PythonGlobal Global042;
        public static PythonGlobal Global043;
        public static PythonGlobal Global044;
        public static PythonGlobal Global045;
        public static PythonGlobal Global046;
        public static PythonGlobal Global047;
        public static PythonGlobal Global048;
        public static PythonGlobal Global049;
    }
    public static class GlobalStorage019 {
        public static PythonGlobal Global000;
        public static PythonGlobal Global001;
        public static PythonGlobal Global002;
        public static PythonGlobal Global003;
        public static PythonGlobal Global004;
        public static PythonGlobal Global005;
        public static PythonGlobal Global006;
        public static PythonGlobal Global007;
        public static PythonGlobal Global008;
        public static PythonGlobal Global009;
        public static PythonGlobal Global010;
        public static PythonGlobal Global011;
        public static PythonGlobal Global012;
        public static PythonGlobal Global013;
        public static PythonGlobal Global014;
        public static PythonGlobal Global015;
        public static PythonGlobal Global016;
        public static PythonGlobal Global017;
        public static PythonGlobal Global018;
        public static PythonGlobal Global019;
        public static PythonGlobal Global020;
        public static PythonGlobal Global021;
        public static PythonGlobal Global022;
        public static PythonGlobal Global023;
        public static PythonGlobal Global024;
        public static PythonGlobal Global025;
        public static PythonGlobal Global026;
        public static PythonGlobal Global027;
        public static PythonGlobal Global028;
        public static PythonGlobal Global029;
        public static PythonGlobal Global030;
        public static PythonGlobal Global031;
        public static PythonGlobal Global032;
        public static PythonGlobal Global033;
        public static PythonGlobal Global034;
        public static PythonGlobal Global035;
        public static PythonGlobal Global036;
        public static PythonGlobal Global037;
        public static PythonGlobal Global038;
        public static PythonGlobal Global039;
        public static PythonGlobal Global040;
        public static PythonGlobal Global041;
        public static PythonGlobal Global042;
        public static PythonGlobal Global043;
        public static PythonGlobal Global044;
        public static PythonGlobal Global045;
        public static PythonGlobal Global046;
        public static PythonGlobal Global047;
        public static PythonGlobal Global048;
        public static PythonGlobal Global049;
    }

    // *** END GENERATED CODE ***

    #endregion

    #region Generated CallSite Storage

    // *** BEGIN GENERATED CODE ***
    // generated by function: gen_site_storage from: generate_UncollectableCompilationMode.py

    public static class SiteStorage<T> where T : class {
        public static int SiteCount;

        public static CallSite<T>[] Sites = new CallSite<T>[64];

        /// <summary>Ensures the underlying array is long enough to accomodate the given index</summary>
        /// <returns>The site storage type corresponding to the given index</returns>
        public static Type/*!*/ SiteStorageType(int index) {
            Debug.Assert(index >= 0);

            switch (index / StorageData.StaticFields) {
                case 000: return typeof(SiteStorage000<T>);
                case 001: return typeof(SiteStorage001<T>);
                case 002: return typeof(SiteStorage002<T>);
                case 003: return typeof(SiteStorage003<T>);
                case 004: return typeof(SiteStorage004<T>);
                case 005: return typeof(SiteStorage005<T>);
                case 006: return typeof(SiteStorage006<T>);
                case 007: return typeof(SiteStorage007<T>);
                case 008: return typeof(SiteStorage008<T>);
                case 009: return typeof(SiteStorage009<T>);
                case 010: return typeof(SiteStorage010<T>);
                case 011: return typeof(SiteStorage011<T>);
                case 012: return typeof(SiteStorage012<T>);
                case 013: return typeof(SiteStorage013<T>);
                case 014: return typeof(SiteStorage014<T>);
                case 015: return typeof(SiteStorage015<T>);
                case 016: return typeof(SiteStorage016<T>);
                case 017: return typeof(SiteStorage017<T>);
                case 018: return typeof(SiteStorage018<T>);
                case 019: return typeof(SiteStorage019<T>);
                case 020: return typeof(SiteStorage020<T>);
                case 021: return typeof(SiteStorage021<T>);
                case 022: return typeof(SiteStorage022<T>);
                case 023: return typeof(SiteStorage023<T>);
                case 024: return typeof(SiteStorage024<T>);
                case 025: return typeof(SiteStorage025<T>);
                case 026: return typeof(SiteStorage026<T>);
                case 027: return typeof(SiteStorage027<T>);
                case 028: return typeof(SiteStorage028<T>);
                case 029: return typeof(SiteStorage029<T>);

                default:
                    int len = checked(index - StorageData.StaticFields * StorageData.SiteTypes + 1);
                    if (Sites.Length < len) {
                        int newLen = Sites.Length;
                        while (newLen < len) {
                            newLen *= 2;
                        }
                        Array.Resize(ref Sites, newLen);
                    }
                    return typeof(SiteStorage<T>);
            }
        }
    }

    public static class SiteStorage000<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage001<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage002<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage003<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage004<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage005<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage006<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage007<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage008<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage009<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage010<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage011<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage012<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage013<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage014<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage015<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage016<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage017<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage018<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage019<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage020<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage021<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage022<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage023<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage024<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage025<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage026<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage027<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage028<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    public static class SiteStorage029<T> where T : class {
        public static CallSite<T> Site000;
        public static CallSite<T> Site001;
        public static CallSite<T> Site002;
        public static CallSite<T> Site003;
        public static CallSite<T> Site004;
        public static CallSite<T> Site005;
        public static CallSite<T> Site006;
        public static CallSite<T> Site007;
        public static CallSite<T> Site008;
        public static CallSite<T> Site009;
        public static CallSite<T> Site010;
        public static CallSite<T> Site011;
        public static CallSite<T> Site012;
        public static CallSite<T> Site013;
        public static CallSite<T> Site014;
        public static CallSite<T> Site015;
        public static CallSite<T> Site016;
        public static CallSite<T> Site017;
        public static CallSite<T> Site018;
        public static CallSite<T> Site019;
        public static CallSite<T> Site020;
        public static CallSite<T> Site021;
        public static CallSite<T> Site022;
        public static CallSite<T> Site023;
        public static CallSite<T> Site024;
        public static CallSite<T> Site025;
        public static CallSite<T> Site026;
        public static CallSite<T> Site027;
        public static CallSite<T> Site028;
        public static CallSite<T> Site029;
        public static CallSite<T> Site030;
        public static CallSite<T> Site031;
        public static CallSite<T> Site032;
        public static CallSite<T> Site033;
        public static CallSite<T> Site034;
        public static CallSite<T> Site035;
        public static CallSite<T> Site036;
        public static CallSite<T> Site037;
        public static CallSite<T> Site038;
        public static CallSite<T> Site039;
        public static CallSite<T> Site040;
        public static CallSite<T> Site041;
        public static CallSite<T> Site042;
        public static CallSite<T> Site043;
        public static CallSite<T> Site044;
        public static CallSite<T> Site045;
        public static CallSite<T> Site046;
        public static CallSite<T> Site047;
        public static CallSite<T> Site048;
        public static CallSite<T> Site049;
    }

    // *** END GENERATED CODE ***

    #endregion
}
#endif
