// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.

using System;
using System.Collections.Generic;
using Microsoft.Scripting;

namespace IronPython.Compiler {

    [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "Dedent")]
    public enum TokenKind {
        EndOfFile = -1,
        Error = 0,
        NewLine = 1,
        Indent = 2,
        Dedent = 3,
        Comment = 4,
        Name = 8,
        Constant = 9,
        Dot = 31,

        #region Generated Token Kinds

        // *** BEGIN GENERATED CODE ***
        // generated by function: tokenkinds_generator from: generate_ops.py

        Add = 32,
        AddEqual = 33,
        Subtract = 34,
        SubtractEqual = 35,
        Power = 36,
        PowerEqual = 37,
        Multiply = 38,
        MultiplyEqual = 39,
        FloorDivide = 40,
        FloorDivideEqual = 41,
        Divide = 42,
        DivideEqual = 43,
        Mod = 44,
        ModEqual = 45,
        LeftShift = 46,
        LeftShiftEqual = 47,
        RightShift = 48,
        RightShiftEqual = 49,
        BitwiseAnd = 50,
        BitwiseAndEqual = 51,
        BitwiseOr = 52,
        BitwiseOrEqual = 53,
        ExclusiveOr = 54,
        ExclusiveOrEqual = 55,
        LessThan = 56,
        GreaterThan = 57,
        LessThanOrEqual = 58,
        GreaterThanOrEqual = 59,
        Equals = 60,
        NotEquals = 61,
        LessThanGreaterThan = 62,
        LeftParenthesis = 63,
        RightParenthesis = 64,
        LeftBracket = 65,
        RightBracket = 66,
        LeftBrace = 67,
        RightBrace = 68,
        Comma = 69,
        Colon = 70,
        BackQuote = 71,
        Semicolon = 72,
        Assign = 73,
        Twiddle = 74,
        At = 75,

        FirstKeyword = KeywordAnd,
        LastKeyword = KeywordWith,
        KeywordAnd = 76,
        KeywordAssert = 77,
        KeywordBreak = 78,
        KeywordClass = 79,
        KeywordContinue = 80,
        KeywordDef = 81,
        KeywordDel = 82,
        KeywordElseIf = 83,
        KeywordElse = 84,
        KeywordExcept = 85,
        KeywordExec = 86,
        KeywordFinally = 87,
        KeywordFor = 88,
        KeywordFrom = 89,
        KeywordGlobal = 90,
        KeywordIf = 91,
        KeywordImport = 92,
        KeywordIn = 93,
        KeywordIs = 94,
        KeywordLambda = 95,
        KeywordNot = 96,
        KeywordOr = 97,
        KeywordPass = 98,
        KeywordPrint = 99,
        KeywordRaise = 100,
        KeywordReturn = 101,
        KeywordTry = 102,
        KeywordWhile = 103,
        KeywordYield = 104,
        KeywordAs = 105,
        KeywordWith = 106,

        // *** END GENERATED CODE ***

        #endregion

        NLToken,
    }

    public static class Tokens {
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes")]
        public static readonly Token EndOfFileToken = new SymbolToken(TokenKind.EndOfFile, "<eof>");
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes")]
        public static readonly Token NewLineToken = new SymbolToken(TokenKind.NewLine, "<newline>");
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes")]
        public static readonly Token NLToken = new SymbolToken(TokenKind.NLToken, "<NL>");  // virtual token used for error reporting
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes")]
        public static readonly Token IndentToken = new SymbolToken(TokenKind.Indent, "<indent>");

        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes")]
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "Dedent")]
        public static readonly Token DedentToken = new SymbolToken(TokenKind.Dedent, "<dedent>");
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes")]
        public static readonly Token CommentToken = new SymbolToken(TokenKind.Comment, "<comment>");
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes")]
        public static readonly Token NoneToken = new ConstantValueToken(null);

        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Security", "CA2104:DoNotDeclareReadOnlyMutableReferenceTypes")]
        public static readonly Token DotToken = new SymbolToken(TokenKind.Dot, ".");

        #region Generated Tokens

        // *** BEGIN GENERATED CODE ***
        // generated by function: tokens_generator from: generate_ops.py

        public static Token AddToken { get; } = new OperatorToken(TokenKind.Add, "+", 4);
        public static Token AddEqualToken { get; } = new SymbolToken(TokenKind.AddEqual, "+=");
        public static Token SubtractToken { get; } = new OperatorToken(TokenKind.Subtract, "-", 4);
        public static Token SubtractEqualToken { get; } = new SymbolToken(TokenKind.SubtractEqual, "-=");
        public static Token PowerToken { get; } = new OperatorToken(TokenKind.Power, "**", 6);
        public static Token PowerEqualToken { get; } = new SymbolToken(TokenKind.PowerEqual, "**=");
        public static Token MultiplyToken { get; } = new OperatorToken(TokenKind.Multiply, "*", 5);
        public static Token MultiplyEqualToken { get; } = new SymbolToken(TokenKind.MultiplyEqual, "*=");
        public static Token FloorDivideToken { get; } = new OperatorToken(TokenKind.FloorDivide, "//", 5);
        public static Token FloorDivideEqualToken { get; } = new SymbolToken(TokenKind.FloorDivideEqual, "//=");
        public static Token DivideToken { get; } = new OperatorToken(TokenKind.Divide, "/", 5);
        public static Token DivideEqualToken { get; } = new SymbolToken(TokenKind.DivideEqual, "/=");
        public static Token ModToken { get; } = new OperatorToken(TokenKind.Mod, "%", 5);
        public static Token ModEqualToken { get; } = new SymbolToken(TokenKind.ModEqual, "%=");
        public static Token LeftShiftToken { get; } = new OperatorToken(TokenKind.LeftShift, "<<", 3);
        public static Token LeftShiftEqualToken { get; } = new SymbolToken(TokenKind.LeftShiftEqual, "<<=");
        public static Token RightShiftToken { get; } = new OperatorToken(TokenKind.RightShift, ">>", 3);
        public static Token RightShiftEqualToken { get; } = new SymbolToken(TokenKind.RightShiftEqual, ">>=");
        public static Token BitwiseAndToken { get; } = new OperatorToken(TokenKind.BitwiseAnd, "&", 2);
        public static Token BitwiseAndEqualToken { get; } = new SymbolToken(TokenKind.BitwiseAndEqual, "&=");
        public static Token BitwiseOrToken { get; } = new OperatorToken(TokenKind.BitwiseOr, "|", 0);
        public static Token BitwiseOrEqualToken { get; } = new SymbolToken(TokenKind.BitwiseOrEqual, "|=");
        public static Token ExclusiveOrToken { get; } = new OperatorToken(TokenKind.ExclusiveOr, "^", 1);
        public static Token ExclusiveOrEqualToken { get; } = new SymbolToken(TokenKind.ExclusiveOrEqual, "^=");
        public static Token LessThanToken { get; } = new OperatorToken(TokenKind.LessThan, "<", -1);
        public static Token GreaterThanToken { get; } = new OperatorToken(TokenKind.GreaterThan, ">", -1);
        public static Token LessThanOrEqualToken { get; } = new OperatorToken(TokenKind.LessThanOrEqual, "<=", -1);
        public static Token GreaterThanOrEqualToken { get; } = new OperatorToken(TokenKind.GreaterThanOrEqual, ">=", -1);
        public static Token EqualsToken { get; } = new OperatorToken(TokenKind.Equals, "==", -1);
        public static Token NotEqualsToken { get; } = new OperatorToken(TokenKind.NotEquals, "!=", -1);
        public static Token LessThanGreaterThanToken { get; } = new SymbolToken(TokenKind.LessThanGreaterThan, "<>");
        public static Token LeftParenthesisToken { get; } = new SymbolToken(TokenKind.LeftParenthesis, "(");
        public static Token RightParenthesisToken { get; } = new SymbolToken(TokenKind.RightParenthesis, ")");
        public static Token LeftBracketToken { get; } = new SymbolToken(TokenKind.LeftBracket, "[");
        public static Token RightBracketToken { get; } = new SymbolToken(TokenKind.RightBracket, "]");
        public static Token LeftBraceToken { get; } = new SymbolToken(TokenKind.LeftBrace, "{");
        public static Token RightBraceToken { get; } = new SymbolToken(TokenKind.RightBrace, "}");
        public static Token CommaToken { get; } = new SymbolToken(TokenKind.Comma, ",");
        public static Token ColonToken { get; } = new SymbolToken(TokenKind.Colon, ":");
        public static Token BackQuoteToken { get; } = new SymbolToken(TokenKind.BackQuote, "`");
        public static Token SemicolonToken { get; } = new SymbolToken(TokenKind.Semicolon, ";");
        public static Token AssignToken { get; } = new SymbolToken(TokenKind.Assign, "=");
        public static Token TwiddleToken { get; } = new SymbolToken(TokenKind.Twiddle, "~");
        public static Token AtToken { get; } = new SymbolToken(TokenKind.At, "@");

        public static Token KeywordAndToken { get; } = new SymbolToken(TokenKind.KeywordAnd, "and");
        public static Token KeywordAsToken { get; } = new SymbolToken(TokenKind.KeywordAs, "as");
        public static Token KeywordAssertToken { get; } = new SymbolToken(TokenKind.KeywordAssert, "assert");
        public static Token KeywordBreakToken { get; } = new SymbolToken(TokenKind.KeywordBreak, "break");
        public static Token KeywordClassToken { get; } = new SymbolToken(TokenKind.KeywordClass, "class");
        public static Token KeywordContinueToken { get; } = new SymbolToken(TokenKind.KeywordContinue, "continue");
        public static Token KeywordDefToken { get; } = new SymbolToken(TokenKind.KeywordDef, "def");
        public static Token KeywordDelToken { get; } = new SymbolToken(TokenKind.KeywordDel, "del");
        public static Token KeywordElseIfToken { get; } = new SymbolToken(TokenKind.KeywordElseIf, "elif");
        public static Token KeywordElseToken { get; } = new SymbolToken(TokenKind.KeywordElse, "else");
        public static Token KeywordExceptToken { get; } = new SymbolToken(TokenKind.KeywordExcept, "except");
        public static Token KeywordExecToken { get; } = new SymbolToken(TokenKind.KeywordExec, "exec");
        public static Token KeywordFinallyToken { get; } = new SymbolToken(TokenKind.KeywordFinally, "finally");
        public static Token KeywordForToken { get; } = new SymbolToken(TokenKind.KeywordFor, "for");
        public static Token KeywordFromToken { get; } = new SymbolToken(TokenKind.KeywordFrom, "from");
        public static Token KeywordGlobalToken { get; } = new SymbolToken(TokenKind.KeywordGlobal, "global");
        public static Token KeywordIfToken { get; } = new SymbolToken(TokenKind.KeywordIf, "if");
        public static Token KeywordImportToken { get; } = new SymbolToken(TokenKind.KeywordImport, "import");
        public static Token KeywordInToken { get; } = new SymbolToken(TokenKind.KeywordIn, "in");
        public static Token KeywordIsToken { get; } = new SymbolToken(TokenKind.KeywordIs, "is");
        public static Token KeywordLambdaToken { get; } = new SymbolToken(TokenKind.KeywordLambda, "lambda");
        public static Token KeywordNotToken { get; } = new SymbolToken(TokenKind.KeywordNot, "not");
        public static Token KeywordOrToken { get; } = new SymbolToken(TokenKind.KeywordOr, "or");
        public static Token KeywordPassToken { get; } = new SymbolToken(TokenKind.KeywordPass, "pass");
        public static Token KeywordPrintToken { get; } = new SymbolToken(TokenKind.KeywordPrint, "print");
        public static Token KeywordRaiseToken { get; } = new SymbolToken(TokenKind.KeywordRaise, "raise");
        public static Token KeywordReturnToken { get; } = new SymbolToken(TokenKind.KeywordReturn, "return");
        public static Token KeywordTryToken { get; } = new SymbolToken(TokenKind.KeywordTry, "try");
        public static Token KeywordWhileToken { get; } = new SymbolToken(TokenKind.KeywordWhile, "while");
        public static Token KeywordWithToken { get; } = new SymbolToken(TokenKind.KeywordWith, "with");
        public static Token KeywordYieldToken { get; } = new SymbolToken(TokenKind.KeywordYield, "yield");

        // *** END GENERATED CODE ***

        #endregion
    }
}
