/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 */

package com.jcg.executesqlscriptspringjdbc;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.jdbc.datasource.init.ScriptUtils;

/**
 *
 * @author omozegieaziegbe
 */
public class ExecuteSQLScriptSpringJDBC {

    public static void main(String[] args) throws Exception {
        
        //Database URL
        String url = "jdbc:mysql://localhost:3306/studentDatabase";

        //Register the Driver
        Class.forName("com.mysql.cj.jdbc.Driver");
        
        // Establish a MySQL database connection
        String username = "username";
        String password = "password";
        Connection connection = DriverManager.getConnection(url, username, password);
        
        System.out.println("Establishing Connection.....");
        
        // Define the path to the SQL script file
        // Update the path as needed
        String path = new File(ClassLoader.getSystemClassLoader().getResource("students-script.sql").getFile()).toPath().toString();
        //File file = new File("/Users/omozegieaziegbe/Development/students-script.sql");
        
        Resource resource = new FileSystemResource(path);
        EncodedResource encodedresource = new EncodedResource(resource);
        
        connection.setAutoCommit(false);
        
        // Execute the SQL script
        ScriptUtils.executeSqlScript(connection, encodedresource);
        connection.setAutoCommit(true);

        connection.close();

        System.out.println("Database Tables Created");
    }
}
