/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 */
package com.jcg.executesqlscriptjdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.io.*;
import java.sql.SQLException;
import java.sql.Statement;

/**
 *
 * @author omozegieaziegbe
 */
public class ExecuteSQLScriptJDBC {

    public static void main(String[] args) throws Exception {

        //Register the Driver
        Class.forName("com.mysql.cj.jdbc.Driver");

        // Establish a MySQL database connection
        String jdbcUrl = "jdbc:mysql://localhost:3306/studentDatabase";
        String username = "username";
        String password = "password";
        try {
            Connection connection = DriverManager.getConnection(jdbcUrl, username, password);

            // Define the path to the SQL script file
            // Update the path as needed
            String script = readSQLScript("/Users/omozegieaziegbe/Development/students-script.sql");
            executeScript(connection, script);

            //Close the connection
            connection.close();
            //Handle Exceptions
        } catch (SQLException | IOException e) {
            e.printStackTrace();
        }

    }

    // Read the SQL Script File
    public static String readSQLScript(String filePath) throws IOException {
        StringBuilder script = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath))) {
            String line;
            while ((line = reader.readLine()) != null) {
                script.append(line).append("\n");
            }
        }
        return script.toString();
    }

    //Execute the SQL Script File
    public static void executeScript(Connection connection, String script) throws SQLException {
        try (Statement statement = connection.createStatement()) {
            String[] sqlCommands = script.split(";");
            for (String sqlCommand : sqlCommands) {
                if (!sqlCommand.trim().isEmpty()) {
                    statement.addBatch(sqlCommand);
                }
            }
            statement.executeBatch();
        }
    }

}
