package com.javacodegeeks.core.string;

import java.util.Arrays;

public class StringSplitExample {

	public static void main(String[] args) {

		String str = "abdc124psdv456sdvos456dv568dfpbk0dd";

		// split the array using a single digit, e.g 1,2,3...
		String[] parts = str.split("[0-9]");
		System.out.println(Arrays.toString(parts));

		// split the array using a whole number, e.g 12,346,756
		parts = str.split("[0-9]+");
		System.out.println(Arrays.toString(parts));

		System.out.println("Split string using operators :");
		// split the string using series of operators
		String input = "test,java,code-geek@java8?split.example";
		String[] strOutput = input.split("[,-?.@]+");
		for (String s : strOutput)
			System.out.println(s);

		System.out.println("Split string using ^ :");
		// split the string using ^
		String input2 = "Java^CodeGeeks";
		String strOutput2[] = input2.split("\\^");
		for (String s : strOutput2)
			System.out.println(s);

		splitExample();
		splitLimitExample();

	}

	public static void splitExample() {

		String str = "abdc:psdv:sdvosdv:dfpbkdd";

		// split the array using ':' as a delimiter
		String[] parts = str.split(":");

		System.out.println("Using : as a delimiter " + Arrays.toString(parts));

		// split the array using 'd' as a delimiter
		parts = str.split("d");
		System.out.println(Arrays.toString(parts));

		String str2 = "This is a string to tokenize";

		// tokenize the string into words simply by splitting with " "
		parts = str2.split(" ");
		System.out.println(Arrays.toString(parts));
	}

	public static void splitLimitExample() {

		String str = "abdc:psdv:sdvosdv:dfpbkdd";

		String[] part0Limits = str.split(":", 0);

		System.out.println("Using : as a delimiter with limit 0 " + Arrays.toString(part0Limits));

		String[] part1Limits = str.split(":", 2);
		System.out.println("Using : as a delimiter with limit 1 " + Arrays.toString(part1Limits));

		String[] part5Limits = str.split(":", 5);
		System.out.println("Using : as a delimiter with limit 5 " + Arrays.toString(part5Limits));

		String[] partNegativeLimits = str.split(":", -2);
		System.out.println("Using : as a delimiter with negative limit " + Arrays.toString(partNegativeLimits));

	}

}
