﻿#include "opencvfr.h"
#include "external/httplib.h"
#include "external/json.hpp"

#include <opencv2/imgcodecs.hpp>
#include <iostream>
#include <fstream>
#include <math.h>
#include <typeinfo>
#include <exception>
#include <bitset>
#include <iomanip>
using namespace std;
using json = nlohmann::json;


int main()
{
    

    SDK sdk{ "sg.api7cloud.com","_01COf_LZDA3ODdjNmYtOGM2MC00NmZmLTg3MmYtMTAyZjNjO_Sample",443 }; 
    
    Options op_person;
    op_person.skip = 0;
    op_person.take = 20;
    op_person.order = SortOrder::ASCENDING;
    PersonCount PC = sdk.persons.list(op_person);


    //std::vector<Person> all_person;
    Options op;
    op.take = 50;
    try {
        
        PersonCount all_person = sdk.persons.list(op);
        if (all_person.persons.size() != 0)
        {
            cout << "There are " << all_person.persons.size() << " persons\n";
            int count = 0;
            for (int i = 0; i < all_person.persons.size(); ++i) {

                try {
                    cout << all_person.persons[i].id<<"  "<<all_person.persons[i].name << "\n";
                    string id = sdk.persons.delete_person(all_person.persons[i].id);
                    count++;
                }
                catch (ErrorAPI error) {
                    cout << error.status;
                }
            }
            cout << " all persons (" << count << " ) deleted\n";
        }
        cout << "No person to delete\n";
    }
    catch (ErrorAPI error) {
        cout << error.status;
    }

    CollectionCount all_collection;
    //options op;
    op.take = 50;

    try {
        all_collection = sdk.collections.list(op);
        cout << "\nThere are " << all_collection.collection.size() << " in DB\n";
        int count = 0;
        for (int i = 0; i < all_collection.collection.size(); ++i) {

            try {
                cout << all_collection.collection[i].id << "  " << all_collection.collection[i].name<<" "<<all_collection.collection[i].description << "\n";
                string id = sdk.collections.delete_collection(all_collection.collection[i].id);
                count++;
            }
            catch (ErrorAPI error) {
                cout << error.status;
            }

        }
        cout << " all collections (" << count << " ) deleted\n";
    }
    catch (ErrorAPI error) {
        cout << error.status;
    }
    cout << "ALL PERSONS AND COLLECTIONS DELETED";
  
    return 0;
}



