rm -rf build &&

# Download and unpack OpenCV sources
wget -O opencv.zip https://github.com/opencv/opencv/archive/refs/tags/4.5.2.zip &&
unzip opencv.zip &&
rm opencv.zip &&

# Create build directory and switch into it
mkdir -p build && cd build &&
# Configure
cmake -DCMAKE_SKIP_BUILD_RPATH=1 \
      -DCMAKE_INSTALL_PREFIX=../include/opencv \
      -DWITH_QT=OFF -DWITH_GTK=OFF \
      -DWITH_MKL=1 \
      -DBUILD_opencv_python3=OFF \
      -DBUILD_opencv_python2=OFF \
      -DBUILD_TESTS=OFF \
      -DBUILD_PERF_TESTS=OFF \
      -DBUILD_EXAMPLES=OFF \
      -DBUILD_opencv_apps=OFF \
      -DWITH_OPENGL=OFF \
      -DWITH_V4L=OFF ../opencv-4.5.2 &&

# Build
make -j $(nproc) &&
make install && cd .. &&
rm -rf opencv-4.5.2 &&
rm -rf build &&

# Download and unpack Gtest sources
wget -O gtest.zip https://github.com/google/googletest/archive/refs/tags/release-1.12.0.zip &&
unzip gtest.zip &&
rm gtest.zip &&

# Create build directory and switch into it
mkdir -p build && cd build &&

cmake -DBUILD_SHARED_LIBS=OFF \
      -DCMAKE_INSTALL_PREFIX=../include/gtest ../googletest-release-1.12.0 &&

make -j $(nproc) &&
make install && cd .. &&
rm -rf googletest-release-1.12.0 &&
rm -rf build

#Build API7 Test
mkdir -p build && cd build &&
cmake .. && make && cd .. &&
rm -rf build