/*
  ==============================================================================

   This file is part of the JUCE tutorials.
   Copyright (c) 2020 - Raw Material Software Limited

   The code included in this file is provided under the terms of the ISC license
   http://www.isc.org/downloads/software-support-policy/isc-license. Permission
   To use, copy, modify, and/or distribute this software for any purpose with or
   without fee is hereby granted provided that the above copyright notice and
   this permission notice appear in all copies.

   THE SOFTWARE IS PROVIDED "AS IS" WITHOUT ANY WARRANTY, AND ALL WARRANTIES,
   WHETHER EXPRESSED OR IMPLIED, INCLUDING MERCHANTABILITY AND FITNESS FOR
   PURPOSE, ARE DISCLAIMED.

  ==============================================================================
*/

/*******************************************************************************
 The block below describes the properties of this PIP. A PIP is a short snippet
 of code that can be read by the Projucer and used to generate a JUCE project.

 BEGIN_JUCE_PIP_METADATA

 name:             BigIntegerTutorial
 version:          1.0.0
 vendor:           JUCE
 website:          http://juce.com
 description:      Explores big integer use cases.

 dependencies:     juce_core, juce_data_structures, juce_events, juce_graphics,
                   juce_gui_basics
 exporters:        xcode_mac, vs2019, linux_make, xcode_iphone, androidstudio

 type:             Component
 mainClass:        MainContentComponent

 useLocalCopy:     1

 END_JUCE_PIP_METADATA

*******************************************************************************/


#pragma once

//==============================================================================
class MainContentComponent   : public juce::Component
{
public:
    MainContentComponent()
    {
        addAndMakeVisible (consoleBox);
        consoleBox.setMultiLine (true);
        consoleBox.setReturnKeyStartsNewLine (true);
        consoleBox.setReadOnly (true);
        consoleBox.setScrollbarsShown (true);
        consoleBox.setCaretVisible (false);
        consoleBox.setPopupMenuEnabled (true);
        consoleBox.setColour (juce::TextEditor::backgroundColourId, juce::Colour (0x32ffffff));
        consoleBox.setColour (juce::TextEditor::outlineColourId, juce::Colour (0x1c000000));
        consoleBox.setColour (juce::TextEditor::shadowColourId, juce::Colour (0x16000000));

        setSize (1200, 400);

        runExample();
    }

    void resized() override
    {
        consoleBox.setBounds (10, 10, getWidth() - 20, getHeight() - 20);
    }

private:
//! [runExample]
    void runExample()
    {
        logMessage ("------------------------- START --------------------------");

        int base = 10;
        juce::BigInteger bigInt = 11;

        for (auto iteration = 0; iteration < 100; ++iteration)
        {
            logMessage (bigInt.toString (base));

            bigInt *= 11;
        }

        logMessage ("----------------------- FINISHED -------------------------");
    }
//! [runExample]

    void logMessage (const juce::String& m)
    {
        consoleBox.moveCaretToEnd();
        consoleBox.insertTextAtCaret (m + juce::newLine);
    }

    //==============================================================================
    juce::TextEditor consoleBox;

    //==============================================================================
    JUCE_DECLARE_NON_COPYABLE_WITH_LEAK_DETECTOR (MainContentComponent)
};
