<?php
define('WP_INSTALLING', true);

if (!file_exists('../wp-config-sample.php'))
    die('Jeg skal desv&aelig;rre bruge en wp-config-sample.php-fil, for at komme videre. Gen-upload venligst denne fil fra din WordPress-installation.');

$configFile = file('../wp-config-sample.php');

if (!is_writable('../')) die("Jeg kan desv&aelig;rre ikke skrive til mappen. Du bliver n&oslash;dt til at &aelig;ndre rettighederne for din WordPress-mappe eller lave wp-config.php manuelt.");


if (isset($_GET['step']))
	$step = $_GET['step'];
else
	$step = 0;
header( 'Content-Type: text/html; charset=utf-8' );
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>WordPress &rsaquo; Setup konfigurationsfil</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<style media="screen" type="text/css">
	<!--
	html {
		background: #eee;
	}
	body {
		background: #fff;
		color: #000;
		font-family: Georgia, "Times New Roman", Times, serif;
		margin-left: 20%;
		margin-right: 20%;
		padding: .2em 2em;
	}

	h1 {
		color: #006;
		font-size: 18px;
		font-weight: lighter;
	}

	h2 {
		font-size: 16px;
	}

	p, li, dt {
		line-height: 140%;
		padding-bottom: 2px;
	}

	ul, ol {
		padding: 5px 5px 5px 20px;
	}
	#logo {
		margin-bottom: 2em;
	}
	.step a, .step input {
		font-size: 2em;
	}
	td input {
		font-size: 1.5em;
	}
	.step, th {
		text-align: right;
	}
	#footer {
		text-align: center;
		border-top: 1px solid #ccc;
		padding-top: 1em;
		font-style: italic;
	}
	-->
	</style>
</head>
<body>
<h1 id="logo"><img alt="WordPress" src="images/wordpress-logo.png" /></h1>
<?php
// Check if wp-config.php has been created
if (file_exists('../wp-config.php'))
	die("<p>Filen 'wp-config.php' eksisterer allerede. Hvis du skal lave nogle af konfigurationsindstillingerne i denne fil om, skal du slette den f&oslash;rst. Du kan pr&oslash;ve at <a href='install.php'>installere nu</a>.</p></body></html>");

switch($step) {
	case 0:
?>

<p>Velkommen til WordPress. F&oslash;r vi starter, skal vi have nogle informationer om databasen. Du skal bruge f&oslash;lgende ting, f&oslash;r vi g&aring;r videre:</p> 
<ol> 
  <li>Databasenavn</li> 
  <li>Databasebrugernavn</li> 
  <li>Databasekodeord</li> 
  <li>Databasehost</li> 
  <li>Tabelpr&aelig;fiks (hvis du vil k&oslash;re mere end &eacute;n WordPress-blog i samme database) </li>
</ol> 
<p><strong>Hvis denne automatiske fildannelse ikke virker af en eller anden grund, skal du ikke bekymre dig. Det eneste den g&oslash;r, er at fylde databaseinformationer ind i en konfigurationsfil. Du kan ogs&aring; bare &aring;bne <code>wp-config-sample.php</code> i en teksteditor, udfylde dine informationer, og gemme som <code>wp-config.php</code>. </strong></p>
<p>Du har temmelig sikkert f&aring;et disse informationer af dit webhotel. Hvis du ikke har informationerne, skal du kontakte dem, f&oslash;r vi kan forts&aelig;tte. Hvis du er klar, s&aring; <a href="setup-config.php?step=1">lad os rulle</a>!</p>
<?php
	break;

	case 1:
	?>
</p>
<form method="post" action="setup-config.php?step=2">
	<p>Nedenfor skal du indtaste dine databasedetaljer. Hvis du ikke kender dem, skal du kontakte dit webhotel. </p>
	<table>
		<tr>
			<th scope="row">Databasenavn</th>
			<td><input name="dbname" type="text" size="25" value="wordpress" /></td>
			<td>Navnet p&aring; den database du vil k&oslash;re WP i.</td> 
		</tr>
		<tr>
			<th scope="row">Brugernavn</th>
			<td><input name="uname" type="text" size="25" value="brugernavn" /></td>
			<td>Dit brugernavn til MySQL</td>
		</tr>
		<tr>
			<th scope="row">Kodeord</th>
			<td><input name="pwd" type="text" size="25" value="kodeord" /></td>
			<td>...og dit kodeord til MySQL.</td>
		</tr>
		<tr>
			<th scope="row">Database Host</th>
			<td><input name="dbhost" type="text" size="25" value="localhost" /></td>
			<td>Med 99% sikkerhed skal du ikke &aelig;ndre noget her.</td> 
		</tr>
		<tr>
			<th scope="row">Tabelpr&aelig;fiks</th>
			<td><input name="prefix" type="text" id="prefix" value="wp_" size="25" /></td>
			<td>Hvis du vil k&oslash;re flere WordPress-blogs i samme database, skal du bruge forskellige pr&aelig;fiks.</td>
		</tr>
	</table>
	<h2 class="step">
	<input name="submit" type="submit" value="Send" />
	</h2>
</form>
<?php
	break;

	case 2:
	$dbname  = trim($_POST['dbname']);
	$uname   = trim($_POST['uname']);
	$passwrd = trim($_POST['pwd']);
	$dbhost  = trim($_POST['dbhost']);
	$prefix  = trim($_POST['prefix']);
	if (empty($prefix)) $prefix = 'wp_';

	// Test the db connection.
	define('DB_NAME', $dbname);
	define('DB_USER', $uname);
	define('DB_PASSWORD', $passwrd);
	define('DB_HOST', $dbhost);

	// Her g&aring;r det galt, hvis v&aelig;rdierne ikke passer.
	require_once('../wp-includes/wp-db.php');
	$handle = fopen('../wp-config.php', 'w');

	foreach ($configFile as $line_num => $line) {
		switch (substr($line,0,16)) {
			case "define('DB_NAME'":
				fwrite($handle, str_replace("skrivdatabasenavnher", $dbname, $line));
				break;
			case "define('DB_USER'":
				fwrite($handle, str_replace("'skrivbrugernavnher'", "'$uname'", $line));
				break;
			case "define('DB_PASSW":
				fwrite($handle, str_replace("'skrivkodeordher'", "'$passwrd'", $line));
				break;
			case "define('DB_HOST'":
				fwrite($handle, str_replace("localhost", $dbhost, $line));
				break;
			case '$table_prefix  =':
				fwrite($handle, str_replace('wp_', $prefix, $line));
				break;
			default:
				fwrite($handle, $line);
		}
	}
	fclose($handle);
	chmod('../wp-config.php', 0666);
?>
<p>S&aring;dan, Mester. S&aring; langt s&aring; godt. WordPress kan nu kommunikere med databasen. Hvis du er klar, s&aring; er tiden kommet til at <a href="install.php">k&oslash;re installeringen!</a></p> 
<?php
	break;
}
?>
<p id="footer"><a href="http://wordpress.org/">WordPress</a>, personlig udgivelsesplatform.</p>
</body>
</html>
