import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

public class StudentManager {
    private List<Student> students = new ArrayList<>();
    private Logger logger= Logger.getLogger(StudentManager.class);
    public StudentManager(){
        logger.debug("inside default constructor");
    }
    public  void addStudent(String firstname, String lastname, String grade) throws StudentException {
        Student student = new Student(firstname, lastname, grade);
        students.add(student);
    }

    @Override
    public String toString() {
        if(null!=students && !students.isEmpty()) {
            logger.debug("generating and returning the student output");
            StringBuilder sb = new StringBuilder();
            double totalGrade = 0;
            for (Student student : students) {
                sb.append(student.toString());
                sb.append("\n");
                totalGrade += student.getGrade();
            }
            sb.append("\nAverage class grade: " + (totalGrade / students.size()));
            return sb.toString();
        }
        return "";
    }
}
