/**
 * Implementation of the Student class
 */
public class Student {
    private String firstname;
    private String lastname;
    private double grade;

    public Student(String firstname, String lastname, String grade) throws StudentException {
        setGrade(grade);
        setFirstname(firstname);
        setLastname(lastname);
    }

    public String getFirstname() {
        return firstname;
    }

    public void setFirstname(String firstname) throws StudentException {
        if (null == firstname || firstname.trim().isEmpty())
            throw new StudentException("First Name cannot be blank");
        this.firstname = firstname;
    }

    public String getLastname() {
        return lastname;
    }

    public void setLastname(String lastname) throws StudentException {
        if (null == lastname || lastname.trim().isEmpty())
            throw new StudentException("Last Name cannot be blank");
        this.lastname = lastname;
    }

    public double getGrade() {
        return grade;
    }

    public void setGrade(String gradeStr) throws StudentException {
        if (null == gradeStr || gradeStr.trim().isEmpty())
            throw new StudentException("empty string");
        try {
            double grade = Double.valueOf(gradeStr);
            if (Double.compare(grade, 0) < 0)
                throw new StudentException("Grade must be positive");
            if (Double.compare(grade, 100) >= 1)
                throw new StudentException("Grade must be <=100");
            this.grade = grade;
        }catch (NumberFormatException nfe){
            throw new StudentException(nfe.getMessage());
        }
    }

    @Override
    public String toString() {
        return "Student{firstName='" + firstname + "\', lastName='" + lastname + "\', grade=" + grade+"}";
    }
}
