import org.apache.log4j.Logger;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

public class PanelGui extends JPanel {
    private Logger logger= Logger.getLogger(PanelGui.class);

    private JTextField firstNameField;
    private JTextField lastNameField;
    private JTextField gradeField;
    private JButton addButton;
    private JButton showButton;
    private JTextArea messageTextArea;
    private JPanel panel;
    private StudentManager studentManager;
    public PanelGui() {
        logger.debug("instanciating the widgets");
        studentManager=new StudentManager();
        panel = new JPanel();
        panel.setLayout(new GridLayout(1, 9));
        setLayout(new BorderLayout());
        firstNameField = new JTextField();
        lastNameField = new JTextField();
        gradeField = new JTextField();
        logger.debug("configuring the buttons");
        addButton = new JButton("Add");
        showButton = new JButton("Show");
        addButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                logger.debug("handling the button clicks");
                logger.debug("attempting to add the student to the manager");
                String firstName=firstNameField.getText();
                String lastName=lastNameField.getText();
                String grade=gradeField.getText();
                String message="";
                try {
                    studentManager.addStudent(firstName,
                            lastName,
                            grade);
                    message="Student is added successfully";
                    logger.debug(message);
                } catch (StudentException ex) {
                    logger.error(ex.getMessage());
                    message=ex.getMessage();
                }
                messageTextArea.setText(message);
                messageTextArea.revalidate();
                messageTextArea.repaint();
            }
        });

        showButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                logger.debug("handling the button clicks");
                    logger.debug("about to show the students");
                    messageTextArea.setText(studentManager.toString());
                    messageTextArea.revalidate();
                    messageTextArea.repaint();
            }
        });
        messageTextArea = new JTextArea();
        panel.add(new JLabel("FirstName:"));
        panel.add(firstNameField);
        panel.add(new JLabel("LastName:"));
        panel.add(lastNameField);
        panel.add(new JLabel("Grade:"));
        panel.add(gradeField);
        panel.add(addButton);
        panel.add(showButton);
        add(panel,BorderLayout.NORTH);
        add(messageTextArea,BorderLayout.CENTER);
    }


}
