# NimblePress

**Contributors:** Codebard  
**Requires at least:** 4.5
**Tested up to:** WordPress 6.4 
**Requires PHP:** 7.4

**License:** GNU General Public License v2 or later  
**License URI:** https://www.gnu.org/licenses/old-licenses/gpl-2.0.en.html

NimblePress is a fast, lightweight, mobile-first, desktop compatible, modern, easy to use theme that works out of the box.

## Description

NimblePress is a very fast and lightweight theme that gets 100 points at Google Page Speed Insights. See its scores at https://nimblepress-demo.codebard.com/2024/01/29/lightning-fast/ or test https://nimblepress-demo.codebard.com.

It combines speed, ease of use, compatibility and customizability into a modern, lightweight and clean package. It works out of the box without needing any customization and if you want, you can customize all aspects of it extensively. Works with page builders.

Speed up your website with NimblePress and boost your performance & user experience at the same time. 

## Installation

1. In your admin panel, go to Appearance > Themes and click the Add New button.
2. Click Upload Theme and Choose File, then select the theme's .zip file. Click Install Now.
3. Click Activate to use your new theme right away.
 

## Frequently Asked Questions

* Does it support Gutenberg & blocks?
 
Yes

* Does it support page builders?
 
It works with all page builders

* Does this theme support any plugins?
 
NimblePress includes support for WooCommerce and for Infinite Scroll in Jetpack.

## Copyright

NimblePress WordPress Theme, Copyright 2024 Codebard.com
NimblePress is distributed under the terms of the GNU GPL

Twenty Seventeen bundles the following third-party resources:

Image for theme screenshot, Credit Codebard
License: CC0 1.0 Universal (CC0 1.0)

Image for arrow up icon from Dashicons, Credit WordPress
**License:**: GPL
Source: https://icon-sets.iconify.design/dashicons/arrow-up-alt2/

Image for arrow down icon from Dashicons, Credit WordPress
**License:**: GPL
Source: https://icon-sets.iconify.design/dashicons/arrow-down-alt2/

## Changelog

### 1.1.2

Better loading of block css when its inlined to avoid any compatibility issues and prevent other css depending on it from being broken or not loading

### 1.1.1

List bullets/numbers were standing outside the content. This is now fixed and list bulled will not poke out of their container
Fixed a small PHP warning
Added a small margin on top of post navigation so it wont stick at the bottom of the post lists or post content

### 1.1.0

Added font size customizations for body text, heading (H1-H6), heading link, nav menu link, widget heading, widget text
Added Button font customization
Added text transformation (uppercase, lowercase etc) for nav menu links

### 1.0.9

Read more button link color was bugged and they appeared in link color instead of the defined color. This is now fixed

### 1.0.8

Fixed issue with nav menu getting squashed in some sites when in customizer
Made mobile nav menu responsive - now it stays to top right if logo is small and device has enough width to save header height
Fixed a css property that did not have a value and semicolon
Footer widget size now auto-scales depending on its content
Made site info shrink and wrap to accommodate long site names
Fixed some link buttons not getting styled by button styling
Added link color, link hover color and text decoration customization
Added in-entry, in-widget link color, hover color and text decoration customization
Added heading link color, hover color and text decoration customization
Added footer link color, hover color customization
Added footer text color customization

### 1.0.7

Added header actions
Moved head scripts to head action
Added upsell link in customizer per theme repo rules
Now also inlines block styles and makes them non-render blocking and fast-loading
Added action to render the sidebar with filter to show/hide per page/post
Added a menu page
Added tutorial and manual links to menu page
Index, archive, search moved to their own content templates
Added header, sidebar, footer instert hooks

### 1.0.6

New version to make the description appear and also get around the trac issue

### 1.0.5

Corrected the screenshot to the repo-rules-compatible version

### 1.0.4

Header menu and mobile menu fixes
Some compatibility additions

### 1.0.3

Initial release

## Credits ==

Based on Underscores https://underscores.me/, (C) 2012-2020 Automattic, Inc., [GPLv2 or later](https://www.gnu.org/licenses/gpl-2.0.html)
normalize.css https://necolas.github.io/normalize.css/, (C) 2012-2018 Nicolas Gallagher and Jonathan Neal, [MIT](https://opensource.org/licenses/MIT)