<#include "header.ftl">

<div class="w-section clj-content-section">
  <div class="w-container">
    <#include "eventsnav.ftl">

    <div class="clj-content-container">
      <h2>${content.title}</h2>

      ${content.body}

      <ul class="w-list-unstyled clj-home-updates-list">
        <#list events?sort_by("start") as event>
          <#assign starttime = (event.start + " 12:00:00")?datetime("yyyy-MM-dd hh:mm:ss")>
          <#assign endtime = (event.end + " 23:59:00")?datetime("yyyy-MM-dd hh:mm:ss")>
          <#if (event.status == "published" && .now <= endtime)>
            <li><span class="clj-events-date">${starttime?string("yyyy-MM-dd")}</span>
                &nbsp;<a href="/${event.uri}"><#escape x as x?xml>${event.title}</#escape></a></li>
          </#if>
        </#list>
      </ul>

      <h2>Recent Events</h2>
      <ul class="w-list-unstyled clj-home-updates-list">
        <#assign c = 0>
        <#list events?sort_by("start")?reverse as event>
          <#assign starttime = (event.start + " 12:00:00")?datetime("yyyy-MM-dd hh:mm:ss")>
          <#assign endtime = (event.end + " 23:59:00")?datetime("yyyy-MM-dd hh:mm:ss")>
          <#if (event.status == "published" && .now > endtime)>
            <li><span class="clj-events-date">${starttime?string("yyyy-MM-dd")}</span>
                &nbsp;<a href="/${event.uri}"><#escape x as x?xml>${event.title}</#escape></a></li>
            <#assign c =  c + 1>
            <#if (c >= 8)>
              <#break>
            </#if>
          </#if>
        </#list>
      </ul>

      <h2>Clojure Calendar</h2>

      <p>These events are sourced from the <a href="https://clojurians.zulipchat.com/#narrow/stream/262224-events/topic/README">Clojure events calendar</a>.</p>
      <ul class="w-list-unstyled clj-home-updates-list">
        <li><a href="https://gitlab.com/clojurians-zulip/feeds/-/tree/master#announce-an-event">Add an event</a></li>
        <li><a href="https://invertisment.gitlab.io/cljcalendar/">Web calendar view</a></li>
        <li><a href="https://www.clojurians-zulip.org/feeds/events.ics">Calendar link (.ics)</a></li>
      </ul>

    </div>
  </div>
</div>

<#include "footer.ftl">

