<?php
// log_category_visit.php
header('Content-Type: application/json; charset=UTF-8');
require_once __DIR__ . '/connect.php'; // $mysql = new mysqli(...)

// ---------- Helpers ----------
function get_client_ip() {
    if (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) return $_SERVER['HTTP_CF_CONNECTING_IP'];
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $parts = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
        return trim($parts[0]);
    }
    return $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
}
function get_country_code() {
    if (!empty($_SERVER['HTTP_CF_IPCOUNTRY']) && strlen($_SERVER['HTTP_CF_IPCOUNTRY']) === 2) {
        return strtoupper($_SERVER['HTTP_CF_IPCOUNTRY']);
    }
    return 'UN';
}
function inet_pton_safe($ip) {
    $packed = @inet_pton($ip);
    if ($packed === false) return inet_pton('0.0.0.0');
    return $packed;
}

// ---------- Inputs ----------
$category_id = isset($_REQUEST['category_id']) ? intval($_REQUEST['category_id']) : 0;
$channel_id  = isset($_REQUEST['channel_id'])  ? intval($_REQUEST['channel_id'])  : 0;

// لو مبعوت channel_id هنستخرج منه category_id
if ($category_id <= 0 && $channel_id > 0) {
    $q = $mysql->prepare("SELECT category FROM channel WHERE id=? LIMIT 1");
    $q->bind_param("i", $channel_id);
    $q->execute();
    $res = $q->get_result();
    if ($row = $res->fetch_assoc()) {
        // بافتراض أن channel.category = category_id
        $category_id = intval($row['category']);
    }
    $q->close();
}

if ($category_id <= 0) {
    http_response_code(400);
    echo json_encode(['ok'=>false,'error'=>'category_id is required (or valid channel_id)']);
    exit;
}

// (اختياري) التأكد من وجود القسم
$chk = $mysql->prepare("SELECT id FROM category WHERE id=?");
$chk->bind_param("i", $category_id);
$chk->execute();
$chk->store_result();
if ($chk->num_rows === 0) {
    $chk->close();
    http_response_code(404);
    echo json_encode(['ok'=>false,'error'=>'category not found']);
    exit;
}
$chk->close();

// ---------- Upsert ----------
$visit_date   = date('Y-m-d');
$ip_str       = get_client_ip();
$packed_ip    = inet_pton_safe($ip_str);
$country_code = get_country_code();

$sql = "
INSERT INTO category_country_daily_visits
  (visit_date, category_id, country_code, ip_address, visit_count)
VALUES
  (?, ?, ?, ?, 1)
ON DUPLICATE KEY UPDATE
  visit_count = visit_count + 1,
  updated_at = CURRENT_TIMESTAMP
";
$stmt = $mysql->prepare($sql);
$stmt->bind_param("sisb", $visit_date, $category_id, $country_code, $packed_ip);
$ok = $stmt->execute();
$err = $ok ? null : $mysql->error;
$stmt->close();

echo json_encode(['ok'=>$ok,'error'=>$err]);
