<?php
// category_visits_report.php
session_start();
// لو عايز تقفله بالدخول:
// if(!isset($_SESSION['username'])) { header('Location: /dashboard/login.php'); exit; }

require_once __DIR__ . '/connect.php';

$date = isset($_REQUEST['date']) ? $_REQUEST['date'] : date('Y-m-d');
$category_id = isset($_REQUEST['category_id']) ? intval($_REQUEST['category_id']) : 0;
$sort = isset($_REQUEST['sort']) ? $_REQUEST['sort'] : 'unique_desc'; // unique_desc | total_desc | name_asc

// جلب قائمة الأقسام لعرضها واستخدام أسمائها
$cats = [];
$resC = $mysql->query("SELECT id, name FROM category ORDER BY name ASC");
while ($r = $resC->fetch_assoc()) { $cats[(int)$r['id']] = $r['name']; }
$resC->close();

// ===== Mode A: Overview (كل الأقسام) =====
if ($category_id <= 0) {
    $stmt = $mysql->prepare("
        SELECT category_id,
               COUNT(DISTINCT ip_address) AS unique_visitors,
               COALESCE(SUM(visit_count),0) AS total_visits
        FROM category_country_daily_visits
        WHERE visit_date=?
        GROUP BY category_id
    ");
    $stmt->bind_param("s", $date);
    $stmt->execute();
    $res = $stmt->get_result();

    $rows = [];
    while ($row = $res->fetch_assoc()) {
        $cid = (int)$row['category_id'];
        $rows[] = [
            'category_id' => $cid,
            'category_name' => $cats[$cid] ?? ('#'.$cid),
            'unique_visitors' => (int)$row['unique_visitors'],
            'total_visits' => (int)$row['total_visits'],
        ];
    }
    $stmt->close();

    // ترتيب
    usort($rows, function($a,$b) use($sort){
        if ($sort==='name_asc') return strnatcasecmp($a['category_name'],$b['category_name']);
        if ($sort==='total_desc') return $b['total_visits'] <=> $a['total_visits'] ?: ($b['unique_visitors'] <=> $a['unique_visitors']);
        return $b['unique_visitors'] <=> $a['unique_visitors'] ?: ($b['total_visits'] <=> $a['total_visits']);
    });

    // تجهيز الدونات (Top 10 أقسام حسب الزوار الفريدين)
    $labels=[]; $values=[];
    foreach (array_slice($rows,0,10) as $r) { $labels[]=$r['category_name']; $values[]=$r['unique_visitors']; }

} else {
    // ===== Mode B: Detail (قسم معيّن → دول) =====
    $stmt = $mysql->prepare("
        SELECT country_code,
               COUNT(DISTINCT ip_address) AS unique_visitors,
               COALESCE(SUM(visit_count),0) AS total_visits
        FROM category_country_daily_visits
        WHERE visit_date=? AND category_id=?
        GROUP BY country_code
    ");
    $stmt->bind_param("si", $date, $category_id);
    $stmt->execute();
    $res = $stmt->get_result();

    $rows = [];
    while ($row = $res->fetch_assoc()) {
        $cc = strtoupper($row['country_code'] ?? 'UN');
        $rows[] = [
            'country_code' => $cc,
            'unique_visitors' => (int)$row['unique_visitors'],
            'total_visits' => (int)$row['total_visits'],
        ];
    }
    $stmt->close();

    // ترتيب
    usort($rows, function($a,$b) use($sort){
        if ($sort==='total_desc') return $b['total_visits'] <=> $a['total_visits'] ?: ($b['unique_visitors'] <=> $a['unique_visitors']);
        return $b['unique_visitors'] <=> $a['unique_visitors'] ?: ($b['total_visits'] <=> $a['total_visits']);
    });

    // دونات: الدول Top 10
    $labels=[]; $values=[];
    foreach (array_slice($rows,0,10) as $r) { $labels[]=$r['country_code']; $values[]=$r['unique_visitors']; }
}

$mysql->close();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>تقرير زيارات الأقسام حسب الدولة</title>
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/3.5.0/css/flag-icon.min.css">
<style>
  body{font-family:'Tajawal',sans-serif;margin:0;background:#f7f8fa;color:#333}
  .container{max-width:1100px;margin:30px auto;background:#fff;padding:20px;border-radius:12px;box-shadow:0 10px 25px rgba(0,0,0,.07)}
  h1{margin:0 0 14px}
  .filters{display:flex;gap:8px;align-items:center;flex-wrap:wrap;margin-bottom:10px}
  input,select,button{padding:10px;border:1px solid #ddd;border-radius:8px}
  button{background:#202020;color:#fff;cursor:pointer}
  button:hover{opacity:.9}
  table{width:100%;border-collapse:collapse;margin-top:12px}
  th,td{padding:12px;border-bottom:1px solid #eee;text-align:right}
  th{background:#202020;color:#fff}
  .flag{margin-left:8px}
  .back{display:inline-block;margin-top:8px;text-decoration:none}
  .summary{display:grid;grid-template-columns:1fr 1fr;gap:12px;margin:16px 0}
  .card{background:#202020;color:#fff;border-radius:10px;padding:18px;text-align:center}
  .card h3{margin:0 0 6px;font-size:16px}
  .card p{margin:0;font-size:28px;font-weight:700}
  canvas{max-width:100%;height:360px;margin-top:16px}
</style>
</head>
<body>
<div class="container">
  <h1><?= $category_id>0 ? 'تفاصيل القسم حسب الدولة' : 'تقرير الأقسام — اليوم المختار' ?></h1>

  <form class="filters" method="get">
    <label>التاريخ:</label>
    <input type="date" name="date" value="<?= htmlspecialchars($date); ?>">
    <?php if ($category_id>0): ?>
      <input type="hidden" name="category_id" value="<?= (int)$category_id; ?>">
      <strong><?= htmlspecialchars($cats[$category_id] ?? ('#'.$category_id)); ?></strong>
      <a class="back" href="?date=<?= urlencode($date) ?>">&larr; رجوع للأقسام</a>
    <?php else: ?>
      <label>الترتيب:</label>
      <select name="sort">
        <option value="unique_desc" <?= $sort==='unique_desc'?'selected':''; ?>>الأكثر زوارًا (فريد)</option>
        <option value="total_desc"  <?= $sort==='total_desc'?'selected':''; ?>>الأكثر زيارات</option>
        <option value="name_asc"    <?= $sort==='name_asc'?'selected':''; ?>>الاسم (أ-ي)</option>
      </select>
      <button type="submit">تحديث</button>
    <?php endif; ?>
  </form>

  <?php if ($category_id<=0): ?>
    <table>
      <thead>
        <tr>
          <th>القسم</th>
          <th>الزوار الفريدين</th>
          <th>إجمالي الزيارات</th>
          <th>تفاصيل</th>
        </tr>
      </thead>
      <tbody>
        <?php if (empty($rows)): ?>
          <tr><td colspan="4" style="text-align:center;color:#888">لا توجد بيانات لهذا اليوم.</td></tr>
        <?php else: foreach ($rows as $r): ?>
          <tr>
            <td><?= htmlspecialchars($r['category_name']); ?></td>
            <td><?= (int)$r['unique_visitors']; ?></td>
            <td><?= (int)$r['total_visits']; ?></td>
            <td><a href="?date=<?= urlencode($date) ?>&category_id=<?= (int)$r['category_id'] ?>">عرض حسب الدولة</a></td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>

    <canvas id="chart"></canvas>

  <?php else: ?>
    <table>
      <thead>
        <tr>
          <th>الدولة</th>
          <th>الزوار الفريدين</th>
          <th>إجمالي الزيارات</th>
        </tr>
      </thead>
      <tbody>
        <?php if (empty($rows)): ?>
          <tr><td colspan="3" style="text-align:center;color:#888">لا توجد بيانات لهذا اليوم.</td></tr>
        <?php else: foreach ($rows as $r):
            $ccLower = strtolower($r['country_code']);
        ?>
          <tr>
            <td>
              <span class="flag flag-icon flag-icon-<?= htmlspecialchars($ccLower); ?>"></span>
              <?= htmlspecialchars($r['country_code']); ?>
            </td>
            <td><?= (int)$r['unique_visitors']; ?></td>
            <td><?= (int)$r['total_visits']; ?></td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>

    <canvas id="chart"></canvas>
  <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
  const labels = <?= json_encode(array_column($rows, $category_id>0?'country_code':'category_name'), JSON_UNESCAPED_UNICODE) ?>;
  const values = <?= json_encode(array_column($rows, 'unique_visitors'), JSON_UNESCAPED_UNICODE) ?>;

  const ctx = document.getElementById('chart').getContext('2d');
  new Chart(ctx, {
    type: 'doughnut',
    data: {
      labels: labels,
      datasets: [{ label: 'زوار فريدين', data: values, borderWidth: 1 }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { position:'top' },
        title: {
          display: true,
          text: <?= json_encode(
            ($category_id>0)
              ? ('أكثر الدول زيارة لقسم: '.($cats[$category_id] ?? ('#'.$category_id))." — {$date}")
              : ("أكثر الأقسام زيارة — {$date}")
          , JSON_UNESCAPED_UNICODE) ?>
        }
      }
    }
  });
</script>
</body>
</html>
