<?php
session_start();

// التحقق من تسجيل الدخول
if(!isset($_SESSION['username'])) {
    // إعادة التوجيه إلى صفحة تسجيل الدخول إذا لم يتم تسجيل الدخول بعد
    header('Location: https://akomov.com/dashboard/login.php');
    exit();
}

// استرجاع بيانات المستخدم المسجل الحالي
$username = $_SESSION['username'];
$phone = $_SESSION['phone'];
$name = $_SESSION['name'];

include "connect.php"; // الاتصال بقاعدة البيانات

// تحديد التاريخ إذا تم إرساله من الاستعلام POST، وإلا تعيينه بالتاريخ الحالي
$date = isset($_POST['date']) ? $_POST['date'] : date('Y-m-d');
$sort_option = isset($_POST['sort_option']) ? $_POST['sort_option'] : 'visitors_count';

// الحصول على عدد الزوار اليومي الفريد بناءً على الـ IP
$sql_unique_visitors = "SELECT COUNT(DISTINCT ip_address) AS unique_visitors_today FROM category_daily_visits WHERE visit_date = '$date'";
$result_unique_visitors = $mysql->query($sql_unique_visitors);
$row_unique_visitors = $result_unique_visitors->fetch_assoc();
$unique_visitors_today = $row_unique_visitors['unique_visitors_today'];

// الحصول على عدد الزوار الإجمالي اليومي (عدد الزيارات)
$sql_total_visits = "SELECT SUM(visit_count) AS total_visits_today FROM category_daily_visits WHERE visit_date = '$date'";
$result_total_visits = $mysql->query($sql_total_visits);
$row_total_visits = $result_total_visits->fetch_assoc();
$total_visits_today = $row_total_visits['total_visits_today'];

// الحصول على توزيع الزوار حسب الدولة
$order_by_clause = $sort_option == 'country' ? 'country' : 'visitors_count DESC';
$sql_visitors_by_country = "SELECT country, COUNT(DISTINCT ip_address) AS visitors_count FROM category_daily_visits WHERE visit_date = '$date' GROUP BY country ORDER BY $order_by_clause";
$result_visitors_by_country = $mysql->query($sql_visitors_by_country);

// إعداد بيانات الزوار حسب الدول
$visitors_by_country = array();
while ($row_country = $result_visitors_by_country->fetch_assoc()) {
    $visitors_by_country[] = $row_country;
}

$mysql->close();
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تحليل الزوار</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/3.5.0/css/flag-icon.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <style>
        body {
            font-family: 'Tajawal', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f7f8fa;
            color: #333;
        }
        .container {
            max-width: 900px;
            margin: 50px auto;
            padding: 20px;
            background-color: #fff;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
            border-radius: 10px;
            text-align: center;
        }
        .btn {
            padding: 10px 20px;
            border-radius: 5px;
            background-color: #202020;
            color: #fff;
            border: none;
            cursor: pointer;
            transition: background-color 0.3s;
            font-family: 'Tajawal', sans-serif;
        }
        .btn:hover {
            background-color: #0056b3;
        }
        label {
            font-size: 18px;
            margin-right: 10px;
        }
        #date {
            font-size: 16px;
            padding: 10px;
            border-radius: 5px;
            border: 1px solid #ccc;
            margin: 0 10px;
            display: none; /* إخفاء حقل التاريخ */
        }
        h1, h2 {
            text-align: center;
            color: #202020;
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            padding: 15px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        th {
            background-color: #202020;
            color: #fff;
            position: relative;
        }
        .flag-icon {
            margin-right: 10px;
        }
        .summary {
            display: flex;
            justify-content: space-around;
            margin-top: 20px;
        }
        .summary div {
            background-color: #202020;
            color: #fff;
            padding: 20px;
            border-radius: 8px;
            text-align: center;
            width: 45%;
        }
        .summary div h2 {
            margin: 0;
            font-size: 24px;
            color: #fff;
        }
        .summary div p {
            margin: 0;
            font-size: 36px;
            font-weight: bold;
            color: #fff;
        }
        tbody tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        .sort-icons {
            cursor: pointer;
            margin-left: 10px;
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
        }
        .date-navigation {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-top: 20px;
        }
        .date-navigation button {
            margin: 0 10px;
            background: none;
            border: none;
            font-size: 20px;
            cursor: pointer;
        }
        .date-navigation button i {
            color: #202020;
        }
        .date-display {
            font-size: 18px;
            margin: 0 10px;
            cursor: pointer;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>تحليل الزوار</h1>
        <form method="post" action="">
            <div class="date-navigation">
                <button type="button" onclick="navigateDate(-1)">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <label for="date" class="date-display" id="date-label">
                    <i class="fas fa-calendar-alt"></i> <span id="displayed-date"><?php echo $date; ?></span>
                </label>
                <input type="date" id="date" name="date" value="<?php echo $date; ?>">
                <button type="button" onclick="navigateDate(1)">
                    <i class="fas fa-chevron-right"></i>
                </button>
            </div>
            <input type="hidden" id="sort_option" name="sort_option" value="<?php echo $sort_option; ?>">
        </form>
        <div class="summary">
            <div>
                <h2>الزوار الفريدين اليوم</h2>
                <p><?php echo $unique_visitors_today; ?></p>
            </div>
            <div>
                <h2>إجمالي الزيارات اليوم</h2>
                <p><?php echo $total_visits_today; ?></p>
            </div>
        </div>
        <canvas id="myChart" width="400" height="400"></canvas>
        <h2>توزيع الزوار حسب الدولة</h2>
        <table>
            <thead>
                <tr>
                    <th>الدولة
                        <span class="sort-icons" onclick="sortTable('country')">&#127758;</span>
                    </th>
                    <th>عدد الزوار
                        <span class="sort-icons" onclick="sortTable('visitors_count')">&#x1F4C8;</span>
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($visitors_by_country as $country_data): ?>
                    <tr>
                        <td>
                            <span class="flag-icon flag-icon-<?php echo strtolower($country_data['country']); ?>"></span>
                            <?php echo $country_data['country']; ?>
                        </td>
                        <td><?php echo $country_data['visitors_count']; ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        $(document).ready(function() {
            // تفعيل أداة اختيار التاريخ عند الضغط على أيقونة التقويم
            $("#date-label").click(function() {
                $("#date").datepicker({
                    dateFormat: 'yy-mm-dd',
                    onSelect: function(dateText) {
                        $("#date").val(dateText);
                        $("form").submit();
                    }
                }).datepicker("show");
            });
        });

        function navigateDate(direction) {
            var currentDate = new Date($("#date").val());
            currentDate.setDate(currentDate.getDate() + direction);
            var newDate = currentDate.toISOString().split('T')[0];
            $("#date").val(newDate);
            $("#displayed-date").text(newDate);
            $("form").submit();
        }

        // إنشاء الرسم البياني
        var ctx = document.getElementById('myChart').getContext('2d');
        var myChart = new Chart(ctx, {
            type: 'doughnut', // تحديد النوع للرسم البياني الدائري
            data: {
                labels: [<?php foreach ($visitors_by_country as $country_data): ?>"<?php echo $country_data['country']; ?>",<?php endforeach; ?>],
                datasets: [{
                    label: 'عدد الزوار',
                    data: [<?php foreach ($visitors_by_country as $country_data): ?><?php echo $country_data['visitors_count']; ?>,<?php endforeach; ?>],
                    backgroundColor: [
                        'rgba(255, 99, 132, 0.5)',
                        'rgba(54, 162, 235, 0.5)',
                        'rgba(255, 206, 86, 0.5)',
                        'rgba(75, 192, 192, 0.5)',
                        'rgba(153, 102, 255, 0.5)',
                        'rgba(255, 159, 64, 0.5)'
                        // يمكنك إضافة مزيد من الألوان حسب الحاجة
                    ],
                    borderColor: [
                        'rgba(255, 99, 132, 1)',
                        'rgba(54, 162, 235, 1)',
                        'rgba(255, 206, 86, 1)',
                        'rgba(75, 192, 192, 1)',
                        'rgba(153, 102, 255, 1)',
                        'rgba(255, 159, 64, 1)'
                        // يمكنك إضافة مزيد من الألوان حسب الحاجة
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: 'top',
                    },
                    title: {
                        display: true,
                        text: 'رسم بياناتي لتوزيع الزوار حسب الدولة',
                        font: {
                            family: 'Tajawal, sans-serif', // تحديد الخط هنا
                            size: 18 // حجم الخط هنا
                        }
                    }
                }
            }
        });

        // دالة لتحديث ترتيب الجدول
        function sortTable(sortOption) {
            document.getElementById('sort_option').value = sortOption;
            document.forms[0].submit();
        }
    </script>
</body>
</html>
