<?php
require_once __DIR__ . '/connect.php';

function is_int_like($v){ return ctype_digit((string)$v); }

$category_id = $_GET['category_id'] ?? ($_POST['category_id'] ?? '');
if ($category_id === '') { http_response_code(400); echo 'category_id مطلوب'; exit; }

$date = $_POST['date'] ?? date('Y-m-d');

// اسم القسم
if (is_int_like($category_id)) {
    $cid = (int)$category_id;
    $stmt = $mysql->prepare("SELECT name FROM category WHERE id=?");
    $stmt->bind_param("i", $cid);
} else {
    $cid = (string)$category_id;
    $stmt = $mysql->prepare("SELECT name FROM category WHERE id=?");
    $stmt->bind_param("s", $cid);
}
$stmt->execute();
$nameRes = $stmt->get_result();
$rowName = $nameRes->fetch_assoc();
$category_name = $rowName['name'] ?? ('#'.$category_id);
$stmt->close();

// تجميع حسب الدولة
if (is_int_like($category_id)) {
    $q = $mysql->prepare("
        SELECT country_code,
               COUNT(DISTINCT ip_address) AS unique_visitors,
               COALESCE(SUM(visit_count),0) AS total_visits
        FROM category_country_daily_visits
        WHERE visit_date=? AND category_id=?
        GROUP BY country_code
        ORDER BY unique_visitors DESC, total_visits DESC
    ");
    $q->bind_param("si", $date, $cid);
} else {
    $q = $mysql->prepare("
        SELECT country_code,
               COUNT(DISTINCT ip_address) AS unique_visitors,
               COALESCE(SUM(visit_count),0) AS total_visits
        FROM category_country_daily_visits
        WHERE visit_date=? AND category_id=?
        GROUP BY country_code
        ORDER BY unique_visitors DESC, total_visits DESC
    ");
    $q->bind_param("ss", $date, $cid);
}
$q->execute();
$res = $q->get_result();

$data = [];
$unique_sum = 0; $total_sum = 0;
while ($r = $res->fetch_assoc()) {
    $cc = strtoupper($r['country_code'] ?? 'UN');
    $u  = (int)$r['unique_visitors'];
    $t  = (int)$r['total_visits'];
    $unique_sum += $u; $total_sum += $t;
    $data[] = ['country_code'=>$cc, 'unique'=>$u, 'total'=>$t];
}
$q->close();
$mysql->close();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>تقرير قسم: <?= htmlspecialchars($category_name) ?></title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/3.5.0/css/flag-icon.min.css">
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;700&display=swap" rel="stylesheet">
<style>
  body{font-family:'Tajawal',sans-serif;margin:0;background:#f7f8fa;color:#333}
  .wrap{max-width:900px;margin:30px auto;background:#fff;padding:18px;border-radius:12px;box-shadow:0 10px 25px rgba(0,0,0,.07)}
  h1{margin:0 0 8px}
  .filters{display:flex;gap:10px;align-items:center;flex-wrap:wrap;margin:10px 0}
  input,button{padding:10px;border:1px solid #ddd;border-radius:8px}
  button{background:#202020;color:#fff;cursor:pointer}
  button:hover{opacity:.9}
  .summary{display:grid;grid-template-columns:1fr 1fr;gap:12px;margin:12px 0}
  .card{background:#202020;color:#fff;border-radius:10px;padding:16px;text-align:center}
  .card h3{margin:0 0 6px;font-size:16px}
  .card p{margin:0;font-weight:700;font-size:28px}
  table{width:100%;border-collapse:collapse;margin-top:10px}
  th,td{padding:12px;border-bottom:1px solid #eee;text-align:right}
  th{background:#202020;color:#fff}
  .flag{margin-left:8px}
  a{color:#202020;text-decoration:none}
</style>
</head>
<body>
<div class="wrap">
  <a href="categories.php">&larr; رجوع لقائمة الأقسام</a>
  <h1>تقرير الزيارات — قسم: <?= htmlspecialchars($category_name) ?></h1>

  <form method="post" class="filters">
    <input type="hidden" name="category_id" value="<?= htmlspecialchars($category_id); ?>">
    <label>التاريخ:</label>
    <input type="date" name="date" value="<?= htmlspecialchars($date); ?>">
    <button type="submit">تحديث</button>
  </form>

  <div class="summary">
    <div class="card">
      <h3>إجمالي الزوار الفريدين اليوم</h3>
      <p><?= (int)$unique_sum; ?></p>
    </div>
    <div class="card">
      <h3>إجمالي الزيارات اليوم</h3>
      <p><?= (int)$total_sum; ?></p>
    </div>
  </div>

  <table>
    <thead>
      <tr>
        <th>الدولة</th>
        <th>عدد الزوار الفريدين</th>
        <th>إجمالي الزيارات</th>
      </tr>
    </thead>
    <tbody>
      <?php if (empty($data)): ?>
        <tr><td colspan="3" style="text-align:center;color:#888">لا توجد بيانات لهذا التاريخ.</td></tr>
      <?php else: foreach ($data as $row):
        $ccLower = strtolower($row['country_code']);
      ?>
        <tr>
          <td>
            <span class="flag flag-icon flag-icon-<?= htmlspecialchars($ccLower); ?>"></span>
            <?= htmlspecialchars($row['country_code']); ?>
          </td>
          <td><?= (int)$row['unique']; ?></td>
          <td><?= (int)$row['total']; ?></td>
        </tr>
      <?php endforeach; endif; ?>
    </tbody>
  </table>
</div>
</body>
</html>
