<?php
// categories.php
require_once __DIR__ . '/connect.php';

// جلب الأقسام
$sql = "SELECT id, name, photo, category_e, maintenance FROM category ORDER BY name ASC";
$res = $mysql->query($sql);

$cats = [];
if ($res && $res->num_rows > 0) {
    while ($row = $res->fetch_assoc()) {
        $cats[] = $row;
    }
}
if ($res) $res->close();
$mysql->close();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>الأقسام</title>
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;700&display=swap" rel="stylesheet">
<style>
  :root{--bg:#f7f8fa;--card:#fff;--text:#222;--muted:#666;--ok:#0a6;--bad:#c00;}
  *{box-sizing:border-box}
  body{margin:0;background:var(--bg);color:var(--text);font-family:'Tajawal',sans-serif}
  .wrap{max-width:1100px;margin:32px auto;padding:0 12px}
  h1{margin:0 0 14px;font-size:22px}
  .grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(220px,1fr));gap:14px}
  .card{background:var(--card);border-radius:12px;box-shadow:0 8px 22px rgba(0,0,0,.06);overflow:hidden;transition:.2s;display:flex;flex-direction:column}
  .card:hover{transform:translateY(-2px)}
  .thumb{height:130px;background:#eee center/cover no-repeat}
  .content{padding:12px}
  .name{font-weight:700;margin:0 0 6px;font-size:16px}
  .meta{color:var(--muted);font-size:13px}
  .badge{display:inline-block;margin-top:8px;padding:3px 10px;border-radius:999px;font-size:12px}
  .ok{background:#e9ffe9;color:var(--ok)}
  .bad{background:#ffe9e9;color:var(--bad)}
  a.card-link{color:inherit;text-decoration:none}
</style>
</head>
<body>
<div class="wrap">
  <h1>الأقسام</h1>

  <div class="grid">
    <?php if (empty($cats)): ?>
      <div style="grid-column:1/-1;text-align:center;color:#888;padding:20px">لا توجد أقسام حالياً.</div>
    <?php else: ?>
      <?php foreach ($cats as $c): 
        $href = 'category_report.php?category_id=' . urlencode($c['id']);
        $img  = trim((string)$c['photo']);
        $maint = (string)$c['maintenance'] === '1';
      ?>
        <a class="card-link" href="<?= htmlspecialchars($href) ?>">
          <div class="card">
            <div class="thumb" style="background-image:url('<?= htmlspecialchars($img) ?>')"></div>
            <div class="content">
              <div class="name"><?= htmlspecialchars($c['name']) ?></div>
              <div class="meta"><?= htmlspecialchars($c['category_e']) ?></div>
              <span class="badge <?= $maint?'bad':'ok' ?>"><?= $maint?'صيانة':'جاهز' ?></span>
            </div>
          </div>
        </a>
      <?php endforeach; ?>
    <?php endif; ?>
  </div>
</div>
</body>
</html>
